/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mixin_support.ItemEntityExtensor;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkModule;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedFormManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedVariableModule;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.serialization.BCSerializers;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion.MonstrousScorpionBlackForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion.MonstrousScorpionBrownForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion.MonstrousScorpionForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion.MonstrousScorpionPsyche;
import bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion.MonstrousScorpionSandyForm;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class MonstrousScorpion
extends SmartyMob {
    public static final int CLAW_ATTACK_IDENTIFIER = 1;
    public static final float COMBAT_SPEED = 1.2f;
    public static final float ATTACK_RANGE = 1.4f;
    public static final float CLAW_ATTACK_RANGE = 0.9f;
    public static final int CLAW_ATTACK_DELAY_MIN = 60;
    public static final int CLAW_ATTACK_DELAY_MAX = 85;
    public static final int ATTACK_DELAY_MIN = 18;
    public static final int ATTACK_DELAY_MAX = 25;
    public static final MonstrousScorpionForm SANDY_FORM = new MonstrousScorpionSandyForm();
    public static final MonstrousScorpionForm BLACK_FORM = new MonstrousScorpionBlackForm();
    public static final MonstrousScorpionForm BROWN_FORM = new MonstrousScorpionBrownForm();
    public static final IndexedFormManager FORMS = IndexedFormManager.builder().add((Form)SANDY_FORM).add((Form)BLACK_FORM).add((Form)BROWN_FORM).create();
    public static final EntityDataReference<IntScheduler.Ranged> ATTACK_DELAY_REF = BCDataManager.attribute(MonstrousScorpion.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)18, (int)25), (String)"attack_delay"));
    public static final EntityDataReference<IntScheduler.Ranged> CLAW_ATTACK_DELAY_REF = BCDataManager.attribute(MonstrousScorpion.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)60, (int)85), (String)"claw_attack_delay"));
    public static final SimpleAnimation STING = new SimpleAnimation(15);
    public static final SimpleAnimation RIGHT_CLAW_ATTACk = new SimpleAnimation(15).identifier(1);
    public static final SimpleAnimation LEFT_CLAW_ATTACk = new SimpleAnimation(15).identifier(1);
    public static final SimpleAnimation BOTH_CLAWS_ATTACK = new SimpleAnimation(15).identifier(1);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{STING, RIGHT_CLAW_ATTACk, LEFT_CLAW_ATTACk, BOTH_CLAWS_ATTACK});
    public final EntityData<IntScheduler.Ranged> attackDelay;
    public final EntityData<IntScheduler.Ranged> clawAttackDelay;

    public MonstrousScorpion(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
        this.f_19793_ = 1.0f;
        this.attackDelay = this.bcDataManager().addNonSyncedData(EntityData.of(ATTACK_DELAY_REF));
        this.clawAttackDelay = this.bcDataManager().addNonSyncedData(EntityData.of(CLAW_ATTACK_DELAY_REF));
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22278_, 0.7).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.24);
    }

    public static boolean spawnPlacement(EntityType<? extends MonstrousScorpion> entityType, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)level, (BlockPos)pos, (Random)random) && MonstrousScorpion.m_21400_(entityType, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    protected void commonInit() {
        super.commonInit();
        this.variableModule = new IndexedVariableModule((LivingEntity)this, FORMS);
        this.loopedWalkModule = new LoopedWalkModule((LivingEntity)this);
    }

    public AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public Psyche<?> makePsyche() {
        return new MonstrousScorpionPsyche(this);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public Form<?> chooseVariant() {
        Biome.BiomeCategory biomeCategory = Biome.m_204183_((Holder)this.f_19853_.m_204166_(this.m_142538_()));
        if (biomeCategory == Biome.BiomeCategory.JUNGLE) {
            return BLACK_FORM;
        }
        if (biomeCategory == Biome.BiomeCategory.DESERT) {
            return SANDY_FORM;
        }
        return BROWN_FORM;
    }

    public boolean m_147207_(MobEffectInstance effectInstance, Entity entityIn) {
        Optional op = Registry.f_122823_.m_203300_(MobEffect.m_19459_((MobEffect)effectInstance.m_19544_()));
        return super.m_147207_(effectInstance, entityIn);
    }

    public void playLoopStepSound(BlockPos pos, BlockState blockIn) {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_INSECT_STEP.get(), SoundSource.HOSTILE, 0.1f + 0.07f * this.f_19796_.nextFloat(), 0.8f + 0.2f * this.f_19796_.nextFloat());
    }

    public float getLoopWalkMultiplier() {
        return 0.6f;
    }

    public float hurtLoopLimbSwingFactor() {
        return 0.7f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DESounds.ES_BLACK_SCORPION_HURT.get();
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack itemStack, float idk) {
        if (itemStack.m_41720_() == DEItems.SCORPION_GLAND.get()) {
            if (itemStack.m_41619_()) {
                return null;
            }
            if (this.f_19853_.f_46443_) {
                return null;
            }
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)idk, this.m_20189_(), itemStack);
            itementity.m_32060_();
            ((ItemEntityExtensor)itementity).setShowingModel((Enum)((MonstrousScorpionForm)this.variableModule().getForm()).gland());
            if (this.captureDrops() != null) {
                this.captureDrops().add(itementity);
            } else {
                this.f_19853_.m_7967_((Entity)itementity);
            }
            return itementity;
        }
        return super.m_5552_(itemStack, idk);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)DESounds.ES_BLACK_SCORPION_DEATH.get();
    }

    public static SimpleAnimation[] getClawAttackAnimations() {
        return new SimpleAnimation[]{RIGHT_CLAW_ATTACk, LEFT_CLAW_ATTACk, BOTH_CLAWS_ATTACK};
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }
}

