/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.klifour;

import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.extras.BCAABBs;
import bottomtextdanny.braincell.mod.entity.psyche.extras.TargetConsumers;
import bottomtextdanny.braincell.mod.entity.psyche.extras.TargetSideReaction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.klifour.Klifour;
import bottomtextdanny.dannys_expansion.content.entities.projectile.KlifourSpit;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.Shapes;

public class KlifourPsyche
extends Psyche<Klifour> {
    public static final int ATTACH_CHECK_INTERVAL = 8;
    public static final int MAIN_MODULE = 1;
    public static final int ATTACK_ACTIONS_MODULE = 2;
    public static final int IDLE_ACTIONS_MODULE = 3;
    public static final int HEAL_MODULE = 4;
    private static final TargetSideReaction<Klifour> AGGRO_PEER = (mob, targeter, target) -> {
        LivingEntity actualTarget = mob.m_5448_();
        if (!CombatHelper.isValidAttackTarget((Mob)mob, (LivingEntity)actualTarget)) {
            mob.m_21561_(true);
            mob.m_6710_(target);
        }
    };
    private static final MobMatchPredicate<LivingEntity> NOT_KLIFOUR = ((MobMatchPredicate)(mob, target) -> !(target instanceof Klifour)).and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS);
    private SpitAction spitTargetAction;
    private ScrubAction scrubAction;
    private HideAction hideAction;
    private UnhideAction unhideAction;
    private NauseaAction nauseaAction;
    private LookRandomlyAction lookRandomlyAction;
    private int blockUpdate;

    public KlifourPsyche(Klifour mob) {
        super((PathfinderMob)mob);
        this.allocateModules(5);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)40));
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> unseenTimer);
    }

    protected void initialize() {
        this.spitTargetAction = new SpitAction((Klifour)this.getMob());
        this.scrubAction = new ScrubAction((Klifour)this.getMob());
        this.nauseaAction = new NauseaAction((Klifour)this.getMob());
        this.nauseaAction.addBlockedModule(2);
        this.hideAction = new HideAction((Klifour)this.getMob());
        this.hideAction.addBlockedModule(2);
        this.unhideAction = new UnhideAction((Klifour)this.getMob());
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)120, (int)160)).vertical(FloatMappers.of((float)-0.28f, (float)0.15f));
        this.lookRandomlyAction.addModule(3);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Klifour)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            boolean hidden = mobo.isHidden();
            boolean validTarget = CombatHelper.isValidAttackTarget((Mob)mobo, (LivingEntity)target);
            boolean hiding = mobo.hideHandler.isPlaying((Animation)Klifour.HIDE);
            boolean showingUp = mobo.hideHandler.isPlaying((Animation)Klifour.SHOW_UP);
            if (hidden) {
                this.hidden((Klifour)((Object)mobo));
            } else if (!hiding && !showingUp) {
                this.unhidden((Klifour)((Object)mobo));
                if (!validTarget) {
                    this.idle((Klifour)((Object)mobo));
                }
            }
            if (validTarget && !hiding && !showingUp) {
                this.targeting((Klifour)((Object)mobo), target, hidden);
            }
            this.handlePosition((Klifour)((Object)mobo));
            if (this.blockUpdate == 0) {
                this.blockUpdate = 8;
                this.checkAttachingBlock((Klifour)((Object)mobo));
            } else {
                --this.blockUpdate;
            }
            mobo.syncHiddenState();
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), NOT_KLIFOUR).findTargetCallOut(TargetConsumers.entityGroupAction(Klifour.class, targeter -> BCAABBs.livingEntityRange((LivingEntity)targeter, (double)20.0, (double)10.0), AGGRO_PEER)));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Klifour)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
    }

    private void handlePosition(Klifour mob) {
        int xL = mob.getXLocation();
        int yL = mob.getYLocation();
        int zL = mob.getZLocation();
        Direction direction = mob.getAttachingDirection();
        if (mob.getAttachingLocation() == BlockPos.f_121853_) {
            mob.setLocation(mob.m_142538_());
        }
        if (direction.m_122411_() == 0) {
            mob.m_6034_((float)xL + 0.5f, (double)yL + 0.0, (float)zL + 0.5f);
        } else if (direction.m_122411_() == 1) {
            mob.m_6034_((float)xL + 0.5f, (double)yL + 0.5, (float)zL + 0.5f);
        } else {
            mob.m_6034_((float)xL + 0.5f, (double)yL + 0.25, (float)zL + 0.5f);
        }
        mob.m_20242_(true);
    }

    public void checkAttachingBlock(Klifour mob) {
        BlockPos pos = mob.m_142538_();
        BlockPos attachPos = mob.getAttachingBlock();
        if (mob.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13035_)) {
            mob.f_19853_.m_46961_(pos, false);
        }
        if (!mob.f_19853_.m_8055_(attachPos).m_60812_((BlockGetter)mob.f_19853_, attachPos).equals(Shapes.m_83144_())) {
            mob.m_6074_();
        }
    }

    public void hidden(Klifour mob) {
        IntScheduler.Ranged timer = mob.getUnhideTimer();
        this.tryClearBadEffects(mob);
        if (this.unhideAction.isRunning()) {
            return;
        }
        if (timer.hasEnded()) {
            this.tryAddRunningAction(1, (Action)this.unhideAction);
            if (this.unhideAction.isRunning()) {
                timer.reset(FloatRandomPicker.normal());
            }
        } else {
            timer.incrementFreely(1);
        }
    }

    private void tryClearBadEffects(Klifour mob) {
        if (((Klifour)this.getMob()).isNauseous()) {
            mob.m_21220_().removeIf(effectInstance -> effectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
            mob.m_21210_();
            mob.setNauseous(false);
        }
    }

    public void idle(Klifour mob) {
        this.tryAddRunningAction(3, (Action)this.lookRandomlyAction);
    }

    public void unhidden(Klifour mob) {
        IntScheduler.Ranged timer = mob.getHideTimer();
        if (mob.hasBadEffects()) {
            this.tryAddRunningAction(1, (Action)this.nauseaAction);
            if (this.nauseaAction.isRunning()) {
                mob.setNauseous(true);
            }
        }
        if (!this.hideAction.isRunning()) {
            if (timer.hasEnded() || !this.nauseaAction.isRunning() && mob.isNauseous()) {
                this.tryAddRunningAction(1, (Action)this.hideAction);
                if (this.hideAction.isRunning()) {
                    timer.reset(FloatRandomPicker.normal());
                }
            } else {
                timer.incrementFreely(1);
            }
        }
    }

    public void targeting(Klifour mob, @Nonnull LivingEntity target, boolean hidden) {
        float reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::euclideanEntityReach3);
        this.blockModule(3);
        IntScheduler.Ranged spit = mob.getSpitTimer();
        spit.advance();
        if (!hidden) {
            if (reach < 0.24000001f) {
                this.tryAddRunningAction(2, (Action)this.scrubAction);
            }
            if (mob.m_21574_().m_148306_((Entity)target) && spit.hasEnded()) {
                this.tryAddRunningAction(2, (Action)this.spitTargetAction);
                spit.reset(FloatRandomPicker.normal());
            }
        }
        mob.m_21563_().m_24960_((Entity)target, 5.0f, 90.0f);
    }

    public static final class SpitAction
    extends AnimationAction<Klifour, SimpleAnimation> {
        public SpitAction(Klifour mob) {
            super((PathfinderMob)mob, (Animation)Klifour.SPIT, mob.mainHandler);
        }

        public boolean canStart() {
            return super.canStart() && this.animationHandler.isPlayingNull();
        }

        public void update() {
            Random random = ((Klifour)this.mob).m_21187_();
            LivingEntity target = ((Klifour)this.mob).m_5448_();
            if (!CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                return;
            }
            ((Klifour)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.animationHandler.getTick() == 4) {
                ((Klifour)this.mob).m_5496_((SoundEvent)DESounds.ES_KLIFOUR_SPIT.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 6) {
                KlifourSpit spit = (KlifourSpit)((EntityType)DEEntities.KLIFOUR_SPIT.get()).m_20615_(((Klifour)this.mob).f_19853_);
                if (spit == null) {
                    return;
                }
                spit.m_6034_(((Klifour)this.mob).m_20185_(), ((Klifour)this.mob).m_20188_(), ((Klifour)this.mob).m_20189_());
                spit.m_146926_(((Klifour)this.mob).m_146909_());
                spit.m_146922_(((Klifour)this.mob).m_6080_());
                spit.setCaster((LivingEntity)this.mob);
                ((Klifour)this.mob).f_19853_.m_7967_((Entity)spit);
            }
        }
    }

    public static final class ScrubAction
    extends AnimationAction<Klifour, SimpleAnimation> {
        public ScrubAction(Klifour mob) {
            super((PathfinderMob)mob, (Animation)Klifour.SCRUB, mob.mainHandler);
        }

        public boolean canStart() {
            return super.canStart() && this.animationHandler.isPlayingNull();
        }

        public void update() {
            float reach;
            Random random = ((Klifour)this.mob).m_21187_();
            LivingEntity target = ((Klifour)this.mob).m_5448_();
            if (!CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                return;
            }
            ((Klifour)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.animationHandler.getTick() == 1) {
                ((Klifour)this.mob).m_5496_((SoundEvent)DESounds.ES_KLIFOUR_SCRUB.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 5 && (reach = ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::euclideanEntityReach3)) < 0.3f) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, ((Klifour)this.mob).f_19853_.m_46791_().m_19028_() - 1));
            }
        }
    }

    public static final class NauseaAction
    extends AnimationAction<Klifour, SimpleAnimation> {
        public NauseaAction(Klifour mob) {
            super((PathfinderMob)mob, (Animation)Klifour.NAUSEA, mob.hideHandler);
        }

        public boolean canStart() {
            return super.canStart() && this.animationHandler.isPlayingNull() && !((Klifour)this.mob).isHidden();
        }

        public void onEnd() {
            super.onEnd();
            if (!((Klifour)this.mob).isHidden()) {
                ((Klifour)this.mob).getHideTimer().end();
            }
        }
    }

    public static final class HideAction
    extends AnimationAction<Klifour, SimpleAnimation> {
        public HideAction(Klifour mob) {
            super((PathfinderMob)mob, (Animation)Klifour.HIDE, mob.hideHandler);
        }

        public boolean canStart() {
            return super.canStart();
        }

        public void update() {
            if (this.animationHandler.getTick() == 1) {
                Random random = ((Klifour)this.mob).m_21187_();
                ((Klifour)this.mob).m_5496_((SoundEvent)DESounds.ES_KLIFOUR_HIDE.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == Klifour.HIDE.getDuration() - 5) {
                ((Klifour)this.mob).setHidden(true);
            }
        }
    }

    public static final class UnhideAction
    extends AnimationAction<Klifour, SimpleAnimation> {
        public UnhideAction(Klifour mob) {
            super((PathfinderMob)mob, (Animation)Klifour.SHOW_UP, mob.hideHandler);
        }

        public boolean canStart() {
            return super.canStart();
        }

        protected void start() {
            super.start();
            ((Klifour)this.mob).setHidden(false);
        }

        public void update() {
            if (this.animationHandler.getTick() == 1) {
                Random random = ((Klifour)this.mob).m_21187_();
                ((Klifour)this.mob).m_5496_((SoundEvent)DESounds.ES_KLIFOUR_SHOW_UP.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            }
        }
    }
}

