/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.klifour;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.serialization.BCSerializers;
import bottomtextdanny.braincell.mod.world.builtin_items.BCSpawnEggItem;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.klifour.KlifourPsyche;
import bottomtextdanny.dannys_expansion.tables.DEBlocks;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Klifour
extends SmartyMob {
    private static final int TICK_INFORMATION_CALL_FLAG = 0;
    private static final int ATTACH_DIRECTION_CALL_FLAG = 1;
    public static final float SCRUB_REACH = 0.3f;
    public static final int HIDDEN_TIME_MIN = 120;
    public static final int HIDDEN_TIME_MAX = 280;
    public static final int UNHIDDEN_TIME_MIN = 150;
    public static final int UNHIDDEN_TIME_MAX = 300;
    public static final int SPIT_TIME_MIN = 80;
    public static final int SPIT_TIME_MAX = 100;
    public static final BCSpawnEggItem.SpawnLogic EGG_LOGIC = (type, world, direction, blockPos, itemStack, player) -> {
        BlockState blockState = world.m_8055_(blockPos);
        BlockPos blockPos1 = blockState.m_60812_((BlockGetter)world, blockPos).m_83281_() ? blockPos : blockPos.m_142300_(direction);
        Klifour entity = (Klifour)type.m_20592_((ServerLevel)world, itemStack, player, blockPos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos1) && direction == Direction.UP);
        if (entity != null) {
            entity.setAttachingDirection(direction.m_122424_());
            entity.syncAttachingDirection();
            itemStack.m_41774_(1);
        }
    };
    public static final EntityDataReference<IntScheduler.Ranged> HIDE_TIMER_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)120, (int)280), (String)"hide_timer"));
    public static final EntityDataReference<IntScheduler.Ranged> UNHIDE_TIMER_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)150, (int)300), (String)"unhide_timer"));
    public static final EntityDataReference<IntScheduler.Ranged> SPIT_TIMER_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)80, (int)100), (String)"spit_timer"));
    public static final EntityDataReference<BlockPos> ATTACHING_LOCATION_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BLOCK_POS, () -> BlockPos.f_121853_, (String)"attaching_location"));
    public static final EntityDataReference<Direction> ATTACHING_DIRECTION_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.DIRECTION, () -> Direction.DOWN, (String)"attaching_direction"));
    public static final EntityDataReference<Boolean> HIDDEN_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BOOLEAN, () -> false, (String)"hidden"));
    public static final EntityDataReference<Boolean> NAUSEOUS_REF = BCDataManager.attribute(Klifour.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BOOLEAN, () -> false, (String)"nauseous"));
    public static final SimpleAnimation DEATH = new SimpleAnimation(20);
    public static final SimpleAnimation NAUSEA = new SimpleAnimation(54);
    public static final SimpleAnimation SHOW_UP = new SimpleAnimation(20);
    public static final SimpleAnimation HIDE = new SimpleAnimation(15);
    public static final SimpleAnimation SPIT = new SimpleAnimation(20);
    public static final SimpleAnimation SCRUB = new SimpleAnimation(20);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{DEATH, NAUSEA, SHOW_UP, HIDE, SPIT, SCRUB});
    public AnimationHandler<?> hideHandler;
    private final EntityData<IntScheduler.Ranged> hideTimer;
    private final EntityData<IntScheduler.Ranged> unhideTimer;
    private final EntityData<IntScheduler.Ranged> spitTimer;
    private final EntityData<BlockPos> attachingLocation;
    private final EntityData<Direction> attachingDirection;
    private final EntityData<Boolean> hidden;
    private final EntityData<Boolean> nauseous;

    public Klifour(EntityType<? extends Klifour> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
        this.hideTimer = this.bcDataManager().addNonSyncedData(EntityData.of(HIDE_TIMER_REF));
        this.unhideTimer = this.bcDataManager().addNonSyncedData(EntityData.of(UNHIDE_TIMER_REF));
        this.spitTimer = this.bcDataManager().addNonSyncedData(EntityData.of(SPIT_TIMER_REF));
        this.attachingLocation = this.bcDataManager().addNonSyncedData(EntityData.of(ATTACHING_LOCATION_REF));
        this.attachingDirection = this.bcDataManager().addSyncedData(EntityData.of(ATTACHING_DIRECTION_REF));
        this.hidden = this.bcDataManager().addNonSyncedData(EntityData.of(HIDDEN_REF));
        this.nauseous = this.bcDataManager().addNonSyncedData(EntityData.of(NAUSEOUS_REF));
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void commonInit() {
        this.hideHandler = new AnimationHandler((Entity)this);
        this.addAnimationHandler(this.hideHandler);
    }

    public AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public Psyche<?> makePsyche() {
        return new KlifourPsyche(this);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.setLocation(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
    }

    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            boolean sHidden = (Boolean)fetcher.get(0, Boolean.class);
            this.setHidden(sHidden);
        } else if (flag == 1) {
            Direction sDirection = (Direction)fetcher.get(0, Direction.class);
            this.setAttachingDirection(sDirection);
        }
    }

    public void syncHiddenState() {
        this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.BOOLEAN, (Object)this.isHidden())});
    }

    public void syncAttachingDirection() {
        this.sendClientMsg(1, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.DIRECTION, (Object)this.getAttachingDirection())});
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (this.f_19853_.m_8055_(this.getAttachingBlock()).m_60734_() == DEBlocks.PLANT_MATTER.get()) {
            List hangingKlifours = this.f_19853_.m_45976_(Klifour.class, new AABB(this.getAttachingBlock()).m_82400_(1.0));
            boolean validator = true;
            for (Klifour klifour : hangingKlifours) {
                if (klifour == this || !klifour.getAttachingBlock().equals((Object)this.getAttachingBlock())) continue;
                validator = false;
                break;
            }
            if (validator) {
                this.f_19853_.m_46961_(this.getAttachingBlock(), false);
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.25f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_142582_(Entity entityIn) {
        return !this.isHidden() && super.m_142582_(entityIn);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5801_() {
        return !this.isHidden();
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6087_() {
        return !this.isHidden();
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public void m_21210_() {
        super.m_21210_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DESounds.ES_KLIFOUR_HURT.get();
    }

    @Nullable
    public Animation<?> getDeathAnimation() {
        return DEATH;
    }

    public void setAttachingDirection(Direction value) {
        this.attachingDirection.set((Object)value);
    }

    public void setHidden(boolean value) {
        this.hidden.set((Object)value);
    }

    public void setNauseous(boolean value) {
        this.nauseous.set((Object)value);
    }

    public void setLocation(int x, int y, int z) {
        this.attachingLocation.set((Object)new BlockPos(x, y, z));
    }

    public void setLocation(BlockPos value) {
        this.attachingLocation.set((Object)value);
    }

    public boolean hasBadEffects() {
        return this.m_21220_().stream().anyMatch(effectInstance -> effectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
    }

    public IntScheduler.Ranged getHideTimer() {
        return (IntScheduler.Ranged)this.hideTimer.get();
    }

    public IntScheduler.Ranged getUnhideTimer() {
        return (IntScheduler.Ranged)this.unhideTimer.get();
    }

    public IntScheduler.Ranged getSpitTimer() {
        return (IntScheduler.Ranged)this.spitTimer.get();
    }

    public BlockPos getAttachingBlock() {
        return this.m_142538_().m_142300_(this.getAttachingDirection());
    }

    public Direction getAttachingDirection() {
        return (Direction)this.attachingDirection.get();
    }

    public boolean isHidden() {
        return (Boolean)this.hidden.get();
    }

    public boolean isNauseous() {
        return (Boolean)this.nauseous.get();
    }

    public BlockPos getAttachingLocation() {
        return (BlockPos)this.attachingLocation.get();
    }

    public int getXLocation() {
        return ((BlockPos)this.attachingLocation.get()).m_123341_();
    }

    public int getYLocation() {
        return ((BlockPos)this.attachingLocation.get()).m_123342_();
    }

    public int getZLocation() {
        return ((BlockPos)this.attachingLocation.get()).m_123343_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }
}

