/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.hollowlet;

import bottomtextdanny.braincell.base.Chooser;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.WaterAvoidingRandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.Goblin;
import bottomtextdanny.dannys_expansion.content.entities.mob.hollowlet.Hollowlet;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Random;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;

public class HollowletPsyche
extends Psyche<Hollowlet> {
    public static final int MAIN_MODULE = 1;
    public static final int IDLE_ACTIONS_MODULE = 2;
    public static Chooser<Function<HollowletPsyche, Action<Hollowlet>>> ATTACKS = Chooser.builder().put(30.0f, psy -> psy.slashAction).put(20.0f, psy -> psy.horizontalSlashAction).put(10.0f, psy -> psy.stabAction).build();
    private SlashAttackAction slashAction;
    private HorizontalSlashAttackAction horizontalSlashAction;
    private StabAttackAction stabAction;
    private LookRandomlyAction lookRandomlyAction;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<Hollowlet> followTargetAction;
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)80));

    public HollowletPsyche(Hollowlet mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
        inputs.put(ActionInputKey.SET_TARGET_CALL, () -> ((IntScheduler.Ranged)((Hollowlet)this.getMob()).attackTimer.get()).end());
    }

    protected void initialize() {
        this.slashAction = new SlashAttackAction((Hollowlet)this.getMob());
        this.slashAction.addBlockedModule(2);
        this.horizontalSlashAction = new HorizontalSlashAttackAction((Hollowlet)this.getMob());
        this.horizontalSlashAction.addBlockedModule(2);
        this.stabAction = new StabAttackAction((Hollowlet)this.getMob());
        this.stabAction.addBlockedModule(2);
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((Hollowlet)this.getMob()), target -> 1.5).setRefreshRate(10);
        this.followTargetAction.addBlockedModule(2);
        this.randomStrollAction = new WaterAvoidingRandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)220, (int)320));
        this.randomStrollAction.addModule(2);
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)120, (int)160)).vertical(FloatMappers.of((float)-0.28f, (float)0.15f));
        this.lookRandomlyAction.addModule(2);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Hollowlet)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            mobo.setInputMovementMultiplier(0.0f);
            if (CombatHelper.isValidAttackTarget((Mob)mobo, (LivingEntity)target)) {
                this.onTargeting((Hollowlet)((Object)mobo), target);
            } else {
                this.idling((Hollowlet)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Hollowlet)this.getMob()), (IntScheduler)IntScheduler.simple((int)4), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Hollowlet)this.getMob()), (IntScheduler)IntScheduler.simple((int)25), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestOfType(Goblin.class)));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Hollowlet)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    protected void idling(Hollowlet mob) {
        this.tryAddRunningAction(2, (Action)this.randomStrollAction);
        this.tryAddRunningAction(2, (Action)this.lookRandomlyAction);
    }

    protected void onTargeting(Hollowlet mob, @Nonnull LivingEntity target) {
        float reach;
        IntScheduler.Ranged attackTimer = (IntScheduler.Ranged)mob.attackTimer.get();
        this.blockModule(2);
        this.tryAddRunningAction(1, (Action)this.followTargetAction);
        attackTimer.incrementFreely(1);
        if (attackTimer.hasEnded() && (reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::manhattanEntityReach3)) < 0.6f) {
            this.tryAddRunningAction(1, (Action)((Function)ATTACKS.pick((RandomGenerator)mob.m_21187_())).apply(this));
            attackTimer.reset();
        }
    }

    public static class SlashAttackAction
    extends AnimationAction<Hollowlet, SimpleAnimation> {
        public SlashAttackAction(Hollowlet mob) {
            super((PathfinderMob)mob, (Animation)Hollowlet.SLASH, mob.mainHandler);
        }

        public void update() {
            Random random = ((Hollowlet)this.mob).m_21187_();
            ((Hollowlet)this.mob).setInputMovementMultiplier(1.0f);
            LivingEntity target = ((Hollowlet)this.mob).m_5448_();
            if (this.animationHandler.getTick() == 7 && CombatHelper.isValidAttackTarget((Mob)this.mob, (LivingEntity)target)) {
                if (ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::manhattanEntityReach3) < 0.75f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f);
                    CombatHelper.mayDisableShield((Entity)target, (int)10, (float)0.4f);
                }
                ((Hollowlet)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else if (this.animationHandler.getTick() == 5) {
                ((Hollowlet)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_SMALL.get(), 1.0f, random.nextFloat(1.3f, 1.6f));
            }
            ((Hollowlet)this.mob).m_146922_(((Hollowlet)this.mob).f_20885_);
        }
    }

    public static class HorizontalSlashAttackAction
    extends AnimationAction<Hollowlet, SimpleAnimation> {
        public HorizontalSlashAttackAction(Hollowlet mob) {
            super((PathfinderMob)mob, (Animation)Hollowlet.HORIZONTAL_SLASH, mob.mainHandler);
        }

        public void update() {
            Random random = ((Hollowlet)this.mob).m_21187_();
            ((Hollowlet)this.mob).setInputMovementMultiplier(1.0f);
            LivingEntity target = ((Hollowlet)this.mob).m_5448_();
            if (this.animationHandler.getTick() == 7 && CombatHelper.isValidAttackTarget((Mob)this.mob, (LivingEntity)target)) {
                if (ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::manhattanEntityReach3) < 0.75f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.3f);
                    CombatHelper.mayDisableShield((Entity)target, (int)10, (float)0.4f);
                }
                ((Hollowlet)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else if (this.animationHandler.getTick() == 4) {
                ((Hollowlet)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_LARGE.get(), 1.0f, random.nextFloat(1.3f, 1.6f));
            }
            ((Hollowlet)this.mob).m_146922_(((Hollowlet)this.mob).f_20885_);
        }
    }

    public static class StabAttackAction
    extends AnimationAction<Hollowlet, SimpleAnimation> {
        public StabAttackAction(Hollowlet mob) {
            super((PathfinderMob)mob, (Animation)Hollowlet.STAB, mob.mainHandler);
        }

        public void update() {
            Random random = ((Hollowlet)this.mob).m_21187_();
            ((Hollowlet)this.mob).setInputMovementMultiplier(1.0f);
            LivingEntity target = ((Hollowlet)this.mob).m_5448_();
            if (this.animationHandler.getTick() == 8 && CombatHelper.isValidAttackTarget((Mob)this.mob, (LivingEntity)target)) {
                if (ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::manhattanEntityReach3) < 0.75f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.1f);
                    CombatHelper.mayDisableShield((Entity)target, (int)10, (float)0.4f);
                }
                ((Hollowlet)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else if (this.animationHandler.getTick() == 5) {
                ((Hollowlet)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_MODERATED.get(), 1.0f, random.nextFloat(1.3f, 1.6f));
            }
            ((Hollowlet)this.mob).m_146922_(((Hollowlet)this.mob).f_20885_);
        }
    }
}

