/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.hollow_armor;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.WaterAvoidingRandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.hollow_armor.HollowArmor;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class HollowArmorPsyche
extends Psyche<HollowArmor> {
    public static final int MAIN_MODULE = 1;
    public static final int ATTACK_ACTIONS_MODULE = 2;
    public static final int IDLE_ACTIONS_MODULE = 3;
    public static final int HEAL_MODULE = 4;
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)100));
    private BluntAttackAction bluntAttackAction;
    private SlashAttackAction slashAttackAction;
    private SwingAttackAction swingAttackAction;
    private DoubleSwingAttackAction doubleSwingAttackAction;
    private ImpaleAttackAction impaleAttackAction;
    private DashAction dashAction;
    private HealAction healAction;
    private LookRandomlyAction lookRandomlyAction;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<HollowArmor> followTargetAction;

    public HollowArmorPsyche(HollowArmor mob) {
        super((PathfinderMob)mob);
        this.allocateModules(4);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
        inputs.put(ActionInputKey.SET_TARGET_CALL, () -> {
            ((IntScheduler.Ranged)((HollowArmor)this.getMob()).attackTimer.get()).end();
            ((IntScheduler.Simple)((HollowArmor)this.getMob()).dashTimer.get()).reset();
            ((IntScheduler.Ranged)((HollowArmor)this.getMob()).lethalAttackTimer.get()).reset();
        });
    }

    protected void initialize() {
        this.healAction = new HealAction((HollowArmor)this.getMob());
        this.healAction.addBlockedModule(1);
        this.healAction.addBlockedModule(2);
        this.dashAction = new DashAction((HollowArmor)this.getMob());
        this.dashAction.addBlockedModule(1);
        this.bluntAttackAction = new BluntAttackAction((HollowArmor)this.getMob());
        this.bluntAttackAction.addBlockedModule(1);
        this.slashAttackAction = new SlashAttackAction((HollowArmor)this.getMob());
        this.slashAttackAction.addBlockedModule(1);
        this.swingAttackAction = new SwingAttackAction((HollowArmor)this.getMob());
        this.swingAttackAction.addBlockedModule(1);
        this.doubleSwingAttackAction = new DoubleSwingAttackAction((HollowArmor)this.getMob());
        this.doubleSwingAttackAction.addBlockedModule(1);
        this.impaleAttackAction = new ImpaleAttackAction((HollowArmor)this.getMob());
        this.impaleAttackAction.addBlockedModule(1);
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((HollowArmor)this.getMob()), target -> (double)1.2f).setRefreshRate(10);
        this.followTargetAction.addBlockedModule(3);
        this.randomStrollAction = new WaterAvoidingRandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)220, (int)320));
        this.randomStrollAction.addModule(3);
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)120, (int)160)).vertical(FloatMappers.of((float)-0.28f, (float)0.15f));
        this.lookRandomlyAction.addModule(3);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((HollowArmor)this.getMob()), mobo -> {
            if (((HollowArmor)this.getMob()).mainHandler.isPlayingNull() && !((Boolean)((HollowArmor)this.getMob()).healingUsed.get()).booleanValue() && CombatHelper.getHealthNormalized((Mob)this.getMob()) < 0.5f) {
                this.tryAddRunningAction(4, (Action)this.healAction);
            }
            if (((HollowArmor)this.getMob()).m_5448_() != null) {
                if (((HollowArmor)this.getMob()).mainHandler.isPlayingNull()) {
                    float reach = ReachHelper.reachSqr((PathfinderMob)this.getMob(), (Entity)((HollowArmor)this.getMob()).m_5448_());
                    if (reach < 2.0f) {
                        if (((IntScheduler.Ranged)((HollowArmor)this.getMob()).lethalAttackTimer.get()).hasEnded()) {
                            this.tryAddRunningAction(2, (Action)this.impaleAttackAction);
                            ((IntScheduler.Ranged)((HollowArmor)this.getMob()).lethalAttackTimer.get()).reset();
                        } else {
                            if (((IntScheduler.Ranged)((HollowArmor)this.getMob()).attackTimer.get()).hasEnded()) {
                                float rgn = ((HollowArmor)this.getMob()).m_21187_().nextFloat();
                                if (rgn < 0.15f) {
                                    this.tryAddRunningAction(2, (Action)this.doubleSwingAttackAction);
                                } else if (rgn < 0.4f) {
                                    this.tryAddRunningAction(2, (Action)this.bluntAttackAction);
                                } else if (rgn < 0.65f) {
                                    this.tryAddRunningAction(2, (Action)this.slashAttackAction);
                                } else {
                                    this.tryAddRunningAction(2, (Action)this.swingAttackAction);
                                }
                                ((IntScheduler.Ranged)((HollowArmor)this.getMob()).attackTimer.get()).reset();
                            } else {
                                ((IntScheduler.Ranged)((HollowArmor)this.getMob()).attackTimer.get()).advance();
                            }
                            ((IntScheduler.Ranged)((HollowArmor)this.getMob()).lethalAttackTimer.get()).advance();
                        }
                    } else if (reach > 7.0f && ((IntScheduler.Simple)((HollowArmor)this.getMob()).dashTimer.get()).hasEnded()) {
                        this.tryAddRunningAction(2, (Action)this.dashAction);
                        ((IntScheduler.Simple)((HollowArmor)this.getMob()).dashTimer.get()).reset();
                    }
                }
                ((IntScheduler.Simple)((HollowArmor)this.getMob()).dashTimer.get()).advance();
                this.tryAddRunningAction(1, (Action)this.followTargetAction);
            } else {
                this.tryAddRunningAction(1, (Action)this.randomStrollAction);
                this.tryAddRunningAction(1, (Action)this.lookRandomlyAction);
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((HollowArmor)this.getMob()), (IntScheduler)IntScheduler.simple((int)4), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((HollowArmor)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    public static class HealAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        public HealAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.HEAL, mob.mainHandler);
        }

        public void update() {
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            for (int drinkTicks = 0; drinkTicks < 3; ++drinkTicks) {
                if (this.animationHandler.getTick() != 12 + (drinkTicks << 1)) continue;
                ((HollowArmor)this.mob).m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
            }
            if (this.animationHandler.getTick() == 18) {
                ((HollowArmor)this.mob).healingUsed.set((Object)true);
                ((HollowArmor)this.mob).m_21153_(((HollowArmor)this.mob).m_21223_() + 10.0f);
            }
        }
    }

    public static class DashAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        private boolean didDamage;

        public DashAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.DASH, mob.mainHandler);
        }

        public void update() {
            Random random = ((HollowArmor)this.mob).m_21187_();
            Vec3 vecToTarget = Vec3.f_82478_;
            float distance = 2.0f;
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            if (((HollowArmor)this.mob).m_5448_() != null) {
                LivingEntity target = ((HollowArmor)this.mob).m_5448_();
                distance = ReachHelper.horizontalReach((PathfinderMob)this.mob, (Entity)target) + 0.5f;
                ((HollowArmor)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (this.animationHandler.getTick() == 19) {
                    vecToTarget = DEMath.fromPitchYaw(0.0f, DEMath.getTargetYaw((Entity)this.mob, (Entity)target));
                }
                if (this.animationHandler.getTick() >= 20 && this.animationHandler.getTick() <= 32 && !this.didDamage && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 5.0f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.2f);
                    CombatHelper.disableShield((Entity)target, (int)30);
                    this.didDamage = true;
                }
            } else if (this.animationHandler.getTick() == 19) {
                vecToTarget = DEMath.fromPitchYaw(0.0f, ((HollowArmor)this.mob).f_20885_);
            }
            if (this.animationHandler.getTick() < 27) {
                ((HollowArmor)this.mob).m_146922_(((HollowArmor)this.mob).f_20885_);
                ((HollowArmor)this.mob).f_20883_ = ((HollowArmor)this.mob).f_20885_;
            }
            if (this.animationHandler.getTick() == 4) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_HEAVY_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 19) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_LARGE.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
                ((HollowArmor)this.mob).sendClientMsg(0, PacketDistributor.TRACKING_ENTITY.with(() -> this.mob), new WorldPacketData[0]);
            }
            if (this.animationHandler.getTick() == 19) {
                ((HollowArmor)this.mob).getDashMotion().setMotion(vecToTarget.m_82542_((double)distance, 0.0, (double)distance));
            }
        }

        public void onEnd() {
            super.onEnd();
            this.didDamage = false;
        }
    }

    public static class BluntAttackAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        public BluntAttackAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.BLUNT, mob.mainHandler);
        }

        public void update() {
            Random random = ((HollowArmor)this.mob).m_21187_();
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            this.getPsyche().blockModule(1);
            LivingEntity target = ((HollowArmor)this.mob).m_5448_();
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (this.animationHandler.getTick() == 9 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 3.0f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f);
                    CombatHelper.mayDisableShield((Entity)target, (int)20, (float)0.25f);
                }
                ((HollowArmor)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            ((HollowArmor)this.mob).m_146922_(((HollowArmor)this.mob).f_20885_);
            if (this.animationHandler.getTick() == 1) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 6) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_THIN_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 7) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_MODERATED.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 8) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            }
        }
    }

    public static class SlashAttackAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        public SlashAttackAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.SLASH, mob.mainHandler);
        }

        public void update() {
            Random random = ((HollowArmor)this.mob).m_21187_();
            LivingEntity target = ((HollowArmor)this.mob).m_5448_();
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (this.animationHandler.getTick() == 10 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 3.0f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.1f);
                    CombatHelper.mayDisableShield((Entity)target, (int)20, (float)0.25f);
                }
                ((HollowArmor)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            ((HollowArmor)this.mob).m_146922_(((HollowArmor)this.mob).f_20885_);
            if (this.animationHandler.getTick() == 1) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 7) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 8) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_LARGE.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
            }
        }
    }

    public static class SwingAttackAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        public SwingAttackAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.SWING, mob.mainHandler);
        }

        public void update() {
            Random random = ((HollowArmor)this.mob).m_21187_();
            LivingEntity target = ((HollowArmor)this.mob).m_5448_();
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (this.animationHandler.getTick() == 8 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 3.0f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.15f);
                    CombatHelper.mayDisableShield((Entity)target, (int)20, (float)0.25f);
                }
                ((HollowArmor)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            ((HollowArmor)this.mob).m_146922_(((HollowArmor)this.mob).f_20885_);
            if (this.animationHandler.getTick() == 1) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 4) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 7) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_MODERATED.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
            }
        }
    }

    public static class DoubleSwingAttackAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        public DoubleSwingAttackAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.DOUBLE_SWING, mob.mainHandler);
        }

        public void update() {
            Random random = ((HollowArmor)this.mob).m_21187_();
            LivingEntity target = ((HollowArmor)this.mob).m_5448_();
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 3.0f) {
                    if (this.animationHandler.getTick() == 10) {
                        CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f);
                        CombatHelper.mayDisableShield((Entity)target, (int)20, (float)0.25f);
                        target.f_19802_ = 0;
                    } else if (this.animationHandler.getTick() == 14) {
                        CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f);
                        CombatHelper.disableShield((Entity)target, (int)20);
                    }
                }
                ((HollowArmor)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            ((HollowArmor)this.mob).m_146922_(((HollowArmor)this.mob).f_20885_);
            if (this.animationHandler.getTick() == 1) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 6 || this.animationHandler.getTick() == 12) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_SMALL.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_THIN_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 7) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            }
        }
    }

    public static class ImpaleAttackAction
    extends AnimationAction<HollowArmor, SimpleAnimation> {
        public ImpaleAttackAction(HollowArmor mob) {
            super((PathfinderMob)mob, (Animation)HollowArmor.IMPALE, mob.mainHandler);
        }

        public void update() {
            Random random = ((HollowArmor)this.mob).m_21187_();
            LivingEntity target = ((HollowArmor)this.mob).m_5448_();
            ((HollowArmor)this.mob).setInputMovementMultiplier(0.0f);
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (this.animationHandler.getTick() == 16 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 3.6f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.4f);
                    CombatHelper.disableShield((Entity)target, (int)40);
                }
                ((HollowArmor)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            ((HollowArmor)this.mob).m_146922_(((HollowArmor)this.mob).f_20885_);
            if (this.animationHandler.getTick() == 4) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_HEAVY_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 7) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_HARD_STEP.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 16) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_THIN_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 14) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_BLADE_SWING_LARGE.get(), 1.5f, 1.0f + random.nextFloat() * 0.2f);
            } else if (this.animationHandler.getTick() == 15) {
                ((HollowArmor)this.mob).m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_CREAK.get(), 1.0f, 1.0f + random.nextFloat() * 0.2f);
            }
        }
    }
}

