/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.hollow_armor;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.capability.CapabilityHelper;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExternalMotion;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionModule;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionProvider;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkModule;
import bottomtextdanny.braincell.mod.entity.modules.motion_util.MotionUtilProvider;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.braincell.mod.serialization.BCSerializers;
import bottomtextdanny.braincell.mod.world.builtin_sound_instances.EntityMovingSound;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelCapability;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelPhaseModule;
import bottomtextdanny.dannys_expansion._util.EffectHelper;
import bottomtextdanny.dannys_expansion.content.entities._modules.phase_affected_provider.PhaseAffectedModule;
import bottomtextdanny.dannys_expansion.content.entities._modules.phase_affected_provider.PhaseAffectedProvider;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.hollow_armor.HollowArmorPsyche;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HollowArmor
extends SmartyMob
implements Enemy,
MotionUtilProvider,
ExtraMotionProvider,
PhaseAffectedProvider {
    public static final float START_DASHING_RANGE = 7.0f;
    public static final float ATTACK_RANGE = 2.0f;
    public static final int PLAY_DASH_SOUND_CLIENT_CALL = 0;
    public static final float COMBAT_MOVE_SPEED = 1.2f;
    public static final int LETHAL_ATTACK_DELAY_MIN = 60;
    public static final int LETHAL_ATTACK_DELAY_MAX = 85;
    public static final int ATTACK_DELAY_MIN = 20;
    public static final int ATTACK_DELAY_MAX = 25;
    public static final int DEFAULT_DASH_DELAY = 160;
    @OnlyIn(value=Dist.CLIENT)
    public static final int BUBBLE_LOOP_TICKS = 240;
    @OnlyIn(value=Dist.CLIENT)
    public static final float BUBBLE_APPEARING_RATIO = 0.3f;
    @OnlyIn(value=Dist.CLIENT)
    public static final float BUBBLE_APPEAR_RARITY = 0.15f;
    public static final EntityDataReference<IntScheduler.Ranged> LETHAL_ATTACK_REF = BCDataManager.attribute(HollowArmor.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)60, (int)85), (String)"lethal_attack"));
    public static final EntityDataReference<IntScheduler.Ranged> ATTACKS_DELAY_REF = BCDataManager.attribute(HollowArmor.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)20, (int)25), (String)"attack_delay"));
    public static final EntityDataReference<IntScheduler.Simple> DASH_REF = BCDataManager.attribute(HollowArmor.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.INT_SCHEDULER, () -> IntScheduler.simple((int)160), (String)"dash"));
    public static final EntityDataReference<Boolean> HEALING_USED_REF = BCDataManager.attribute(HollowArmor.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BOOLEAN, () -> false, (String)"healing_used"));
    public static final SimpleAnimation BLUNT = new SimpleAnimation(17);
    public static final SimpleAnimation SLASH = new SimpleAnimation(21);
    public static final SimpleAnimation SWING = new SimpleAnimation(20);
    public static final SimpleAnimation DOUBLE_SWING = new SimpleAnimation(21);
    public static final SimpleAnimation IMPALE = new SimpleAnimation(26);
    public static final SimpleAnimation HEAL = new SimpleAnimation(28);
    public static final SimpleAnimation DASH = new SimpleAnimation(40);
    public static final SimpleAnimation DEATH = new SimpleAnimation(24);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{BLUNT, SLASH, SWING, DOUBLE_SWING, IMPALE, HEAL, DASH, DEATH});
    private ExtraMotionModule extraMotionModule;
    private PhaseAffectedModule phaseAffectedModule;
    public final EntityData<IntScheduler.Ranged> lethalAttackTimer;
    public final EntityData<IntScheduler.Ranged> attackTimer;
    public final EntityData<IntScheduler.Simple> dashTimer;
    public final EntityData<Boolean> healingUsed;
    private ExternalMotion dashMotion;
    private float movementReduction;

    public HollowArmor(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 8;
        this.f_19793_ = 1.2f;
        this.attackTimer = this.bcDataManager().addNonSyncedData(EntityData.of(ATTACKS_DELAY_REF));
        this.lethalAttackTimer = this.bcDataManager().addNonSyncedData(EntityData.of(LETHAL_ATTACK_REF));
        this.dashTimer = this.bcDataManager().addNonSyncedData(EntityData.of(DASH_REF));
        this.healingUsed = this.bcDataManager().addNonSyncedData(EntityData.of(HEALING_USED_REF));
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22278_, 0.9).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22279_, 0.29).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22281_, 5.5);
    }

    public static boolean spawnPlacement(EntityType<? extends HollowArmor> entityType, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        Level initLevel;
        int worldPhaseOrdinal;
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (level instanceof Level && (worldPhaseOrdinal = ((LevelCapability)CapabilityHelper.get((Object)(initLevel = (Level)level), LevelCapability.TOKEN)).getPhaseModule().getPhase().ordinal()) < LevelPhaseModule.Phase.DRAGON.ordinal()) {
            return false;
        }
        return Monster.m_33008_((ServerLevelAccessor)level, (BlockPos)pos, (Random)random) && HollowArmor.m_21400_(entityType, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    protected void commonInit() {
        super.commonInit();
        this.extraMotionModule = new ExtraMotionModule((Entity)this);
        this.phaseAffectedModule = new PhaseAffectedModule((Mob)this);
        this.loopedWalkModule = new LoopedWalkModule((LivingEntity)this);
        this.dashMotion = this.addCustomMotion(new ExternalMotion(0.2f));
    }

    @Override
    public PhaseAffectedModule phaseAffectedModule() {
        return this.phaseAffectedModule;
    }

    public AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    public ExtraMotionModule extraMotionModule() {
        return this.extraMotionModule;
    }

    @Override
    public Psyche<?> makePsyche() {
        return new HollowArmorPsyche(this);
    }

    public void m_8119_() {
        super.m_8119_();
        Connection.doClientSide(() -> this.clientTick());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick() {
        if (this.m_5842_() && (float)this.f_19797_ % 240.0f / 240.0f < 0.3f && this.f_19796_.nextFloat() < 0.15f) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 0.0, 0.7, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        super.clientCallOutHandler(flag, fetcher);
        if (flag == 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)EntityMovingSound.builder((Entity)this, (SoundEvent)((SoundEvent)DESounds.ES_POSSESSED_ARMOR_DASH.get()), (SoundSource)SoundSource.HOSTILE).build());
        }
    }

    public boolean m_147207_(MobEffectInstance effectInstanceIn, @Nullable Entity entityIn) {
        if (EffectHelper.isBadAndOnlyAppliesToLiving(effectInstanceIn.m_19544_())) {
            return false;
        }
        return super.m_147207_(effectInstanceIn, entityIn);
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DESounds.ES_POSSESSED_ARMOR_HIT.get();
    }

    @Nullable
    public SoundEvent getLivingSound() {
        return (SoundEvent)DESounds.ES_POSSESSED_ARMOR_CREAK.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)DESounds.ES_POSSESSED_ARMOR_STEP.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.25f, 1.0f);
        this.m_5496_((SoundEvent)DESounds.ES_POSSESSED_ARMOR_JIGGLES.get(), 0.15f, 1.0f);
    }

    public float getLoopWalkMultiplier() {
        return 0.4f;
    }

    @Nullable
    public SimpleAnimation getDeathAnimation() {
        return DEATH;
    }

    public ExternalMotion getDashMotion() {
        return this.dashMotion;
    }

    public float inputMovementMultiplier() {
        return this.movementReduction;
    }

    public void setInputMovementMultiplier(float newFactor) {
        this.movementReduction = newFactor;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }
}

