/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.goblin;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.Goblin;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class StoneProjectile
extends AbstractArrow
implements EntityClientMessenger {
    protected static int HIT_SOMETHING_FLAG = 0;
    public static float HIT_PARTICLE_AMOUNT = 15.0f;
    private IntScheduler stuckRemovalDelay;

    public StoneProjectile(EntityType<? extends StoneProjectile> type, Level worldIn) {
        super(type, worldIn);
        this.m_36740_(SoundEvents.f_12442_);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.stuckRemovalDelay = IntScheduler.simple((int)40);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_() && !this.m_36797_()) {
            Vec3 delta = this.m_20184_();
            this.m_20334_(delta.f_82479_, delta.f_82480_ + (double)0.03f, delta.f_82481_);
        }
        if (this.f_19853_.f_46443_) {
            Connection.doClientSide(() -> this.clientTick());
        }
        this.checkBlockCollisions();
    }

    protected void checkBlockCollisions() {
        if (this.m_20185_() == this.f_19790_ && this.m_20186_() == this.f_19791_ && this.m_20189_() == this.f_19792_) {
            this.stuckRemovalDelay.incrementFreely(1);
        } else {
            this.stuckRemovalDelay.reset();
        }
        if (this.stuckRemovalDelay.hasEnded() || this.f_19862_ || this.f_19863_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.f_19796_.nextInt(3) == 0) {
            ((ClientLevel)this.f_19853_).m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_(), this.m_20186_() + 0.15625, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_8060_(BlockHitResult resultData) {
        super.m_8060_(resultData);
        this.callClientHit((HitResult)resultData);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    protected void m_5790_(EntityHitResult resultData) {
        Entity entity = this.m_37282_();
        if (entity instanceof Goblin) {
            Goblin targetGoblin;
            Goblin goblin = (Goblin)entity;
            entity = resultData.m_82443_();
            if (entity instanceof Goblin && (targetGoblin = (Goblin)entity).variableModule().getForm() == goblin.variableModule().getForm()) {
                return;
            }
        }
        resultData.m_82443_().m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)this.m_37282_())), 3.0f);
        this.callClientHit((HitResult)resultData);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    private void callClientHit(HitResult result) {
        this.sendClientMsg(HIT_SOMETHING_FLAG, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)result.m_82450_())});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == HIT_SOMETHING_FLAG) {
            Vec3 hitLocation = (Vec3)fetcher.get(0, Vec3.class);
            int i = 0;
            while ((float)i < HIT_PARTICLE_AMOUNT) {
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), hitLocation.f_82479_, hitLocation.f_82480_ + 0.15625, hitLocation.f_82481_, this.f_19796_.nextGaussian() * (double)0.2f, 0.1, this.f_19796_.nextGaussian() * (double)0.2f);
                ++i;
            }
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

