/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.goblin;

import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FloatAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.MoveReactionToEntityAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.extras.BCAABBs;
import bottomtextdanny.braincell.mod.entity.psyche.extras.TargetConsumers;
import bottomtextdanny.braincell.mod.entity.psyche.extras.TargetSideReaction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessors;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetRange;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.Goblin;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.GoblinWeapon;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.StoneProjectile;
import bottomtextdanny.dannys_expansion.content.entities.mob.hollowlet.Hollowlet;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GoblinPsyche
extends Psyche<Goblin> {
    public static final int ANIMATION_ACTIONS_MODULE = 1;
    public static final int MOUNT_MODULE = 2;
    public static final int AVOID_MODULE = 3;
    public static final int MELEE_MODULE = 4;
    public static final int IDLE_ACTIONS_MODULE = 5;
    public static final MobPosProcessor<LivingEntity> AVOID_POS = MobPosProcessors.compose((blockPos, mob, randomGenerator, target) -> {
        Vec3 posDiff = mob.m_20182_().m_82546_(target.m_20182_());
        float oppositeFromTargetRad = (float)Mth.m_14136_((double)posDiff.f_82481_, (double)posDiff.f_82479_) + (float)Math.PI;
        FloatMapper angleAwayFromTarget = FloatMapper.from((float)(oppositeFromTargetRad - 0.34906584f), (float)(oppositeFromTargetRad + 0.34906584f), (FloatRandomPicker)FloatRandomPicker.normal());
        FloatMapper stepAway = FloatMapper.of((float)14.0f);
        return MobPosProcessors.stack().generic(LivingEntity.class).push(MobPosProcessors.advanceHorizontal((FloatMapper)angleAwayFromTarget, (FloatMapper)stepAway)).push(MobPosProcessors.sample((int)10, (MobPosProcessor)MobPosProcessors.randomOffset((int)3, (int)4, (int)3), GoblinPsyche.evaluateAvoidingPos(mob)));
    });
    public static final MobPosProcessor<LivingEntity> SEEK_PEER = MobPosProcessors.compose((blockPos, mob, randomGenerator, peer) -> (blockPos1, mob1, randomGenerator1, peer1) -> peer1.m_142538_());
    private static final MobMatchPredicate<LivingEntity> OPPOSITE_GOBLIN = (mob, target) -> {
        Goblin targetGoblin;
        return target instanceof Goblin && (targetGoblin = (Goblin)((Object)target)).variableModule().getForm() != ((Goblin)mob).variableModule().getForm() && Shared.DEFAULT_TARGET_PARAMETERS.test(mob, target);
    };
    private static final MobMatchPredicate<LivingEntity> NOT_SAME_GOBLIN = (mob, target) -> {
        Goblin targetGoblin;
        return (!(target instanceof Goblin) || (targetGoblin = (Goblin)((Object)target)).variableModule().getForm() != ((Goblin)mob).variableModule().getForm()) && Shared.DEFAULT_TARGET_PARAMETERS.test(mob, target);
    };
    private static final MobMatchPredicate<LivingEntity> MOUNTABLE_PEER = (mob, target) -> {
        if (target instanceof Goblin) {
            Goblin targetGoblin = (Goblin)((Object)target);
            if (!CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                return false;
            }
            if (target.m_20197_().size() > 5) {
                return false;
            }
            if (!target.m_20159_() && target.m_20202_() instanceof Goblin) {
                return false;
            }
            if (mob.m_21187_().nextFloat() < 0.2f) {
                float height = (float)target.m_6048_() + mob.m_20206_();
                for (Entity entity : target.m_20197_()) {
                    height += (float)entity.m_6048_();
                }
                BlockPos targetPosOffset = new BlockPos(target.m_20182_().m_82520_(0.0, (double)height, 0.0));
                if (mob.f_19853_.m_8055_(targetPosOffset).m_60767_().m_76333_()) {
                    return false;
                }
            }
            return targetGoblin.variableModule().getForm() == ((Goblin)mob).variableModule().getForm();
        }
        return false;
    };
    private static final TargetSideReaction<Goblin> AGGRO_PEERS = (mob, targeter, target) -> {
        LivingEntity actualTarget;
        if (!(targeter instanceof Goblin)) {
            return;
        }
        Goblin goblinTargeter = (Goblin)targeter;
        Form variant = mob.variableModule().getForm();
        if (variant != null && variant == goblinTargeter.variableModule().getForm() && !CombatHelper.isValidAttackTarget((LivingEntity)(actualTarget = mob.m_5448_()))) {
            mob.m_21561_(true);
            mob.m_6710_(target);
        }
    };
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)100));
    private LookRandomlyAction lookRandomlyAction;
    private RandomStrollAction randomStrollAction;
    private MoveReactionToEntityAction<Goblin, LivingEntity> avoidTarget;
    private MoveReactionToEntityAction<Goblin, LivingEntity> mountPeerAction;
    private FollowTargetAction<Goblin> followTargetAction;
    private ThrowAttackAction throwAction;
    private BumpAttackAction bumpAction;
    private DoubleSlashAction doubleSlashAction;
    private SlashAction slashAction;
    private StabAction stabAction;

    public GoblinPsyche(Goblin mob) {
        super((PathfinderMob)mob);
        this.allocateModules(6);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
        inputs.put(ActionInputKey.SET_TARGET_CALL, () -> ((Goblin)this.getMob()).getMeleeAttackDelay().end());
    }

    protected void initialize() {
        this.throwAction = new ThrowAttackAction((Goblin)this.getMob());
        this.bumpAction = new BumpAttackAction((Goblin)this.getMob());
        this.doubleSlashAction = new DoubleSlashAction((Goblin)this.getMob());
        this.slashAction = new SlashAction((Goblin)this.getMob());
        this.stabAction = new StabAction((Goblin)this.getMob());
        this.mountPeerAction = new MoveReactionToEntityAction((PathfinderMob)((Goblin)this.getMob()), MOUNTABLE_PEER, SEEK_PEER).speedByTarget(target -> (double)1.6f).setRefreshRate(25).searchRange(() -> ((Goblin)this.getMob()).m_21051_(Attributes.f_22277_).m_22135_() * 0.5).searchBy((SearchPredicate)SearchNearestPredicates.nearestOfType(Goblin.class));
        this.avoidTarget = new MoveReactionToEntityAction((PathfinderMob)((Goblin)this.getMob()), (MobMatchPredicate)TargetRange.followRangeMultiplied((float)0.3f), AVOID_POS).speedByTarget(target -> (double)1.6f).setRefreshRate(15).searchRange(() -> 0.0).searchBy((SearchPredicate)GoblinPsyche.searchTargetSpecifically());
        this.avoidTarget.addBlockedModule(5);
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((Goblin)this.getMob()), target -> {
            float speed;
            float f = speed = ((Goblin)this.getMob()).hasTwoWeapons() ? 1.5f : 1.3f;
            if (((Goblin)this.getMob()).m_20160_()) {
                speed -= 0.3f;
            }
            return speed;
        }).setRefreshRate(16);
        this.followTargetAction.addBlockedModule(5);
        MobPosProcessor<Object> strollPositionCalculator = Shared.LAND_STROLL;
        this.randomStrollAction = new RandomStrollAction(this.getMob(), strollPositionCalculator, RandomIntegerMapper.of((int)60, (int)120));
        this.randomStrollAction.addModule(5);
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)120, (int)160)).vertical(FloatMappers.of((float)-0.68f, (float)0.2f));
        this.lookRandomlyAction.addModule(5);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Goblin)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            this.checkStoneReaddition((Goblin)((Object)mobo));
            if (CombatHelper.isValidAttackTarget((LivingEntity)target) && EntitySelector.f_20406_.test(target)) {
                this.onTargetFound((Goblin)((Object)mobo), target);
            } else {
                this.idle((Goblin)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new FloatAction(this.getMob(), 0.2f));
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), NOT_SAME_GOBLIN).findTargetCallOut(TargetConsumers.entityGroupAction(Goblin.class, targeter -> BCAABBs.livingEntityRange((LivingEntity)targeter, (double)30.0, (double)20.0), AGGRO_PEERS)));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Goblin)this.getMob()), (IntScheduler)IntScheduler.simple((int)25), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestOfType(Hollowlet.class)));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Goblin)this.getMob()), (IntScheduler)IntScheduler.simple((int)4), OPPOSITE_GOBLIN, (SearchPredicate)SearchNearestPredicates.nearestOfType(Goblin.class)));
    }

    private void checkStoneReaddition(Goblin mob) {
        int stones = (Integer)mob.stones.get();
        if (stones > 5) {
            return;
        }
        IntScheduler stoneDelay = (IntScheduler)mob.stoneDelay.get();
        stoneDelay.incrementFreely(1);
        if (stoneDelay.hasEnded()) {
            mob.stones.set((Object)(stones + 1));
            stoneDelay.reset();
        }
    }

    private void onTargetFound(Goblin mob, @Nonnull LivingEntity target) {
        IntScheduler mountDelay = mob.getMountDelay();
        IntScheduler meleeAttackDelay = mob.getMeleeAttackDelay();
        IntScheduler throwDelay = (IntScheduler)mob.throwDelay.get();
        this.blockModule(5);
        meleeAttackDelay.incrementFreely(1);
        throwDelay.incrementFreely(1);
        if (mob.m_20159_()) {
            this.blockModule(4);
            this.blockModule(3);
            this.onTargetFoundWhileOnVehicle(mob, target);
            return;
        }
        if (!mob.hasTwoWeapons()) {
            if (mob.m_20159_() || mob.m_20160_()) {
                mountDelay.reset();
            } else {
                mountDelay.incrementFreely(1);
            }
            if (mountDelay.hasEnded()) {
                if (this.tryMountPeer(mob, target)) {
                    this.blockModule(4);
                    this.blockModule(3);
                    return;
                }
                mountDelay.reset();
            }
        }
        this.blockModule(2);
        if ((Integer)mob.stones.get() <= 0 || !throwDelay.hasEnded() || this.tryAvoidAndThrowStoneToTarget(mob, target)) {
            this.goMeleeOnTarget(mob, target);
        }
    }

    private boolean tryMountPeer(Goblin mob, @Nonnull LivingEntity target) {
        Goblin peer;
        IntScheduler waitForMount = mob.getWaitForMount();
        waitForMount.incrementFreely(1);
        this.tryAddRunningAction(2, (Action)this.mountPeerAction);
        LivingEntity mountFocus = (LivingEntity)this.mountPeerAction.getFocus();
        if (waitForMount.hasEnded()) {
            return false;
        }
        if (mountFocus instanceof Goblin && this.isValidPeer(mob, peer = (Goblin)mountFocus)) {
            waitForMount.reset();
            this.mountPeer(mob, peer);
            return true;
        }
        this.blockModule(2);
        return false;
    }

    private boolean isValidPeer(Goblin mob, @Nonnull Goblin peer) {
        double distance = ReachHelper.reach3((Entity)mob, (Entity)peer, (DistanceCalc3)DistanceCalc3.MANHATTAN);
        return MOUNTABLE_PEER.test((Mob)mob, (Object)peer) && distance < 1.5;
    }

    private void mountPeer(Goblin mob, @Nonnull Goblin peer) {
        peer.m_20329_((Entity)mob);
    }

    private void onTargetFoundWhileOnVehicle(Goblin mob, @Nonnull LivingEntity target) {
        double distance = mob.m_20182_().m_82554_(target.m_20182_());
        this.tryDismount(mob, 1);
        if (distance < 6.5 && mob.m_21574_().m_148306_((Entity)target)) {
            this.tryThrowStone(mob, target, 2);
        }
        mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        mob.m_146922_(mob.f_20885_);
    }

    private void tryDismount(Goblin mob, int step) {
        Goblin goblinMount;
        Entity entity;
        IntScheduler demountDelay = (IntScheduler)mob.demountDelay.get();
        int dismountStep = mob.m_20202_() == mob.m_20201_() ? step * 2 : step;
        demountDelay.incrementFreely(dismountStep);
        if (mob.hasTwoWeapons() || (entity = mob.m_20202_()) instanceof Goblin && !MOUNTABLE_PEER.test((Mob)mob, (Object)(goblinMount = (Goblin)entity)) || demountDelay.hasEnded()) {
            mob.m_8127_();
            demountDelay.reset();
        }
    }

    private boolean tryAvoidAndThrowStoneToTarget(Goblin mob, @Nonnull LivingEntity target) {
        double distance = mob.m_20182_().m_82554_(target.m_20182_());
        IntScheduler waitForAvoid = mob.getWaitForAvoid();
        if (distance > 6.5) {
            return true;
        }
        if (mob.hasTwoWeapons()) {
            return true;
        }
        this.blockModule(4);
        if ((waitForAvoid.hasEnded() || distance > 2.5) && mob.m_21574_().m_148306_((Entity)target)) {
            this.blockModule(3);
            this.tryThrowStone(mob, target, 1);
            return true;
        }
        waitForAvoid.incrementFreely(1);
        this.tryAddRunningAction(3, (Action)this.avoidTarget);
        return false;
    }

    private void tryThrowStone(Goblin mob, @Nonnull LivingEntity target, int delayStep) {
        IntScheduler wait = mob.getWaitForThrow();
        wait.incrementFreely(delayStep);
        if (wait.hasEnded()) {
            this.tryAddRunningAction(1, (Action)this.throwAction);
        }
        mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        mob.m_146922_(mob.f_20885_);
    }

    private void goMeleeOnTarget(Goblin mob, @Nonnull LivingEntity target) {
        this.tryAddRunningAction(4, (Action)this.followTargetAction);
        if (mob.getMeleeAttackDelay().hasEnded() && mob.mainHandler.isPlayingNull() && ReachHelper.reachSqr((PathfinderMob)mob, (Entity)target) < 1.1f) {
            Action<?> attack = this.getMeleeAttack(mob);
            this.tryAddRunningAction(1, attack);
        }
    }

    private Action<?> getMeleeAttack(Goblin mob) {
        boolean useLeftHand = mob.m_21187_().nextBoolean();
        boolean canDoDoubleSlash = this.canDoubleSlash(mob);
        float doubleSlashProb = 0.25f;
        float bumpProbability = 0.15f;
        float gen = mob.m_21187_().nextFloat();
        if (gen < bumpProbability) {
            return this.bumpAction;
        }
        if (canDoDoubleSlash && gen - bumpProbability < doubleSlashProb) {
            return this.doubleSlashAction;
        }
        float handedAttackGen = mob.m_21187_().nextFloat();
        if (useLeftHand) {
            if (mob.hasLeftWeapon()) {
                return this.getHandedAttack(mob, true, handedAttackGen);
            }
        } else if (mob.hasRightWeapon()) {
            return this.getHandedAttack(mob, false, handedAttackGen);
        }
        return this.bumpAction;
    }

    private GoblinHandedAttackAction getHandedAttack(Goblin mob, boolean useLeftHand, float gen) {
        if (GoblinWeapon.SPEAR.hasOnHand(mob, useLeftHand)) {
            this.stabAction.setUsingLeftAnimation(useLeftHand);
            return this.stabAction;
        }
        if (GoblinWeapon.SWORD.hasOnHand(mob, useLeftHand)) {
            if (gen < 0.5f) {
                this.stabAction.setUsingLeftAnimation(useLeftHand);
                return this.stabAction;
            }
            this.slashAction.setUsingLeftAnimation(useLeftHand);
            return this.slashAction;
        }
        return null;
    }

    private boolean canDoubleSlash(Goblin mob) {
        return mob.getLeftWeapon() == GoblinWeapon.SWORD && mob.getRightWeapon() == GoblinWeapon.SWORD;
    }

    private static SearchNearestPredicate searchTargetSpecifically() {
        return (mob, serverLevel, rangeTest, lazy, targetPredicate) -> {
            LivingEntity target = mob.m_5448_();
            if (target == null || !target.m_6084_() || !targetPredicate.test(mob, (Object)target)) {
                return null;
            }
            return target;
        };
    }

    private static Function<LivingEntity, Comparator<BlockPos>> evaluateAvoidingPos(Mob mob) {
        return target -> {
            Comparator<BlockPos> comparator;
            if (mob instanceof PathfinderMob) {
                PathfinderMob pf = (PathfinderMob)mob;
                comparator = Comparator.comparingDouble(pos -> {
                    double value = Math.min(1.0, (double)pf.m_21692_(pos));
                    return value -= mob.m_20182_().m_82554_(target.m_20182_()) / 8.0;
                });
            } else {
                comparator = null;
            }
            return comparator;
        };
    }

    private void idle(Goblin mob) {
        if (mob.m_20159_() || mob.m_20160_()) {
            if (mob.m_20159_()) {
                this.tryDismount(mob, 2);
            }
            mob.getMountDelay().reset();
        } else {
            this.tryAddRunningAction(5, (Action)this.randomStrollAction);
            this.tryAddRunningAction(5, (Action)this.lookRandomlyAction);
            ((IntScheduler.Ranged)mob.demountDelay.get()).reset();
        }
    }

    protected static final class ThrowAttackAction
    extends AnimationAction<Goblin, SimpleAnimation> {
        public ThrowAttackAction(Goblin mob) {
            super((PathfinderMob)mob, (Animation)Goblin.THROW, mob.mainHandler);
        }

        protected void update() {
            super.update();
            int animationTick = this.animationHandler.getTick();
            LivingEntity target = ((Goblin)this.mob).m_5448_();
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (animationTick == 6) {
                    ((Goblin)this.mob).m_5496_((SoundEvent)DESounds.ES_GOBLIN_ATTACK.get(), 1.0f, 0.9f + RANDOM.nextFloat() * 0.2f);
                }
                if (animationTick == 7) {
                    ((IntScheduler.Ranged)((Goblin)this.mob).throwDelay.get()).reset();
                    ((Goblin)this.mob).stones.set((Object)((Integer)((Goblin)this.mob).stones.get() - 1));
                    ((Goblin)this.mob).getWaitForThrow().reset();
                    ((Goblin)this.mob).getWaitForAvoid().reset();
                    StoneProjectile projectile = new StoneProjectile((EntityType<? extends StoneProjectile>)((EntityType)DEEntities.STONE_PROJECTILE.get()), ((Goblin)this.mob).f_19853_);
                    projectile.m_5602_((Entity)this.mob);
                    projectile.m_146884_(((Goblin)this.mob).m_20182_().m_82520_(0.0, 0.5, 0.0));
                    Vec2 rotations = Shared.rotationsToTarget((Position)projectile.m_20182_(), (Position)target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
                    projectile.m_37251_((Entity)this.mob, rotations.f_82470_, rotations.f_82471_ - 90.0f, -1.5f, 2.0f, 0.6f);
                    ((Goblin)this.mob).f_19853_.m_7967_((Entity)projectile);
                }
            }
        }

        public boolean canStart() {
            return super.canStart() && this.animationHandler.isPlayingNull();
        }
    }

    protected static final class BumpAttackAction
    extends AnimationAction<Goblin, SimpleAnimation> {
        public BumpAttackAction(Goblin mob) {
            super((PathfinderMob)mob, (Animation)Goblin.BUMP, mob.mainHandler);
        }

        protected void update() {
            super.update();
            int animationTick = this.animationHandler.getTick();
            LivingEntity target = ((Goblin)this.mob).m_5448_();
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (animationTick == 6) {
                    ((Goblin)this.mob).m_5496_((SoundEvent)DESounds.ES_GOBLIN_ATTACK.get(), 1.0f, 0.9f + RANDOM.nextFloat() * 0.2f);
                }
                if (animationTick == 8 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 1.32f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)(1.0f + RANDOM.nextFloat() * 0.15f));
                    ((Goblin)this.mob).getMeleeAttackDelay().reset();
                }
                ((Goblin)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                ((Goblin)this.mob).m_146922_(((Goblin)this.mob).f_20885_);
            }
        }

        public boolean canStart() {
            return super.canStart() && this.animationHandler.isPlayingNull();
        }
    }

    protected static final class DoubleSlashAction
    extends AnimationAction<Goblin, SimpleAnimation> {
        public DoubleSlashAction(Goblin mob) {
            super((PathfinderMob)mob, (Animation)Goblin.DOUBLE_SLASH, mob.mainHandler);
        }

        protected void update() {
            super.update();
            int animationTick = this.animationHandler.getTick();
            LivingEntity target = ((Goblin)this.mob).m_5448_();
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                if (animationTick == 6) {
                    ((Goblin)this.mob).m_5496_((SoundEvent)DESounds.ES_GOBLIN_ATTACK.get(), 1.0f, 0.9f + RANDOM.nextFloat() * 0.2f);
                }
                if (animationTick == 8 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 1.32f) {
                    CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)(1.5f * ((Goblin)this.mob).getLeftWeapon().getDamageMultiplier() + RANDOM.nextFloat() * 0.15f));
                    ((Goblin)this.mob).getMeleeAttackDelay().reset();
                }
                ((Goblin)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                ((Goblin)this.mob).m_146922_(((Goblin)this.mob).f_20885_);
            }
        }

        public boolean canStart() {
            return super.canStart() && this.animationHandler.isPlayingNull();
        }
    }

    protected static final class SlashAction
    extends GoblinHandedAttackAction {
        public SlashAction(Goblin mob) {
            super(mob, Goblin.SLASH_LEFT, Goblin.SLASH_RIGHT);
        }

        @Override
        public void handleTarget(int animationTick, LivingEntity target) {
            if (animationTick == 6) {
                ((Goblin)this.mob).m_5496_((SoundEvent)DESounds.ES_GOBLIN_ATTACK.get(), 1.0f, 0.9f + RANDOM.nextFloat() * 0.2f);
            }
            if (animationTick == 8 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 1.32f) {
                GoblinWeapon weapon = this.usingLeftAnimation ? ((Goblin)this.mob).getLeftWeapon() : ((Goblin)this.mob).getRightWeapon();
                CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)(1.2f * weapon.getDamageMultiplier() + RANDOM.nextFloat() * 0.15f));
                ((Goblin)this.mob).getMeleeAttackDelay().reset();
            }
        }
    }

    protected static final class StabAction
    extends GoblinHandedAttackAction {
        public StabAction(Goblin mob) {
            super(mob, Goblin.STAB_LEFT, Goblin.STAB_RIGHT);
        }

        @Override
        public void handleTarget(int animationTick, LivingEntity target) {
            if (animationTick == 6) {
                ((Goblin)this.mob).m_5496_((SoundEvent)DESounds.ES_GOBLIN_ATTACK.get(), 1.0f, 0.9f + RANDOM.nextFloat() * 0.2f);
            }
            if (animationTick == 8 && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)target) < 1.54f) {
                GoblinWeapon weapon = this.usingLeftAnimation ? ((Goblin)this.mob).getLeftWeapon() : ((Goblin)this.mob).getRightWeapon();
                CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)(1.1f * weapon.getDamageMultiplier() + RANDOM.nextFloat() * 0.15f));
                ((Goblin)this.mob).getMeleeAttackDelay().reset();
            }
        }
    }

    protected static abstract class GoblinHandedAttackAction
    extends Action<Goblin> {
        private final SimpleAnimation left;
        private final SimpleAnimation right;
        protected boolean usingLeftAnimation;

        public GoblinHandedAttackAction(Goblin mob, SimpleAnimation left, SimpleAnimation right) {
            super((PathfinderMob)mob);
            this.left = left;
            this.right = right;
        }

        public boolean canStart() {
            return super.active() && ((Goblin)this.mob).mainHandler.isPlayingNull();
        }

        protected void start() {
            super.start();
            ((Goblin)this.mob).mainHandler.play((Animation)this.getAnimation());
        }

        public boolean shouldKeepGoing() {
            return this.active() && ((Goblin)this.mob).mainHandler.isPlaying((Animation)this.getAnimation());
        }

        protected void update() {
            super.update();
            int animationTick = ((Goblin)this.mob).mainHandler.getTick();
            LivingEntity target = ((Goblin)this.mob).m_5448_();
            MobMatchPredicate validator = (MobMatchPredicate)this.getPsyche().getInputs().getOfDefault(ActionInputKey.TARGET_VALIDATOR);
            if (validator != null && target != null && validator.test((Mob)this.mob, (Object)target)) {
                this.handleTarget(animationTick, target);
                ((Goblin)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                ((Goblin)this.mob).m_146922_(((Goblin)this.mob).f_20885_);
            }
        }

        public abstract void handleTarget(int var1, LivingEntity var2);

        protected SimpleAnimation getAnimation() {
            return this.usingLeftAnimation ? this.left : this.right;
        }

        public void setUsingLeftAnimation(boolean usingLeftAnimation) {
            this.usingLeftAnimation = usingLeftAnimation;
        }
    }
}

