/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.goblin;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod._mod.client_sided.variant_data.SimpleVariantRenderingData;
import bottomtextdanny.braincell.mod._mod.client_sided.variant_data.VariantRenderingData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkModule;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedFormManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedVariableModule;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.serialization.BCSerializers;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.dannys_expansion.content._client.rendering.entity.mob.goblin.GoblinRenderer;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.GoblinPsyche;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.GoblinWeapon;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Goblin
extends SmartyMob {
    private static final int SYNC_WEAPONS_FLAG = 0;
    public static final float ATTACK_REACH_SQUARE = 1.1f;
    public static final float MOUNT_SPEED_REDUCTION = 0.3f;
    public static final float SOLDIER_ANGRY_SPEED_MULTIPLIER = 1.5f;
    public static final float ANGRY_SPEED_MULTIPLIER = 1.3f;
    public static final float RUN_AWAY_SPEED_MULTIPLIER = 1.6f;
    public static final float MOUNT_PEER_RANGE = 1.5f;
    public static final float AVOID_RANGE = 2.5f;
    public static final float THROW_RANGE = 6.5f;
    public static final float BARE_HANDS_PROB = 0.25f;
    public static final float SWORD_TO_SPEAR_PROB = 0.45f;
    public static final int MAX_MOUNT_CHAIN_SIZE = 5;
    public static final int MAX_STONES = 5;
    public static final Form<Goblin> GREEN = new Form<Goblin>(){

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Goblin> createRenderingHandler() {
            return new SimpleVariantRenderingData(GoblinRenderer.TEXTURES_GREEN, (EntityModel)GoblinRenderer.MODEL);
        }
    };
    public static final Form<Goblin> PURPLE = new Form<Goblin>(){

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Goblin> createRenderingHandler() {
            return new SimpleVariantRenderingData(GoblinRenderer.TEXTURES_PURPLE, (EntityModel)GoblinRenderer.MODEL);
        }
    };
    public static final Form<Goblin> RED = new Form<Goblin>(){

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Goblin> createRenderingHandler() {
            return new SimpleVariantRenderingData(GoblinRenderer.TEXTURES_RED, (EntityModel)GoblinRenderer.MODEL);
        }
    };
    public static final Form<Goblin> BLUE = new Form<Goblin>(){

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Goblin> createRenderingHandler() {
            return new SimpleVariantRenderingData(GoblinRenderer.TEXTURES_BLUE, (EntityModel)GoblinRenderer.MODEL);
        }
    };
    public static final IndexedFormManager FORMS = IndexedFormManager.builder().add(GREEN).add(PURPLE).add(RED).add(BLUE).create();
    public static final EntityDataReference<IntScheduler.Ranged> DEMOUNT_DELAY_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)200, (int)240), (String)"demount_delay"));
    public static final EntityDataReference<IntScheduler.Ranged> THROW_DELAY_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)40, (int)70), (String)"throw_delay"));
    public static final EntityDataReference<IntScheduler.Simple> STONE_READDITION_DELAY_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.INT_SCHEDULER, () -> IntScheduler.simple((int)100), (String)"stone_delay"));
    public static final EntityDataReference<Integer> STONES_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.INTEGER, () -> 4, (String)"stones"));
    public static final EntityDataReference<Byte> LEFT_WEAPON_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BYTE, () -> (byte)-1, (String)"left_weapon"));
    public static final EntityDataReference<Byte> RIGHT_WEAPON_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BYTE, () -> (byte)-1, (String)"right_weapon"));
    public static final EntityDataReference<Boolean> WEAPONS_SETTLED_REF = BCDataManager.attribute(Goblin.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BOOLEAN, () -> false, (String)"updated_weapons"));
    public static final SimpleAnimation DOUBLE_SLASH = new SimpleAnimation(21);
    public static final SimpleAnimation SLASH_LEFT = new SimpleAnimation(16);
    public static final SimpleAnimation SLASH_RIGHT = new SimpleAnimation(16);
    public static final SimpleAnimation STAB_LEFT = new SimpleAnimation(17);
    public static final SimpleAnimation STAB_RIGHT = new SimpleAnimation(17);
    public static final SimpleAnimation THROW = new SimpleAnimation(18);
    public static final SimpleAnimation BUMP = new SimpleAnimation(17);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{DOUBLE_SLASH, SLASH_LEFT, SLASH_RIGHT, STAB_LEFT, STAB_RIGHT, THROW, BUMP});
    private final EntityData<Byte> leftWeapon;
    private final EntityData<Byte> rightWeapon;
    private final EntityData<Boolean> updatedWeapons;
    public final EntityData<Integer> stones;
    public final EntityData<IntScheduler.Ranged> demountDelay;
    public final EntityData<IntScheduler.Ranged> throwDelay;
    public final EntityData<IntScheduler.Simple> stoneDelay;
    private final IntScheduler meleeAttackDelay;
    private final IntScheduler mountDelay;
    private final IntScheduler waitForAvoid;
    private final IntScheduler waitForMount;
    private final IntScheduler waitForThrow;

    public Goblin(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 4;
        this.updatedWeapons = this.bcDataManager().addNonSyncedData(EntityData.of(WEAPONS_SETTLED_REF));
        this.demountDelay = this.bcDataManager().addNonSyncedData(EntityData.of(DEMOUNT_DELAY_REF));
        this.throwDelay = this.bcDataManager().addNonSyncedData(EntityData.of(THROW_DELAY_REF));
        this.stoneDelay = this.bcDataManager().addNonSyncedData(EntityData.of(STONE_READDITION_DELAY_REF));
        this.stones = this.bcDataManager().addNonSyncedData(EntityData.of(STONES_REF));
        this.leftWeapon = this.bcDataManager().addSyncedData(EntityData.of(LEFT_WEAPON_REF));
        this.rightWeapon = this.bcDataManager().addSyncedData(EntityData.of(RIGHT_WEAPON_REF));
        this.meleeAttackDelay = IntScheduler.ranged((int)3, (int)15);
        this.mountDelay = IntScheduler.ranged((int)30, (int)130);
        this.waitForAvoid = IntScheduler.simple((int)30);
        this.waitForMount = IntScheduler.simple((int)50);
        this.waitForThrow = IntScheduler.ranged((int)4, (int)6);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 1.5).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22281_, 5.0);
    }

    public static boolean spawningParameters(EntityType<? extends Goblin> entityType, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)level, (BlockPos)pos, (Random)random) && Goblin.m_21400_(entityType, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    protected void commonInit() {
        super.commonInit();
        this.loopedWalkModule = new LoopedWalkModule((LivingEntity)this);
        this.variableModule = new IndexedVariableModule((LivingEntity)this, FORMS);
    }

    public AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public Psyche<?> makePsyche() {
        return new GoblinPsyche(this);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData group, @Nullable CompoundTag tag) {
        GoblinGroupData goblinData;
        super.m_6518_(level, difficulty, spawnType, group, tag);
        GoblinGroupData data = group instanceof GoblinGroupData ? (goblinData = (GoblinGroupData)group) : new GoblinGroupData(this.chooseVariant());
        if (data.variant() != null) {
            this.variableModule().setForm(data.variant());
        }
        return data;
    }

    @Override
    protected void onAnyPossibleSpawn() {
        if (!((Boolean)this.updatedWeapons.get()).booleanValue()) {
            float bareHandsProb = 0.25f * (float)this.f_19853_.m_46791_().m_19028_();
            if (bareHandsProb > 0.0f) {
                this.chooseWeapon(bareHandsProb, true);
                this.chooseWeapon(bareHandsProb, false);
            }
            this.updatedWeapons.set((Object)true);
        }
    }

    protected void chooseWeapon(float bareHandsProb, boolean leftHand) {
        if (this.f_19796_.nextFloat() < bareHandsProb) {
            if (this.f_19796_.nextFloat() < 0.45f) {
                GoblinWeapon.SWORD.arm(this, leftHand);
            } else {
                GoblinWeapon.SPEAR.arm(this, leftHand);
            }
        }
    }

    public Form<?> chooseVariant() {
        return FORMS.getForm(this.f_19796_.nextInt(0, 4));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            this.waitForThrow.incrementFreely(this.f_19796_.nextInt(20, 50));
        }
        return super.m_6469_(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        super.clientCallOutHandler(flag, fetcher);
        if (flag == 0) {
            byte serverLeftWeapon = (Byte)fetcher.get(0, Byte.class);
            byte serverRightWeapon = (Byte)fetcher.get(1, Byte.class);
            this.leftWeapon.set((Object)serverLeftWeapon);
            this.rightWeapon.set((Object)serverRightWeapon);
        }
    }

    private void syncWeaponsToClient() {
        this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.BYTE, (Object)((Byte)this.leftWeapon.get())), WorldPacketData.of((SerializerMark)BuiltinSerializers.BYTE, (Object)((Byte)this.rightWeapon.get()))});
    }

    public double m_6048_() {
        return super.m_6048_() + (double)0.115f;
    }

    public float getLoopWalkMultiplier() {
        return 0.77f;
    }

    public void setLeftWeapon(GoblinWeapon weapon) {
        this.leftWeapon.set((Object)((byte)weapon.getIndex()));
    }

    public void setRightWeapon(GoblinWeapon weapon) {
        this.rightWeapon.set((Object)((byte)weapon.getIndex()));
    }

    public GoblinWeapon getLeftWeapon() {
        return GoblinWeapon.values()[(Byte)this.leftWeapon.get() + 1];
    }

    public GoblinWeapon getRightWeapon() {
        return GoblinWeapon.values()[(Byte)this.rightWeapon.get() + 1];
    }

    public boolean hasLeftWeapon() {
        return ((Byte)this.leftWeapon.get()).byteValue() != GoblinWeapon.NONE.getIndex() && (Byte)this.leftWeapon.get() < GoblinWeapon.values().length;
    }

    public boolean hasRightWeapon() {
        return ((Byte)this.rightWeapon.get()).byteValue() != GoblinWeapon.NONE.getIndex() && (Byte)this.rightWeapon.get() < GoblinWeapon.values().length;
    }

    public boolean hasTwoWeapons() {
        return this.hasLeftWeapon() && this.hasRightWeapon();
    }

    public boolean hasWeapon(GoblinWeapon weapon) {
        return ((Byte)this.leftWeapon.get()).byteValue() == weapon.getIndex() || ((Byte)this.rightWeapon.get()).byteValue() == weapon.getIndex();
    }

    public IntScheduler getMeleeAttackDelay() {
        return this.meleeAttackDelay;
    }

    public IntScheduler getMountDelay() {
        return this.mountDelay;
    }

    public IntScheduler getWaitForAvoid() {
        return this.waitForAvoid;
    }

    public IntScheduler getWaitForMount() {
        return this.waitForMount;
    }

    public IntScheduler getWaitForThrow() {
        return this.waitForThrow;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CombatHelper.isValidAttackTarget((LivingEntity)this.m_5448_()) ? null : (SoundEvent)DESounds.ES_GOBLIN_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)DESounds.ES_GOBLIN_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)DESounds.ES_GOBLIN_HURT.get();
    }

    public boolean m_6785_(double v) {
        return true;
    }

    protected record GoblinGroupData(Form<?> variant) implements SpawnGroupData
    {
    }
}

