/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.ghoul;

import bottomtextdanny.braincell.base.Chooser;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FloatAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.WaterAvoidingRandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.ghoul.Ghoul;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.random.RandomGenerator;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;

public class GhoulPsyche
extends Psyche<Ghoul> {
    public static final int ANIMATION_ACTIONS_MODULE = 1;
    public static final int MAIN_MODULE = 2;
    public static final int IDLE_ACTIONS_MODULE = 3;
    public static Chooser<SimpleAnimation> ATTACKS = Chooser.builder().put(30.0f, (Object)Ghoul.PUNCH).put(40.0f, (Object)Ghoul.UP_PUNCH).put(10.0f, (Object)Ghoul.TRAP).build();
    public static MobMatchPredicate<LivingEntity> ONLY_IF_HUNGRY = (mob, target) -> Shared.DEFAULT_TARGET_PARAMETERS.test(mob, target);
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)40));
    private AttackAction attackAction;
    private LookRandomlyAction lookRandomlyAction;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<Ghoul> followTargetAction;

    public GhoulPsyche(Ghoul mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
    }

    protected void initialize() {
        this.attackAction = new AttackAction((Ghoul)this.getMob());
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((Ghoul)this.getMob()), target -> (double)1.3f).setRefreshRate(10);
        this.randomStrollAction = new WaterAvoidingRandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)220, (int)320));
        this.randomStrollAction.addModule(3);
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)120, (int)160)).vertical(FloatMappers.of((float)-0.28f, (float)0.15f));
        this.lookRandomlyAction.addModule(3);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Ghoul)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            if (CombatHelper.isValidAttackTarget((Mob)mobo, (LivingEntity)target)) {
                this.onTargeting((Ghoul)((Object)mobo), target);
            } else {
                this.idling((Ghoul)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Ghoul)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Ghoul)this.getMob()), (IntScheduler)IntScheduler.simple((int)30), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
        this.tryAddRunningAction(3, (Action)new FloatAction(this.getMob(), 0.5f));
    }

    protected void idling(Ghoul mob) {
        this.tryAddRunningAction(2, (Action)this.randomStrollAction);
        this.tryAddRunningAction(2, (Action)this.lookRandomlyAction);
    }

    protected void onTargeting(Ghoul mob, @Nonnull LivingEntity target) {
        this.blockModule(3);
        this.tryAddRunningAction(2, (Action)this.followTargetAction);
        float reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::euclideanEntityReach3);
        if (reach < 0.8f) {
            this.tryAddRunningAction(1, this.attackAction);
        }
    }

    public static class AttackAction
    extends Action<Ghoul> {
        private SimpleAnimation animation;

        public AttackAction(Ghoul mob) {
            super((PathfinderMob)mob);
        }

        public boolean canStart() {
            return ((Ghoul)this.mob).mainHandler.isPlayingNull();
        }

        protected void start() {
            SimpleAnimation animation;
            this.animation = animation = (SimpleAnimation)ATTACKS.pick((RandomGenerator)RANDOM);
            if (animation != Ghoul.TRAP) {
                ((Ghoul)this.mob).setLeftHandlingAndSync(RANDOM.nextBoolean());
            }
            ((Ghoul)this.mob).mainHandler.play((Animation)animation);
        }

        public boolean shouldKeepGoing() {
            return this.active() && ((Ghoul)this.mob).mainHandler.isPlaying((Animation)this.animation);
        }

        public void update() {
            this.getPsyche().blockModule(2);
            ((Ghoul)this.mob).setInputMovementMultiplier(0.0f);
            ((Ghoul)this.mob).m_146922_(((Ghoul)this.mob).f_20885_);
            LivingEntity target = ((Ghoul)this.mob).m_5448_();
            if (!CombatHelper.isValidAttackTarget((Mob)this.mob, (LivingEntity)target)) {
                return;
            }
            ((Ghoul)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (((Ghoul)this.mob).mainHandler.getTick() == 6) {
                ((Ghoul)this.mob).m_5496_((SoundEvent)DESounds.ES_GHOUL_PUNCH.get(), 1.0f, 1.0f + RANDOM.nextFloat() * 0.2f);
            }
            if (((Ghoul)this.mob).mainHandler.getTick() != 9) {
                return;
            }
            float reach = ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::euclideanEntityReach3);
            if (reach < 1.0f) {
                CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f);
                CombatHelper.mayDisableShield((Entity)target, (int)20, (float)0.25f);
            }
        }
    }
}

