/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.ghoul;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod._mod.client_sided.variant_data.SimpleVariantRenderingData;
import bottomtextdanny.braincell.mod._mod.client_sided.variant_data.VariantRenderingData;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkModule;
import bottomtextdanny.braincell.mod.entity.modules.motion_util.MotionUtilProvider;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedFormManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedVariableModule;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.dannys_expansion.content._client.rendering.entity.mob.ghoul.GhoulRenderer;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.ghoul.GhoulPsyche;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Ghoul
extends SmartyMob
implements Enemy,
MotionUtilProvider {
    private static final int USING_LEFT_HAND_FLAG = 0;
    public static final int RAISE_HAND_FLAG = 1;
    public static final int LOWER_HAND_FLAG = 2;
    public static final float COMBAT_MOVE_SPEED = 1.3f;
    public static final float HAND_RAISE = 0.05f;
    public static final float MELEE_REACH = 0.8f;
    public static final Form<Ghoul> GHOUL = new Form<Ghoul>(){

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Ghoul> createRenderingHandler() {
            return new SimpleVariantRenderingData(GhoulRenderer.GHOUL_TEXTURES, (EntityModel)GhoulRenderer.MODEL);
        }
    };
    public static final Form<Ghoul> FROZEN_GHOUL = new Form<Ghoul>(){

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Ghoul> createRenderingHandler() {
            return new SimpleVariantRenderingData(GhoulRenderer.FROZEN_GHOUL_TEXTURES, (EntityModel)GhoulRenderer.MODEL);
        }
    };
    public static final IndexedFormManager FORMS = IndexedFormManager.builder().add(GHOUL).add(FROZEN_GHOUL).create();
    public static final SimpleAnimation PUNCH = new SimpleAnimation(20);
    public static final SimpleAnimation UP_PUNCH = new SimpleAnimation(20);
    public static final SimpleAnimation TRAP = new SimpleAnimation(20);
    public static final AnimationGetter ANIMATIONS = new AnimationArray(new Animation[]{PUNCH, UP_PUNCH, TRAP});
    private boolean usingLeftHand;
    protected float handRaiseO;
    protected float handRaise;

    public Ghoul(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder attributes() {
        return Ghoul.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22278_, 0.9).m_22268_(Attributes.f_22281_, 4.5);
    }

    public static boolean spawnPlacement(EntityType<? extends Ghoul> entityType, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)level, (BlockPos)pos, (Random)random) && Ghoul.m_21400_(entityType, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    protected void commonInit() {
        super.commonInit();
        this.loopedWalkModule = new LoopedWalkModule((LivingEntity)this);
        this.variableModule = new IndexedVariableModule((LivingEntity)this, FORMS);
    }

    @Override
    public Psyche<?> makePsyche() {
        return new GhoulPsyche(this);
    }

    public AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    public Form<?> chooseVariant() {
        Biome biome = (Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_();
        if (biome.m_198904_(this.m_142538_())) {
            return FROZEN_GHOUL;
        }
        return GHOUL;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.handRaiseO = this.handRaise;
        }
        if (!this.f_19853_.f_46443_) {
            if (CombatHelper.isValidAttackTarget((LivingEntity)this.m_5448_())) {
                this.sendClientMsg(1);
            } else {
                this.sendClientMsg(2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.usingLeftHand = (Boolean)fetcher.get(0);
        } else if (flag == 1) {
            this.handRaise = Math.min(this.handRaise + 0.05f, 1.0f);
        } else if (flag == 2) {
            this.handRaise = Math.max(this.handRaise - 0.05f, 0.0f);
        }
    }

    public void setLeftHandlingAndSync(boolean state) {
        this.usingLeftHand = state;
        this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.BOOLEAN, (Object)state)});
    }

    public boolean isUsingLeftHand() {
        return this.usingLeftHand;
    }

    public float getLoopWalkMultiplier() {
        return 0.4f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)DESounds.ES_GHOUL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DESounds.ES_GHOUL_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DESounds.ES_GHOUL_IDLE.get();
    }

    public float getHandRaise() {
        return this.handRaise;
    }

    public float getHandRaiseO() {
        return this.handRaiseO;
    }

    public boolean m_6785_(double v) {
        return true;
    }

    public float inputMovementMultiplier() {
        return 1.0f;
    }

    public void setInputMovementMultiplier(float v) {
    }
}

