/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.foamspring;

import bottomtextdanny.braincell.base.Chooser;
import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FloatAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.foamspring.Foamspring;
import bottomtextdanny.dannys_expansion.tables.DEEffects;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.random.RandomGenerator;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;

public class FoamspringPsyche
extends Psyche<Foamspring> {
    public static final int MAIN_MODULE = 1;
    public static final int IDLE_ACTIONS_MODULE = 2;
    public static Chooser<SimpleAnimation> ATTACKS = Chooser.builder().put(40.0f, (Object)Foamspring.PUNCH).put(20.0f, (Object)Foamspring.LOW_PUNCH).build();
    private AttackAction attackAction;
    private LookRandomlyAction lookRandomlyAction;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<Foamspring> followTargetAction;

    public FoamspringPsyche(Foamspring mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        MarkedTimer markedTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)60));
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> markedTimer);
        inputs.put(ActionInputKey.SET_TARGET_CALL, () -> ((IntScheduler.Simple)((Foamspring)this.getMob()).attackTimer.get()).end());
    }

    protected void initialize() {
        this.attackAction = new AttackAction((Foamspring)this.getMob());
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((Foamspring)this.getMob()), target -> (double)1.3f).setRefreshRate(10);
        this.randomStrollAction = new RandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)120, (int)250));
        this.randomStrollAction.addModule(2);
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)70, (int)240)).vertical(FloatMapper.from((float)-2.0f, (float)0.5f, (FloatRandomPicker)FloatRandomPicker.linear()));
        this.lookRandomlyAction.addModule(2);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Foamspring)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            if (CombatHelper.isValidAttackTarget((Mob)mobo, (LivingEntity)target)) {
                this.onTargeting((Foamspring)((Object)mobo), target);
            } else {
                this.idling((Foamspring)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new FloatAction(this.getMob(), 0.2f));
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Foamspring)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Foamspring)this.getMob()), (IntScheduler)IntScheduler.simple((int)30), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    protected void idling(Foamspring mob) {
        this.tryAddRunningAction(2, (Action)this.randomStrollAction);
        this.tryAddRunningAction(2, (Action)this.lookRandomlyAction);
    }

    protected void onTargeting(Foamspring mob, @Nonnull LivingEntity target) {
        float reach;
        IntScheduler.Simple attackTimer = (IntScheduler.Simple)mob.attackTimer.get();
        this.blockModule(2);
        this.tryAddRunningAction(1, (Action)this.followTargetAction);
        attackTimer.incrementFreely(1);
        if (attackTimer.hasEnded() && (reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::manhattanEntityReach3)) < 1.0f) {
            this.tryAddRunningAction(1, this.attackAction);
            attackTimer.reset();
        }
    }

    public static class AttackAction
    extends Action<Foamspring> {
        private SimpleAnimation animation;

        public AttackAction(Foamspring mob) {
            super((PathfinderMob)mob);
        }

        public boolean canStart() {
            return ((Foamspring)this.mob).mainHandler.isPlayingNull();
        }

        protected void start() {
            SimpleAnimation animation;
            this.animation = animation = (SimpleAnimation)ATTACKS.pick((RandomGenerator)RANDOM);
            ((Foamspring)this.mob).setLeftHandlingAndSync(RANDOM.nextBoolean());
            ((Foamspring)this.mob).mainHandler.play((Animation)animation);
        }

        public boolean shouldKeepGoing() {
            return this.active() && ((Foamspring)this.mob).mainHandler.isPlaying((Animation)this.animation);
        }

        public void update() {
            LivingEntity target = ((Foamspring)this.mob).m_5448_();
            if (!CombatHelper.isValidAttackTarget((Mob)this.mob, (LivingEntity)target)) {
                return;
            }
            ((Foamspring)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (((Foamspring)this.mob).mainHandler.getTick() == 7) {
                ((Foamspring)this.mob).m_5496_((SoundEvent)DESounds.ES_FOAMSPRING_ATTACK.get(), 1.0f, ((Foamspring)this.mob).m_21187_().nextFloat(1.0f, 1.2f));
            } else if (((Foamspring)this.mob).mainHandler.getTick() != 9) {
                return;
            }
            float reach = ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::euclideanEntityReach3);
            if (reach < 1.25f) {
                Form form = ((Foamspring)this.mob).variableModule().getForm();
                if (CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f) && form == Foamspring.AURIC_FOAMSPRING && ((Foamspring)this.mob).m_21187_().nextFloat() < 0.6f || form == Foamspring.AURIFEROUS_FOAMSPRING) {
                    ((Foamspring)this.mob).m_5448_().m_7292_(new MobEffectInstance((MobEffect)DEEffects.YELLOW_FOAM.get(), 50 * ((Foamspring)this.mob).f_19853_.m_46791_().m_19028_(), 0));
                }
                CombatHelper.mayDisableShield((Entity)target, (int)40, (float)0.35f);
            }
        }
    }
}

