/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.foamie;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FloatAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.foamie.Foamie;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;

public class FoamiePsyche
extends Psyche<Foamie> {
    public static final int MAIN_MODULE = 1;
    public static final int IDLE_ACTIONS_MODULE = 2;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<Foamie> followTargetAction;

    public FoamiePsyche(Foamie mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        MarkedTimer markedTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)40));
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> markedTimer);
        inputs.put(ActionInputKey.SET_TARGET_CALL, () -> ((IntScheduler.Simple)((Foamie)this.getMob()).attackTimer.get()).end());
    }

    protected void initialize() {
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((Foamie)this.getMob()), target -> (double)1.3f).setRefreshRate(10);
        this.randomStrollAction = new RandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)120, (int)250));
        this.randomStrollAction.addModule(2);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Foamie)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            if (CombatHelper.isValidAttackTarget((Mob)mobo, (LivingEntity)target)) {
                this.onTargeting((Foamie)((Object)mobo), target);
            } else {
                this.idling((Foamie)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new FloatAction(this.getMob(), 0.2f));
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Foamie)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Foamie)this.getMob()), (IntScheduler)IntScheduler.simple((int)30), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    protected void idling(Foamie mob) {
        this.tryAddRunningAction(2, (Action)this.randomStrollAction);
    }

    protected void onTargeting(Foamie mob, @Nonnull LivingEntity target) {
        float reach;
        IntScheduler.Simple attackTimer = (IntScheduler.Simple)mob.attackTimer.get();
        this.blockModule(2);
        this.tryAddRunningAction(1, (Action)this.followTargetAction);
        attackTimer.incrementFreely(1);
        if (attackTimer.hasEnded() && (reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::manhattanEntityReach3)) < 0.4f) {
            CombatHelper.attackWithMultiplier((Mob)mob, (LivingEntity)target, (float)1.0f);
            CombatHelper.mayDisableShield((Entity)target, (int)10, (float)0.15f);
            attackTimer.reset();
        }
    }
}

