/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.foamcaster;

import bottomtextdanny.braincell.base.Chooser;
import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FloatAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.LookRandomlyAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.foamcaster.Foamcaster;
import bottomtextdanny.dannys_expansion.tables.DEEffects;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.random.RandomGenerator;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;

public class FoamcasterPsyche
extends Psyche<Foamcaster> {
    public static final int MAIN_MODULE = 1;
    public static final int IDLE_ACTIONS_MODULE = 2;
    public static Chooser<SimpleAnimation> ATTACKS = Chooser.builder().put(40.0f, (Object)Foamcaster.PUNCH).put(10.0f, (Object)Foamcaster.TRAP).build();
    private AttackAction attackAction;
    private LookRandomlyAction lookRandomlyAction;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<Foamcaster> followTargetAction;

    public FoamcasterPsyche(Foamcaster mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        MarkedTimer markedTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)60));
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> markedTimer);
        inputs.put(ActionInputKey.SET_TARGET_CALL, () -> ((IntScheduler.Simple)((Foamcaster)this.getMob()).attackTimer.get()).end());
    }

    protected void initialize() {
        this.attackAction = new AttackAction((Foamcaster)this.getMob());
        this.followTargetAction = new FollowTargetAction((PathfinderMob)((Foamcaster)this.getMob()), target -> (double)1.3f).setRefreshRate(10);
        this.randomStrollAction = new RandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)120, (int)250));
        this.randomStrollAction.addModule(2);
        this.lookRandomlyAction = new LookRandomlyAction(this.getMob(), RandomIntegerMapper.of((int)120, (int)250)).vertical(FloatMapper.from((float)-1.0f, (float)0.5f, (FloatRandomPicker)FloatRandomPicker.linear()));
        this.lookRandomlyAction.addModule(2);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Foamcaster)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            if (CombatHelper.isValidAttackTarget((Mob)mobo, (LivingEntity)target)) {
                this.onTargeting((Foamcaster)((Object)mobo), target);
            } else {
                this.idling((Foamcaster)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new FloatAction(this.getMob(), 0.2f));
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Foamcaster)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Foamcaster)this.getMob()), (IntScheduler)IntScheduler.simple((int)30), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    protected void idling(Foamcaster mob) {
        this.tryAddRunningAction(2, (Action)this.randomStrollAction);
        this.tryAddRunningAction(2, (Action)this.lookRandomlyAction);
    }

    protected void onTargeting(Foamcaster mob, @Nonnull LivingEntity target) {
        float reach;
        IntScheduler.Simple attackTimer = (IntScheduler.Simple)mob.attackTimer.get();
        this.blockModule(2);
        this.tryAddRunningAction(1, (Action)this.followTargetAction);
        attackTimer.incrementFreely(1);
        if (attackTimer.hasEnded() && (reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::manhattanEntityReach3)) < 1.3f) {
            this.tryAddRunningAction(1, this.attackAction);
            attackTimer.reset();
        }
    }

    public static class AttackAction
    extends Action<Foamcaster> {
        private SimpleAnimation animation;

        public AttackAction(Foamcaster mob) {
            super((PathfinderMob)mob);
        }

        public boolean canStart() {
            return ((Foamcaster)this.mob).mainHandler.isPlayingNull();
        }

        protected void start() {
            SimpleAnimation animation;
            this.animation = animation = (SimpleAnimation)ATTACKS.pick((RandomGenerator)RANDOM);
            ((Foamcaster)this.mob).setLeftHandlingAndSync(RANDOM.nextBoolean());
            ((Foamcaster)this.mob).mainHandler.play((Animation)animation);
        }

        public boolean shouldKeepGoing() {
            return this.active() && ((Foamcaster)this.mob).mainHandler.isPlaying((Animation)this.animation);
        }

        public void update() {
            LivingEntity target = ((Foamcaster)this.mob).m_5448_();
            if (!CombatHelper.isValidAttackTarget((Mob)this.mob, (LivingEntity)target)) {
                return;
            }
            ((Foamcaster)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (((Foamcaster)this.mob).mainHandler.getTick() == 7) {
                ((Foamcaster)this.mob).m_5496_((SoundEvent)DESounds.ES_FOAMCASTER_ATTACK.get(), 1.0f, ((Foamcaster)this.mob).m_21187_().nextFloat(1.0f, 1.2f));
            } else if (((Foamcaster)this.mob).mainHandler.getTick() != 9) {
                return;
            }
            float reach = ReachHelper.reach3((Entity)this.mob, (Entity)target, ReachHelper::euclideanEntityReach3);
            if (reach < 1.625f) {
                if (CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)target, (float)1.0f) && ((Foamcaster)this.mob).variableModule().getForm() == Foamcaster.AURIC_FOAMCASTER && ((Foamcaster)this.mob).m_21187_().nextFloat() < 0.6f) {
                    ((Foamcaster)this.mob).m_5448_().m_7292_(new MobEffectInstance((MobEffect)DEEffects.YELLOW_FOAM.get(), 50 * ((Foamcaster)this.mob).f_19853_.m_46791_().m_19028_(), 0));
                }
                CombatHelper.mayDisableShield((Entity)target, (int)20, (float)0.25f);
            }
        }
    }
}

