/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.floam;

import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.MoveReactionToEntityAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessors;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetRange;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.Targeter;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion._util.DEFloatMappers;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.floam.Floam;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FloamPsyche
extends Psyche<Floam> {
    public static final TargetPredicate TARGET_PREDICATE = Targeter.Builder.start((TargetRange)TargetRange.followRange()).isForCombat().targetRangeForInvisible(TargetRange.followRange()).hasToBeOnSight().build();
    public static final MobPosProcessor<Object> STROLL = MobPosProcessors.compose((pos, mob, r, extra) -> {
        FloatMapper view = DEFloatMappers.range(mob.m_6080_() * ((float)Math.PI / 180), 0.34906584f, FloatRandomPicker.normal());
        MobPosPredicate stable = MobPosPredicates.isStable().and(MobPosPredicates.noFluid());
        MobPosPredicate downIf = MobPosPredicates.isStable().negate().or(MobPosPredicates.noFluid());
        return MobPosProcessors.testNull((MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.advanceHorizontal((FloatMapper)view, (FloatMapper)FloatMapper.from((float)6.0f, (float)8.0f, (FloatRandomPicker)FloatRandomPicker.linear()))).push(MobPosProcessors.sample((int)10, (MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.randomOffset((int)5, (int)5, (int)5)), FloamPsyche.evaluatePos(mob))).push(MobPosProcessors.find((int)10, (MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.randomOffset((int)4, (int)3, (int)4)).push((MobPosProcessor)MobPosProcessors.testNull((MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.moveIf((Direction)Direction.DOWN, (int)7, (MobPosPredicate)downIf)).push(MobPosProcessors.pred((MobPosPredicate)stable)).push(MobPosProcessors.move((Direction)Direction.UP, (FloatMapper)FloatMapper.from((float)6.0f, (float)8.0f, (FloatRandomPicker)FloatRandomPicker.normal()))))).push(MobPosProcessors.pred((MobPosPredicate)MobPosPredicates.isStable().negate().and(MobPosPredicates.noFluid()))))));
    });
    public static final MobPosProcessor<LivingEntity> APPROACH_POS = MobPosProcessors.compose((blockPos, mob, randomGenerator, target) -> {
        Vec3 posDiff = mob.m_20182_().m_82546_(target.m_20182_());
        float oppositeFromTargetRad = (float)Mth.m_14136_((double)posDiff.f_82479_, (double)posDiff.f_82481_) + (float)Math.PI;
        FloatMapper angleAwayFromTarget = FloatMapper.from((float)(oppositeFromTargetRad - 0.34906584f), (float)(oppositeFromTargetRad + 0.34906584f), (FloatRandomPicker)FloatRandomPicker.normal());
        int yDifference = (int)(target.m_20186_() - mob.m_20186_());
        FloatMapper stepAway = FloatMapper.of((float)14.0f);
        return MobPosProcessors.stack().generic(LivingEntity.class).push(MobPosProcessors.advanceHorizontal((FloatMapper)angleAwayFromTarget, (FloatMapper)stepAway)).push(MobPosProcessors.offset((int)0, (int)yDifference, (int)0)).push(MobPosProcessors.sample((int)5, (MobPosProcessor)MobPosProcessors.randomOffset((int)3, (int)2, (int)3), Shared.evaluateApproachingPos(mob, 1.0f)));
    });
    public static final int COMBAT_MODULE = 1;
    public static final int IDLE_MODULE = 2;
    public static final int ATTACK_MODULE = 3;
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)100));
    private RandomStrollAction wanderAction;
    private MoveReactionToEntityAction<Floam, LivingEntity> flyToTargetAction;

    public FloamPsyche(Floam mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
    }

    protected void initialize() {
        this.flyToTargetAction = new MoveReactionToEntityAction((PathfinderMob)((Floam)this.getMob()), TargetRange.followRange().cast(), APPROACH_POS).speedByTarget(target -> (double)2.1f).setRefreshRate(5).searchRange(() -> 0.0).searchBy(Shared.searchTargetSpecifically());
        this.wanderAction = new RandomStrollAction(this.getMob(), STROLL, RandomIntegerMapper.of((int)1)){

            protected void update() {
                super.update();
                Path path = this.mob.m_21573_().m_26570_();
                if (path != null && path.m_77399_() <= path.m_77398_()) {
                    Vec3 vec = Vec3.m_82539_((Vec3i)path.m_77400_()).m_82520_(0.0, (double)this.mob.m_20192_(), 0.0);
                    this.mob.m_21563_().m_24950_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 180.0f, 30.0f);
                }
            }
        };
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((Floam)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                this.onTargeting((Floam)((Object)mobo), target);
            } else {
                this.idling((Floam)((Object)mobo));
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)TARGET_PREDICATE));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Floam)this.getMob()), (IntScheduler)IntScheduler.simple((int)4), (MobMatchPredicate)TARGET_PREDICATE, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((Floam)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)TARGET_PREDICATE), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    protected void idling(Floam mob) {
        this.tryAddRunningAction(2, (Action)this.wanderAction);
    }

    protected void onTargeting(Floam mob, @Nonnull LivingEntity target) {
        float reach;
        IntScheduler.Simple attackTimer = (IntScheduler.Simple)mob.attackTimer.get();
        this.blockModule(2);
        this.tryAddRunningAction(1, (Action)this.flyToTargetAction);
        mob.m_21563_().m_24960_((Entity)target, 50.0f, 40.0f);
        attackTimer.incrementFreely(1);
        if (attackTimer.hasEnded() && (reach = ReachHelper.reach3((Entity)mob, (Entity)target, ReachHelper::manhattanEntityReach3)) < 0.6f) {
            CombatHelper.attackWithMultiplier((Mob)mob, (LivingEntity)target, (float)1.0f);
            CombatHelper.mayDisableShield((Entity)target, (int)10, (float)0.15f);
            attackTimer.reset();
        }
    }

    public static Function<Object, Comparator<BlockPos>> evaluatePos(Mob mob) {
        return bad -> Comparator.comparingDouble(pos -> {
            double value = 0.0;
            BlockPos l = pos.m_141950_((Vec3i)mob.m_142538_());
            double dif = 1.0 - (double)Mth.m_14118_((float)mob.m_6080_(), (float)((float)(Mth.m_14136_((double)l.m_123341_(), (double)l.m_123343_()) * 57.2957763671875) - 90.0f)) / 180.0;
            dif *= 1.5;
            double heightValue = (1.0 - (double)Mth.m_14045_((int)l.m_123342_(), (int)-5, (int)5) / 5.0) * 1.5;
            if (!mob.f_19853_.m_8055_(pos).m_60819_().m_76178_()) {
                value += 5.0;
            }
            if (GoalUtils.m_148448_((PathNavigation)mob.m_21573_(), (BlockPos)pos)) {
                heightValue *= 0.5;
                value += 8.0;
            }
            return value + dif + heightValue;
        });
    }
}

