/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.cursed_skull;

import bottomtextdanny.braincell.base.FloatRandomPicker;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMapper;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.MoveReactionToEntityAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessors;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.TargetRange;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.Targeter;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.dannys_expansion._util.DEFloatMappers;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.cursed_skull.CursedSkull;
import bottomtextdanny.dannys_expansion.content.entities.projectile.CursedFireball;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class CursedSkullPsyche
extends Psyche<CursedSkull> {
    public static final TargetPredicate TARGET_PREDICATE = Targeter.Builder.start((TargetRange)TargetRange.followRange()).isForCombat().targetRangeForInvisible(TargetRange.followRangeMultiplied((float)0.75f)).hasToBeOnSight().build();
    public static final MobPosProcessor<Object> STROLL = MobPosProcessors.compose((pos, mob, r, extra) -> {
        FloatMapper view = DEFloatMappers.range(mob.m_6080_() * ((float)Math.PI / 180), 0.34906584f, FloatRandomPicker.normal());
        MobPosPredicate stable = MobPosPredicates.isStable().and(MobPosPredicates.noFluid());
        MobPosPredicate downIf = MobPosPredicates.isStable().negate().or(MobPosPredicates.noFluid());
        return MobPosProcessors.testNull((MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.advanceHorizontal((FloatMapper)view, (FloatMapper)FloatMapper.from((float)6.0f, (float)8.0f, (FloatRandomPicker)FloatRandomPicker.linear()))).push(MobPosProcessors.sample((int)10, (MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.randomOffset((int)5, (int)5, (int)5)), CursedSkullPsyche.evaluatePos(mob))).push(MobPosProcessors.find((int)10, (MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.randomOffset((int)4, (int)3, (int)4)).push((MobPosProcessor)MobPosProcessors.testNull((MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.moveIf((Direction)Direction.DOWN, (int)7, (MobPosPredicate)downIf)).push(MobPosProcessors.pred((MobPosPredicate)stable)).push(MobPosProcessors.move((Direction)Direction.UP, (FloatMapper)FloatMapper.from((float)6.0f, (float)8.0f, (FloatRandomPicker)FloatRandomPicker.normal()))))).push(MobPosProcessors.pred((MobPosPredicate)MobPosPredicates.isStable().negate().and(MobPosPredicates.noFluid()))))));
    });
    public static final MobPosProcessor<LivingEntity> AVOID_POS = MobPosProcessors.compose((blockPos, mob, randomGenerator, target) -> {
        Vec3 posDiff = mob.m_20182_().m_82546_(target.m_20182_());
        float oppositeFromTargetRad = (float)Mth.m_14136_((double)posDiff.f_82479_, (double)posDiff.f_82480_);
        FloatMapper angleAwayFromTarget = FloatMapper.from((float)(oppositeFromTargetRad - 0.34906584f), (float)(oppositeFromTargetRad + 0.34906584f), (FloatRandomPicker)FloatRandomPicker.normal());
        FloatMapper stepAway = FloatMapper.of((float)14.0f);
        return MobPosProcessors.stack().generic(LivingEntity.class).push(MobPosProcessors.advanceHorizontal((FloatMapper)angleAwayFromTarget, (FloatMapper)stepAway)).push(MobPosProcessors.sample((int)5, (MobPosProcessor)MobPosProcessors.randomOffset((int)3, (int)4, (int)3), Shared.evaluateAvoidingPos(mob, 1.0f)));
    });
    public static final MobPosProcessor<LivingEntity> APPROACH_POS = MobPosProcessors.compose((blockPos, mob, randomGenerator, target) -> {
        Vec3 posDiff = mob.m_20182_().m_82546_(target.m_20182_());
        float oppositeFromTargetRad = (float)Mth.m_14136_((double)posDiff.f_82479_, (double)posDiff.f_82481_) + (float)Math.PI;
        FloatMapper angleAwayFromTarget = FloatMapper.from((float)(oppositeFromTargetRad - 0.34906584f), (float)(oppositeFromTargetRad + 0.34906584f), (FloatRandomPicker)FloatRandomPicker.normal());
        FloatMapper stepAway = FloatMapper.of((float)14.0f);
        return MobPosProcessors.stack().generic(LivingEntity.class).push(MobPosProcessors.advanceHorizontal((FloatMapper)angleAwayFromTarget, (FloatMapper)stepAway)).push(MobPosProcessors.sample((int)5, (MobPosProcessor)MobPosProcessors.randomOffset((int)3, (int)4, (int)3), Shared.evaluateApproachingPos(mob, 1.0f)));
    });
    public static final int COMBAT_MODULE = 1;
    public static final int AVOID_MODULE = 2;
    public static final int IDLE_MODULE = 3;
    public static final int ATTACK_MODULE = 4;
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)100));
    private RandomStrollAction wanderAction;
    private MoveReactionToEntityAction<CursedSkull, LivingEntity> flyAwayFromLookAction;
    private MoveReactionToEntityAction<CursedSkull, LivingEntity> flyToLookAction;
    private SpitAction spitAction;

    public CursedSkullPsyche(CursedSkull mob) {
        super((PathfinderMob)mob);
        this.allocateModules(5);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
        inputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
    }

    protected void initialize() {
        this.spitAction = new SpitAction((CursedSkull)this.getMob());
        this.flyAwayFromLookAction = new MoveReactionToEntityAction((PathfinderMob)((CursedSkull)this.getMob()), TargetRange.followRangeMultiplied((float)0.4f).cast(), AVOID_POS).speedByTarget(target -> 1.5).setRefreshRate(15).searchRange(() -> 0.0).searchBy(Shared.searchTargetSpecifically());
        this.flyToLookAction = new MoveReactionToEntityAction((PathfinderMob)((CursedSkull)this.getMob()), TargetRange.followRange().cast(), APPROACH_POS).speedByTarget(target -> 1.0).setRefreshRate(15).searchRange(() -> 0.0).searchBy(Shared.searchTargetSpecifically());
        this.wanderAction = new RandomStrollAction(this.getMob(), STROLL, RandomIntegerMapper.of((int)1)){

            protected void update() {
                super.update();
                Path path = this.mob.m_21573_().m_26570_();
                if (path != null && path.m_77399_() <= path.m_77398_()) {
                    Vec3 vec = Vec3.m_82539_((Vec3i)path.m_77400_()).m_82520_(0.0, (double)this.mob.m_20192_(), 0.0);
                    this.mob.m_21563_().m_24950_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 180.0f, 30.0f);
                }
            }
        };
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((CursedSkull)this.getMob()), mobo -> {
            LivingEntity target = mobo.m_5448_();
            if (CombatHelper.isValidAttackTarget((LivingEntity)target)) {
                this.blockModule(3);
                boolean seen = mobo.m_21574_().m_148306_((Entity)target);
                IntScheduler attackDelay = (IntScheduler)((CursedSkull)this.getMob()).attackDelay.get();
                ((CursedSkull)this.getMob()).m_21563_().m_24960_((Entity)mobo.m_5448_(), 180.0f, 50.0f);
                if (seen && TargetRange.followRangeMultiplied((float)0.4f).test((Mob)mobo, (Object)target)) {
                    this.tryAddRunningAction(2, (Action)this.flyAwayFromLookAction);
                } else {
                    this.tryAddRunningAction(1, (Action)this.flyToLookAction);
                }
                if (attackDelay.hasEnded()) {
                    if (seen) {
                        this.tryAddRunningAction(4, (Action)this.spitAction);
                    }
                    attackDelay.reset();
                } else {
                    attackDelay.advance();
                }
            } else {
                this.tryAddRunningAction(3, (Action)this.wanderAction);
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)TARGET_PREDICATE));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((CursedSkull)this.getMob()), (IntScheduler)IntScheduler.simple((int)4), (MobMatchPredicate)TARGET_PREDICATE, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((CursedSkull)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)TARGET_PREDICATE), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
    }

    public static Function<Object, Comparator<BlockPos>> evaluatePos(Mob mob) {
        return bad -> Comparator.comparingDouble(pos -> {
            double value = 0.0;
            BlockPos l = pos.m_141950_((Vec3i)mob.m_142538_());
            double dif = 1.0 - (double)Mth.m_14118_((float)mob.m_6080_(), (float)((float)(Mth.m_14136_((double)l.m_123341_(), (double)l.m_123343_()) * 57.2957763671875) - 90.0f)) / 180.0;
            dif *= 1.5;
            double heightValue = (1.0 - (double)Mth.m_14045_((int)l.m_123342_(), (int)-5, (int)5) / 5.0) * 1.5;
            if (GoalUtils.m_148448_((PathNavigation)mob.m_21573_(), (BlockPos)pos) || !mob.f_19853_.m_8055_(pos).m_60819_().m_76178_()) {
                heightValue *= 0.5;
                value += 8.0;
            }
            return value + dif + heightValue;
        });
    }

    public static class SpitAction
    extends AnimationAction<CursedSkull, SimpleAnimation> {
        private boolean stop;

        public SpitAction(CursedSkull mob) {
            super((PathfinderMob)mob, (Animation)CursedSkull.SPIT, mob.mainHandler);
        }

        protected void start() {
            super.start();
            this.stop = ((CursedSkull)this.mob).m_21187_().nextFloat() < 0.3f;
        }

        public void update() {
            super.update();
            if (this.stop) {
                this.getPsyche().blockModule(1);
                this.getPsyche().blockModule(2);
            }
            if (this.animationHandler.getTick() == 4) {
                ((CursedSkull)this.mob).f_19853_.m_6263_(null, ((CursedSkull)this.mob).m_20185_(), ((CursedSkull)this.mob).m_20188_(), ((CursedSkull)this.mob).m_20189_(), (SoundEvent)DESounds.ES_CURSED_SKULL_SPIT.get(), SoundSource.HOSTILE, 1.0f + 0.07f * ((CursedSkull)this.mob).m_21187_().nextFloat(), 1.0f + 0.2f * ((CursedSkull)this.mob).m_21187_().nextFloat());
            } else if (this.animationHandler.getTick() == 9) {
                float heightDelta = ((CursedSkull)this.mob).m_20206_() / 2.0f;
                CursedFireball fireball = new CursedFireball((EntityType<? extends Projectile>)((EntityType)DEEntities.CURSED_FIREBALL.get()), ((CursedSkull)this.mob).f_19853_);
                fireball.setCaster((LivingEntity)this.mob);
                fireball.m_6034_(((CursedSkull)this.mob).m_20185_(), ((CursedSkull)this.mob).m_20186_() + (double)heightDelta, ((CursedSkull)this.mob).m_20189_());
                fireball.m_146926_(((CursedSkull)this.mob).m_146909_());
                fireball.m_146922_(((CursedSkull)this.mob).m_146908_());
                ((CursedSkull)this.mob).f_19853_.m_7967_((Entity)fireball);
            }
        }
    }
}

