/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.cursed_skull;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionModule;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionProvider;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.braincell.mod.serialization.BCSerializers;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityHurtCallout;
import bottomtextdanny.dannys_expansion._util.EffectHelper;
import bottomtextdanny.dannys_expansion.content.entities.ai.controllers.EasedLookControl;
import bottomtextdanny.dannys_expansion.content.entities.ai.controllers.FluentFlyingControl;
import bottomtextdanny.dannys_expansion.content.entities.mob.BCFlyingPathNavigation;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.cursed_skull.CursedSkullPsyche;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CursedSkull
extends SmartyMob
implements Enemy,
ExtraMotionProvider,
EntityHurtCallout {
    private static final int JAW_FLAG = 0;
    public static final float WANDER_MOVE_SPEED = 0.8f;
    public static final float COMBAT_MOVE_SPEED = 1.0f;
    public static final int ATTACK_DELAY_MIN = 50;
    public static final int ATTACK_DELAY_MAX = 65;
    public static final float FLEE_RANGE = 0.4f;
    public static final EntityDataReference<IntScheduler.Ranged> ATTACKS_DELAY_REF = BCDataManager.attribute(CursedSkull.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BCSerializers.RANGED_INT_SCHEDULER, () -> IntScheduler.ranged((int)50, (int)65), (String)"attack_delay"));
    public static final SimpleAnimation SPIT = new SimpleAnimation(20);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{SPIT});
    private final FluentFlyingControl wanderMoveControl;
    private final FluentFlyingControl combatMoveControl;
    private ExtraMotionModule extraMotionModule;
    public final EntityData<IntScheduler.Ranged> attackDelay;
    private float jawPointer;
    public float jawAnimation;
    public float jawAnimationO;
    private boolean combatMode;

    public CursedSkull(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
        this.wanderMoveControl = new FluentFlyingControl((Mob)this, 70, true);
        this.f_21342_ = this.wanderMoveControl;
        this.combatMoveControl = new FluentFlyingControl((Mob)this, 180, false);
        this.f_21365_ = new EasedLookControl((Mob)this, () -> Float.valueOf(this.combatMode ? 90.0f : 25.0f), () -> Float.valueOf(this.combatMode ? 20.0f : 15.0f));
        this.attackDelay = this.bcDataManager().addNonSyncedData(EntityData.of(ATTACKS_DELAY_REF));
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22281_, 7.0);
    }

    public static boolean spawnPlacement(EntityType<? extends CursedSkull> entityType, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)level, (BlockPos)pos, (Random)random) && CursedSkull.m_21400_(entityType, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    protected void commonInit() {
        this.extraMotionModule = new ExtraMotionModule((Entity)this);
    }

    @Override
    public Psyche<?> makePsyche() {
        return new CursedSkullPsyche(this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        BCFlyingPathNavigation flyingpathnavigation = new BCFlyingPathNavigation((Mob)this, this.f_19853_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public MoveControl m_21566_() {
        return this.m_5448_() != null && this.m_5448_().m_6084_() ? this.combatMoveControl : this.wanderMoveControl;
    }

    public AnimationArray getAnimations() {
        return ANIMATIONS;
    }

    public ExtraMotionModule extraMotionModule() {
        return this.extraMotionModule;
    }

    public void m_8119_() {
        super.m_8119_();
        Connection.doClientSide(() -> this.clientTick());
        this.f_19789_ = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        this.jawAnimationO = this.jawAnimation;
        this.jawPointer = Mth.m_14036_((float)this.jawPointer, (float)0.0f, (float)1.5707964f);
        this.jawAnimation = Mth.m_14179_((float)0.5f, (float)this.jawAnimation, (float)this.jawPointer);
        this.jawPointer *= 0.84f;
        if (this.f_19796_.nextInt(7) == 0) {
            double posOffsetX = this.f_19796_.nextGaussian() * 0.2;
            double posOffsetY = this.f_19796_.nextGaussian() * 0.2 + 0.25;
            double posOffsetZ = this.f_19796_.nextGaussian() * 0.2;
            this.f_19853_.m_7106_((ParticleOptions)DEParticles.CURSED_FLAMES.get(), this.m_20185_() + posOffsetX, this.m_20186_() + posOffsetY, this.m_20189_() + posOffsetZ, posOffsetX * 0.4, posOffsetY * 0.4, posOffsetZ * 0.4);
        }
    }

    @Override
    public void m_8107_() {
        if (this.m_6084_() && this.m_6142_()) {
            this.m_20242_(true);
            this.combatMode = this.m_5448_() != null && this.m_5448_().m_6084_();
            this.f_21342_ = this.combatMode ? this.combatMoveControl : this.wanderMoveControl;
        }
        super.m_8107_();
    }

    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.jawPointer += ((Float)fetcher.get(0, Float.class)).floatValue() * ((float)Math.PI / 180);
        }
    }

    public boolean m_147207_(MobEffectInstance effectInstanceIn, @Nullable Entity entityIn) {
        if (EffectHelper.isBadAndOnlyAppliesToLiving(effectInstanceIn.m_19544_())) {
            return false;
        }
        return super.m_147207_(effectInstanceIn, entityIn);
    }

    public float hurtCallOut(float damage, DamageSource damageSource) {
        if (!this.f_19853_.f_46443_) {
            this.updateClientJaw(25.0f);
        }
        return damage;
    }

    public void updateClientJaw(float openDegrees) {
        this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(openDegrees))});
    }

    public void m_8032_() {
        if (this.f_19853_.f_46443_) {
            SoundEvent soundevent = this.m_7515_();
            if (soundevent != null) {
                Vec3 position = this.m_20182_();
                this.f_19853_.m_7785_(position.f_82479_, position.f_82480_, position.f_82481_, soundevent, SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_(), false);
            }
            this.jawPointer += 0.87266463f;
        }
    }

    public boolean isCombatMode() {
        return this.combatMode;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)DESounds.ES_CURSED_SKULL_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)DESounds.ES_CURSED_SKULL_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)DESounds.ES_CURSED_SKULL_IDLE.get();
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }
}

