/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.misc;

import bottomtextdanny.braincell.base.BCLerp;
import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimatableModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimatableProvider;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.items.DEBuildingItems;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class TestDummyEntity
extends LivingEntity
implements AnimatableProvider,
EntityClientMessenger {
    public static final int DAMAGE_UPDATE_CALL = 0;
    public static final int ANIMATION_CALL = 1;
    public static final SimpleAnimation HURT = new SimpleAnimation(10);
    public final AnimatableModule animatableModule;
    public final AnimationHandler<TestDummyEntity> mainAnimationModule;
    private final Object2FloatMap<MutableInt> damageMap = new Object2FloatOpenHashMap();
    private float displayDamageDirection;
    private float displayDamage;
    public float hitYaw;

    public TestDummyEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
        this.animatableModule = new AnimatableModule((Entity)this, (AnimationGetter)HURT);
        this.mainAnimationModule = this.addAnimationHandler(new AnimationHandler((Entity)this));
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    public AnimatableModule animatableModule() {
        return this.animatableModule;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.damageMap.isEmpty()) {
            this.damageMap.object2FloatEntrySet().removeIf(entry -> {
                if (((MutableInt)entry.getKey()).getValue() > 0) {
                    ((MutableInt)entry.getKey()).decrement();
                    return false;
                }
                this.updateDisplayDamage();
                return true;
            });
        }
        if (this.f_19853_.m_5776_()) {
            this.displayDamage = Math.max(BCLerp.get((float)0.5f, (float)this.displayDamage, (float)this.displayDamageDirection), this.displayDamageDirection);
        }
    }

    public void updateDisplayDamage() {
        if (!this.damageMap.isEmpty()) {
            int highestTimeFactor = 0;
            int lowestTimeFactor = 60;
            float damage = 0.0f;
            for (Map.Entry entry : this.damageMap.entrySet()) {
                int realTime = ((MutableInt)entry.getKey()).getValue();
                if (realTime <= 1) continue;
                if (lowestTimeFactor > realTime) {
                    lowestTimeFactor = realTime;
                }
                if (highestTimeFactor < realTime) {
                    highestTimeFactor = realTime;
                }
                damage += ((Float)entry.getValue()).floatValue();
            }
            float difference = ((float)(highestTimeFactor - lowestTimeFactor) + (float)(highestTimeFactor - lowestTimeFactor) / 3.0f) * 0.05f;
            if (difference < 1.0f) {
                difference = 1.0f;
            }
            this.displayDamageDirection = damage / difference;
        } else {
            this.displayDamageDirection = 0.0f;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.f_19802_ > 0) {
            return false;
        }
        if (source == DamageSource.f_19310_) {
            return false;
        }
        if (source == DamageSource.f_19308_) {
            this.m_6089_();
            return false;
        }
        if (!this.f_19853_.m_5776_()) {
            amount = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)source, (float)amount);
            amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)amount);
        }
        this.m_5496_(this.m_7975_(source), 1.0f, 1.0f + this.f_19796_.nextFloat() * 0.1f);
        boolean flag = super.m_6469_(source, amount);
        if (!this.f_19853_.m_5776_()) {
            this.damageMap.putIfAbsent((Object)new MutableInt(60), amount);
            this.updateDisplayDamage();
            this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(amount))});
            this.hitYaw = source.m_7640_() != null ? DEMath.getTargetYaw(source.m_7640_().m_20182_().f_82479_, source.m_7640_().m_20182_().f_82481_, this.m_20182_().f_82479_, this.m_20182_().f_82481_) : this.m_146908_();
            this.sendClientMsg(1, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(this.hitYaw))});
        }
        this.f_19802_ = 10;
        return flag;
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
    }

    public void m_6210_() {
        super.m_6210_();
    }

    public float getDPS() {
        return this.displayDamage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.damageMap.putIfAbsent((Object)new MutableInt(60), (Float)fetcher.get(0, Float.class));
            this.updateDisplayDamage();
        } else if (flag == 1) {
            this.hitYaw = ((Float)fetcher.get(0, Float.class)).floatValue();
            this.mainAnimationModule.play((Animation)HURT);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (player.m_6144_()) {
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)DEBuildingItems.TEST_DUMMY.get()));
            itemEntity.m_5997_(0.0, 0.05, 0.0);
            this.f_19853_.m_7967_((Entity)itemEntity);
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_TEST_DUMMY_REMOVE.get(), SoundSource.BLOCKS, 0.75f, 1.0f + this.f_19796_.nextFloat() * 0.1f, false);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.CONSUME;
        }
        return super.m_7111_(player, vec, hand);
    }

    protected float m_5632_(float p_110146_1_, float p_110146_2_) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public double m_6049_() {
        return 0.0;
    }

    public void m_5618_(float offset) {
        this.f_20884_ = this.f_19859_ = offset;
        this.f_20886_ = this.f_20885_ = offset;
    }

    public void m_5616_(float rotation) {
        this.f_20884_ = this.f_19859_ = rotation;
        this.f_20886_ = this.f_20885_ = rotation;
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
    }

    protected void m_7324_(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.m_20365_(entityIn) && !entityIn.f_19794_ && !this.f_19794_ && (d2 = Mth.m_14005_((double)(d0 = entityIn.m_20185_() - this.m_20185_()), (double)(d1 = entityIn.m_20189_() - this.m_20189_()))) >= (double)0.01f) {
            d2 = Mth.m_14116_((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!entityIn.m_20160_()) {
                entityIn.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public void m_20334_(double x, double y, double z) {
        super.m_20334_(0.0, y, 0.0);
    }

    public void m_5997_(double x, double y, double z) {
        super.m_5997_(0.0, y, 0.0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DESounds.ES_TEST_DUMMY_HIT.get();
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>(0);
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

