/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.misc;

import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.LoopedAnimation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.content._client.sound_instances.EnderDragonRewardLoopSound;
import bottomtextdanny.dannys_expansion.content.entities.misc.DEBaseEntity;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderDragonRewardEntity
extends DEBaseEntity {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dannys_expansion", "gameplay/ender_dragon_reward");
    public final AnimationHandler<EnderDragonRewardEntity> rotationLoopHandler = this.addAnimationHandler(new AnimationHandler((Entity)this));
    public static final SimpleAnimation SPAWN = new SimpleAnimation(15);
    public static final LoopedAnimation ROTATE = new LoopedAnimation(200);
    public static final SimpleAnimation GIVE_ITEMS = new SimpleAnimation(60);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{SPAWN, ROTATE, GIVE_ITEMS});
    @OnlyIn(value=Dist.CLIENT)
    private EnderDragonRewardLoopSound loopSound;
    private float fxIntensity;
    private float prevFxIntensity;

    public EnderDragonRewardEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void commonInit() {
    }

    @Override
    public AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.f_19853_.m_5776_()) {
            this.rotationLoopHandler.play((Animation)ROTATE);
            this.mainAnimationHandler.play((Animation)SPAWN);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.mainAnimationHandler.isPlaying((Animation)GIVE_ITEMS)) {
            int animTick = this.mainAnimationHandler.getTick();
            if (!this.f_19853_.m_5776_()) {
                if (animTick == 50) {
                    this.ejectGifts();
                } else if (animTick == 59) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                Connection.doClientSide(() -> this.handleGiftAnimationClient(animTick));
            }
        }
        if (this.f_19853_.f_46443_) {
            this.handleLightEffect();
            Connection.doClientSide(() -> this.handleLoopSoundClient());
        }
    }

    public void ejectGifts() {
        List<ItemStack> loot = this.lootListUnsafe();
        float heightByHalf = this.m_20206_() / 2.0f;
        for (ItemStack stack : loot) {
            float pitch = 40.0f * this.f_19796_.nextFloat() - 30.0f;
            float yaw = 360.0f * this.f_19796_.nextFloat();
            Vec3 ejectVector = Vec3.m_82498_((float)pitch, (float)yaw).m_82490_(0.2);
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + ejectVector.f_82479_ * 2.0, this.m_20186_() + ejectVector.f_82480_ * 2.0 + (double)heightByHalf, this.m_20189_() + ejectVector.f_82481_ * 2.0, stack);
            itementity.m_20242_(true);
            itementity.m_20256_(ejectVector);
            itementity.m_32010_(20);
            itementity.f_19812_ = false;
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    public void handleLightEffect() {
        this.prevFxIntensity = this.fxIntensity;
        if (this.mainAnimationHandler.isPlaying((Animation)SPAWN)) {
            this.fxIntensity = (float)this.mainAnimationHandler.getTick() / 15.0f;
        } else if (this.mainAnimationHandler.isPlaying((Animation)GIVE_ITEMS)) {
            float tick = this.mainAnimationHandler.getTick();
            if (tick > 45.0f && tick <= 50.0f) {
                this.fxIntensity = 1.0f + 0.8f * (tick - 45.0f);
            } else if (tick > 50.0f && tick <= 60.0f) {
                this.fxIntensity = (10.0f - tick - 50.0f) * 0.5f;
            }
        } else if (this.f_19797_ > 14) {
            this.fxIntensity = 1.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleGiftAnimationClient(int animationTick) {
        if (animationTick == 1) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (SoundEvent)DESounds.ES_ENDER_DRAGON_REWARD_USE.get(), SoundSource.NEUTRAL, 0.2f, 0.2f, false);
        } else if (animationTick == 20) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (SoundEvent)DESounds.ES_ENDER_DRAGON_REWARD_INIT.get(), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
        }
        if (animationTick == 45) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (SoundEvent)DESounds.ES_ENDER_DRAGON_REWARD_OPEN.get(), SoundSource.NEUTRAL, 3.0f, 1.0f, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleLoopSoundClient() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (this.loopSound == null || this.loopSound.m_7801_() && Minecraft.m_91087_().f_91074_.m_20270_((Entity)this) < 20.0f) {
            this.loopSound = new EnderDragonRewardLoopSound(this);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.loopSound);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.f_19853_.f_46443_ && this.mainAnimationHandler.isPlayingNull()) {
            this.mainAnimationHandler.play((Animation)GIVE_ITEMS);
        }
        return super.m_7111_(player, vec, hand);
    }

    private List<ItemStack> lootListUnsafe() {
        LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(LOOT_TABLE);
        return loottable.m_79129_(new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)this).m_78977_(this.f_19853_.f_46441_).m_78975_(LootContextParamSet.m_165477_().m_81405_()));
    }

    public float getFxIntensity() {
        return this.fxIntensity;
    }

    public float getPrevFxIntensity() {
        return this.prevFxIntensity;
    }

    public boolean m_6087_() {
        return true;
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }
}

