/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.ai.controllers;

import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExternalMotion;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionProvider;
import bottomtextdanny.dannys_expansion._util.DEMath;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class FluentFlyingControl
extends MoveControl {
    private final ExtraMotionProvider util;
    private final int maxTurn;
    private final ExternalMotion advanceMotion;
    private final boolean lockToView;

    public FluentFlyingControl(Mob mob, int maxTurns, boolean lockToView) {
        super(mob);
        this.lockToView = lockToView;
        this.maxTurn = maxTurns;
        if (!(mob instanceof ExtraMotionProvider)) {
            throw new UnsupportedOperationException("Danny's Expansion: FluentFlyingControl needs holder to be an instance of MotionUtilProvider.");
        }
        ExtraMotionProvider provider = (ExtraMotionProvider)mob;
        this.advanceMotion = provider.addCustomMotion(new ExternalMotion(0.8f));
        this.util = provider;
    }

    public void m_8126_() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.f_24974_.m_20242_(true);
            double deltaX = this.f_24975_ - this.f_24974_.m_20185_();
            double deltaY = this.f_24976_ - this.f_24974_.m_20186_() + 0.5 - this.f_24974_.m_142469_().m_82376_() / 2.0;
            double deltaZ = this.f_24977_ - this.f_24974_.m_20189_();
            double delta = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            if (delta < 2.500000277905201E-7) {
                this.moveVertically(0.0f);
                this.moveHorizontally(0.0f);
                return;
            }
            float f = (float)(Mth.m_14136_((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f;
            float f1 = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
            if (this.lockToView) {
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 10.0f));
                double yawDegreeDifference = Mth.m_14145_((float)this.f_24974_.f_20885_, (float)f);
                if (yawDegreeDifference < 20.0) {
                    this.moveHorizontally((float)((double)f1 * (1.0 - yawDegreeDifference / 20.0)));
                }
            } else {
                this.moveHorizontally(f1);
            }
            double d4 = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                double pitchDegreeDifference;
                float f2 = (float)(-(Mth.m_14136_((double)deltaY, (double)d4) * 57.2957763671875));
                if (this.lockToView && (pitchDegreeDifference = (double)Mth.m_14145_((float)this.f_24974_.m_146909_(), (float)DEMath.getTargetPitch((Entity)this.f_24974_, this.f_24975_, this.f_24976_, this.f_24977_))) < 20.0) {
                    f1 = (float)((double)f1 * (1.0 - pitchDegreeDifference / 20.0));
                }
                this.moveVertically(deltaY > 0.0 ? (float)Math.min((double)f1, deltaY) : (float)Math.max((double)(-f1), deltaY));
            }
        }
    }

    private void moveHorizontally(float movementAmount) {
        this.advanceMotion.addMotion(DEMath.fromPitchYaw(0.0f, DEMath.getTargetYaw((Entity)this.f_24974_, this.f_24975_, this.f_24977_)).m_82490_((double)movementAmount * 0.07));
    }

    private void moveVertically(float movementAmount) {
        this.advanceMotion.addMotion(0.0, (double)movementAmount * 0.07, 0.0);
    }
}

