/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.containers.lazy_workstation.base;

import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRecipe;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.SolvedLazyRecipe;
import bottomtextdanny.dannys_expansion.content._client.screens.lazy_workstation.LazyCraftScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class LazyCraftMenu
extends AbstractContainerMenu {
    protected final Inventory playerInventory;
    protected LazyRecipe resultRecipe;
    protected final List<SolvedLazyRecipe> relevantRecipes = Lists.newLinkedList();
    protected final List<SolvedLazyRecipe> craftableRecipes = Lists.newLinkedList();
    protected final List<SolvedLazyRecipe> irrelevantRecipes = Lists.newLinkedList();

    protected LazyCraftMenu(@Nullable MenuType<? extends LazyCraftMenu> menu, Inventory playerInventory, int id) {
        super(menu, id);
        this.playerInventory = playerInventory;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.resultSlot() && super.m_5882_(stack, slotIn);
    }

    public void makeResultItemstack() {
        ItemStack stack = this.resultRecipe.getResult().m_41777_();
        this.resultSlot().m_5852_(stack);
        this.m_38946_();
    }

    public void consumeIngredients(LazyRecipe recipe) {
        List<LazyIngredient> ingredients = recipe.getIngredients();
        HashSet doneMap = Sets.newHashSet();
        for (ItemStack invStack : this.playerInventory.f_35974_) {
            for (LazyIngredient ingredient : ingredients) {
                if (doneMap.contains(ingredient) || !ingredient.iterationOnTake(this.playerInventory, invStack)) continue;
                doneMap.add(ingredient);
            }
        }
        for (LazyIngredient ingredient : ingredients) {
            ingredient.resetConsumeData();
        }
    }

    public void onInventoryChange() {
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
            if (index == 0) {
                playerIn.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    protected void onOutputDrawn(ItemStack stack) {
        this.playerInventory.m_6596_();
        Connection.doClientSide(() -> {
            Screen patt3897$temp = Minecraft.m_91087_().f_91080_;
            if (patt3897$temp instanceof LazyCraftScreen) {
                LazyCraftScreen lazyScreen = (LazyCraftScreen)patt3897$temp;
                lazyScreen.onOutputDrawn(stack);
            }
        });
    }

    public void setResultRecipe(LazyRecipe resultRecipe) {
        this.resultRecipe = resultRecipe;
    }

    public LazyRecipe getResultRecipe() {
        return this.resultRecipe;
    }

    public ItemStack bakeResult() {
        return this.resultRecipe.getResult().m_41777_();
    }

    public abstract Slot resultSlot();

    public List<SolvedLazyRecipe> getCraftableRecipes() {
        return this.craftableRecipes;
    }

    public List<SolvedLazyRecipe> getRelevantRecipes() {
        return this.relevantRecipes;
    }

    public List<SolvedLazyRecipe> getIrrelevantRecipes() {
        return this.irrelevantRecipes;
    }
}

