/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.containers.lazy_workstation.base;

import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.LazyRecipeType;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyCraftState;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientState;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRecipe;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.SolvedLazyRecipe;
import bottomtextdanny.dannys_expansion.content.containers.lazy_workstation.base.LazyCraftMenu;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DefaultLazyCraftMenu
extends LazyCraftMenu {
    private final Container resultInventory = new SimpleContainer(1);
    private final MenuType<? extends DefaultLazyCraftMenu> menu;
    private final LazyRecipeType recipeType;
    private final Slot resultInventorySlot;

    public DefaultLazyCraftMenu(int id, MenuType<? extends DefaultLazyCraftMenu> menu, LazyRecipeType type, Inventory playerInventoryIn) {
        super(menu, playerInventoryIn, id);
        this.menu = menu;
        this.recipeType = type;
        this.resultInventorySlot = this.m_38897_(new Slot(this.resultInventory, 0, 30, 29){

            public boolean m_6659_() {
                return this.m_6657_();
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                if (DefaultLazyCraftMenu.this.resultRecipe != null) {
                    DefaultLazyCraftMenu.this.consumeIngredients(DefaultLazyCraftMenu.this.resultRecipe);
                }
                DefaultLazyCraftMenu.this.onOutputDrawn(stack);
                DefaultLazyCraftMenu.this.m_38946_();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, j + i * 9 + 9, 40 + j * 18, 156 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)this.playerInventory, k, 40 + k * 18, 214));
        }
    }

    public ItemStack getItemStackResult() {
        return this.resultInventorySlot.m_7993_().m_41777_();
    }

    @Override
    public void onInventoryChange() {
        this.craftableRecipes.clear();
        this.relevantRecipes.clear();
        this.irrelevantRecipes.clear();
        List<LazyRecipe> wbRecipes = DannysExpansion.common().getLazyRecipeManager().getRecipes(this.recipeType);
        for (LazyRecipe recipe : wbRecipes) {
            boolean recipeIsCraftable = true;
            boolean atLeastOneItemMatches = false;
            for (ItemStack iterationItem : this.playerInventory.f_35974_) {
                for (LazyIngredient ingredient : recipe.getIngredients()) {
                    ingredient.collectResources(iterationItem);
                }
            }
            for (LazyIngredient ingredient : recipe.getIngredients()) {
                LazyIngredientState state = ingredient.resetCollectionData();
                if (state == LazyIngredientState.NO_MATCH) {
                    recipeIsCraftable = false;
                    continue;
                }
                if (state == LazyIngredientState.UNFULFILLED_MATCH) {
                    recipeIsCraftable = false;
                    atLeastOneItemMatches = true;
                    continue;
                }
                atLeastOneItemMatches = true;
            }
            if (recipeIsCraftable) {
                this.craftableRecipes.add(SolvedLazyRecipe.of(recipe, LazyCraftState.CRAFTABLE));
                continue;
            }
            if (atLeastOneItemMatches) {
                this.relevantRecipes.add(SolvedLazyRecipe.of(recipe, LazyCraftState.RELEVANT));
                continue;
            }
            this.irrelevantRecipes.add(SolvedLazyRecipe.of(recipe, LazyCraftState.IRRELEVANT));
        }
    }

    public MenuType<?> m_6772_() {
        return this.menu;
    }

    public LazyRecipeType getRecipeType() {
        return this.recipeType;
    }

    @Override
    public Slot resultSlot() {
        return this.resultInventorySlot;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }
}

