/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.accessories;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod.capability.level.speck.ShootLighSpeck;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryKey;
import bottomtextdanny.braincell.mod.capability.player.accessory.IJumpQueuerAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.IQueuedJump;
import bottomtextdanny.braincell.mod.capability.player.accessory.JumpPriority;
import bottomtextdanny.braincell.mod.capability.player.accessory.QueuedJump;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.SimplePointLight;
import bottomtextdanny.braincell.mod.network.BCPacketInitialization;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleType;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion.content.accessories.CoreAccessory;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EbbewelAccessory
extends CoreAccessory
implements IJumpQueuerAccessory {
    private final IQueuedJump ebbewelImpulses = new QueuedJump((IJumpQueuerAccessory)this, JumpPriority.LARGE);
    private byte impulsesUsed = (byte)3;
    private final IntScheduler cooldown = IntScheduler.simple((int)60);

    public EbbewelAccessory(AccessoryKey<?> key, Player player) {
        super(key, player);
    }

    @Override
    public void prepare(int index) {
        super.prepare(index);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.impulsesUsed > 0 && this.player.f_19853_.m_6425_(new BlockPos(this.player.m_20185_(), (double)Mth.m_14107_((double)this.player.m_20188_()), this.player.m_20189_())).m_76178_()) {
            this.cooldown.incrementFreely(1);
            if (this.cooldown.hasEnded()) {
                this.cooldown.reset();
                this.impulsesUsed = 0;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void accessoryClientManager(int flag, ObjectFetcher fetcher) {
        super.accessoryClientManager(flag, fetcher);
        if (flag == 0) {
            float zRandom;
            float yRandom;
            float xRandom;
            int i;
            Vec3 vec0 = DEMath.fromPitchYaw(this.player.m_146909_(), this.player.f_20885_).m_82542_(0.1, 0.1, 0.1);
            for (i = 0; i < 8; ++i) {
                xRandom = (float)this.random.nextGaussian() * 0.5f;
                yRandom = (float)this.random.nextGaussian() * 0.5f;
                zRandom = (float)this.random.nextGaussian() * 0.5f;
                this.player.f_19853_.m_7106_((ParticleOptions)DEParticles.EBBEWEL_SPARK.get(), this.player.m_20185_() + (double)xRandom, this.player.m_20186_() + (double)yRandom, this.player.m_20189_() + (double)zRandom, -vec0.f_82479_, -vec0.f_82480_, -vec0.f_82481_);
            }
            for (i = 0; i < 5; ++i) {
                xRandom = (float)this.random.nextGaussian() * 0.4f;
                yRandom = (float)this.random.nextGaussian() * 0.4f;
                zRandom = (float)this.random.nextGaussian() * 0.4f;
                this.player.f_19853_.m_7106_((ParticleOptions)DEParticles.EBBEWEL_CLOUD.get(), this.player.m_20185_() + (double)xRandom, this.player.m_20186_() + (double)yRandom, this.player.m_20189_() + (double)zRandom, -vec0.f_82479_ * 0.6, -vec0.f_82480_ * 0.6, -vec0.f_82481_ * 0.6);
            }
            this.player.f_19853_.m_7106_((ParticleOptions)new DannyParticleData((Supplier<DannyParticleType>)DEParticles.EBBEWEL_RING, Float.valueOf(this.player.m_146908_()), Float.valueOf(this.player.m_146909_())), this.player.m_20185_(), this.player.m_20186_() + this.player.m_142469_().m_82376_() / 2.0, this.player.m_20189_(), -vec0.f_82479_ * 0.1, -vec0.f_82480_ * 0.1, -vec0.f_82481_ * 0.1);
            ShootLighSpeck light = new ShootLighSpeck(this.player.f_19853_, 2, 1, 20);
            light.setPosition(this.player.m_20182_());
            light.setLight((IPointLight)new SimplePointLight(new Vec3(0.0, 0.8, 1.0), 4.0f, 2.3f, 1.6f));
            light.addToLevel();
        }
    }

    public boolean canPerformJump(IQueuedJump jumpType) {
        return this.player.m_6067_() && this.impulsesUsed < 3;
    }

    public void performJump(IQueuedJump jumpType) {
        Vec3 vec0 = DEMath.fromPitchYaw(this.player.m_146909_(), this.player.f_20885_);
        this.player.m_5997_(vec0.f_82479_, vec0.f_82480_, vec0.f_82481_);
        BCPacketInitialization.sendPlayerVelocityPacket((Entity)this.player);
        this.player.f_19853_.m_6263_(null, this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), (SoundEvent)DESounds.IS_EBBEWEL_IMPULSE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + new Random().nextFloat() * 0.1f);
        this.triggerClientActionToTracking(0);
        this.impulsesUsed = (byte)(this.impulsesUsed + 1);
    }

    public IQueuedJump[] provideJumps() {
        return new IQueuedJump[]{this.ebbewelImpulses};
    }

    @Override
    public String getGeneratedDescription() {
        return "Provides the holder with 3 small impulses when swimming, when the holder uses at least one impulse they can wait 3 seconds out of water to recharge them fully";
    }
}

