/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.accessories;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryKey;
import bottomtextdanny.braincell.mod.capability.player.accessory.AttributeModifierAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.IAccessory;
import bottomtextdanny.braincell.mod.capability.player.accessory.MiniAttribute;
import bottomtextdanny.braincell.mod.capability.player.accessory.ModifierType;
import bottomtextdanny.dannys_expansion._base.network.clienttoserver.MSGAccessoryServerManager;
import bottomtextdanny.dannys_expansion._base.network.servertoclient.MSGCoreAccessoryClientManager;
import bottomtextdanny.dannys_expansion._util.DescriptionUtil;
import bottomtextdanny.dannys_expansion.tables.DEAccessoryKeys;
import bottomtextdanny.dannys_expansion.tables.DEMiniAttributes;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.PacketDistributor;

public class CoreAccessory
implements IAccessory,
AttributeModifierAccessory {
    public static final CoreAccessory EMPTY = new CoreAccessory(DEAccessoryKeys.CORE_EMPTY, null);
    @OnlyIn(value=Dist.CLIENT)
    public static final String ATTACK_DAMAGE_ADD_DESC = "description.dannys_expansion.accessory_base.melee_damage_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ATTACK_KNOCKBACK_ADD_DESC = "description.dannys_expansion.accessory_base.melee_knockback_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ATTACK_SPEED_ADD_DESC = "description.dannys_expansion.accessory_base.melee_speed_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String GUN_ACCURACY_DESC = "description.dannys_expansion.accessory_base.gun_accuracy_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String GUN_CADENCE_DESC = "description.dannys_expansion.accessory_base.gun_cadence_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String GUN_DAMAGE_ADD_DESC = "description.dannys_expansion.accessory_base.gun_damage_add_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String GUN_DAMAGE_MLT_DESC = "description.dannys_expansion.accessory_base.gun_damage_mlt_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ARCHERY_SPEED_DESC = "description.dannys_expansion.accessory_base.archery_speed_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ARCHERY_DAMAGE_ADD_DESC = "description.dannys_expansion.accessory_base.archery_damage_add_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ARCHERY_DAMAGE_MLT_DESC = "description.dannys_expansion.accessory_base.archery_damage_mlt_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String BULLET_SPEED_MLT_DESC = "description.dannys_expansion.accessory_base.bullet_speed_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ARROW_SPEED_MLT_DESC = "description.dannys_expansion.accessory_base.arrow_speed_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String MOVEMENT_SPEED_MLT_DESC = "description.dannys_expansion.accessory_base.movement_speed_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ARMOR_ADD_DESC = "description.dannys_expansion.accessory_base.armor_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String LUCK_ADD_DESC = "description.dannys_expansion.accessory_base.luck_modifier";
    @OnlyIn(value=Dist.CLIENT)
    public static final String ATTRIBUTE_MODIFIER_KEY = "@mod<";
    private final AccessoryKey<?> key;
    protected Player player;
    public int index;
    protected Random random = new Random();

    public CoreAccessory(AccessoryKey<?> key, Player player) {
        this.key = key;
        this.player = player;
    }

    public void prepare(int index) {
        this.index = index;
    }

    public void populateModifierData(List<Pair<ModifierType, Double>> modifierList, List<Pair<MiniAttribute, Float>> lesserModifierList) {
    }

    public void tick() {
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (FMLLoader.getDist() == Dist.CLIENT && Braincell.common().hasPassedInitialization()) {
            String[] description;
            if (this.isModifierActive(ModifierType.ATTACK_DAMAGE_ADD)) {
                this.createModifierTooltip(tooltip, ATTACK_DAMAGE_ADD_DESC, this.getModifierBase(ModifierType.ATTACK_DAMAGE_ADD));
            }
            if (this.isModifierActive(ModifierType.ATTACK_KNOCKBACK_ADD)) {
                this.createModifierTooltip(tooltip, ATTACK_KNOCKBACK_ADD_DESC, this.getModifierBase(ModifierType.ATTACK_KNOCKBACK_ADD));
            }
            if (this.isModifierActive(ModifierType.ATTACK_SPEED_ADD)) {
                this.createModifierTooltip(tooltip, ATTACK_SPEED_ADD_DESC, this.getModifierBase(ModifierType.ATTACK_SPEED_ADD));
            }
            if (this.isLesserModifierActive(DEMiniAttributes.GUN_ACCURACY)) {
                this.createModifierTooltip(tooltip, GUN_ACCURACY_DESC, this.getLesserModifierBase(DEMiniAttributes.GUN_ACCURACY));
            }
            if (this.isLesserModifierActive(DEMiniAttributes.GUN_CADENCE)) {
                this.createModifierTooltip(tooltip, GUN_CADENCE_DESC, this.getLesserModifierBase(DEMiniAttributes.GUN_CADENCE));
            }
            if (this.isLesserModifierActive(DEMiniAttributes.GUN_DAMAGE_ADD)) {
                this.createModifierTooltip(tooltip, GUN_DAMAGE_ADD_DESC, this.getLesserModifierBase(DEMiniAttributes.GUN_DAMAGE_ADD));
            }
            if (this.isLesserModifierActive(DEMiniAttributes.GUN_DAMAGE_MLT)) {
                this.createModifierTooltip(tooltip, GUN_DAMAGE_MLT_DESC, this.getLesserModifierBase(DEMiniAttributes.GUN_DAMAGE_MLT));
            }
            if (this.isLesserModifierActive(MiniAttribute.ARCHERY_SPEED)) {
                this.createModifierTooltip(tooltip, ARCHERY_SPEED_DESC, this.getLesserModifierBase(MiniAttribute.ARCHERY_SPEED));
            }
            if (this.isLesserModifierActive(MiniAttribute.ARCHERY_DAMAGE_ADD)) {
                this.createModifierTooltip(tooltip, ARCHERY_DAMAGE_ADD_DESC, this.getLesserModifierBase(MiniAttribute.ARCHERY_DAMAGE_ADD));
            }
            if (this.isLesserModifierActive(MiniAttribute.ARCHERY_DAMAGE_MLT)) {
                this.createModifierTooltip(tooltip, ARCHERY_DAMAGE_MLT_DESC, this.getLesserModifierBase(MiniAttribute.ARCHERY_DAMAGE_MLT));
            }
            if (this.isLesserModifierActive(DEMiniAttributes.BULLET_SPEED_MLT)) {
                this.createModifierTooltip(tooltip, BULLET_SPEED_MLT_DESC, this.getLesserModifierBase(DEMiniAttributes.BULLET_SPEED_MLT));
            }
            if (this.isLesserModifierActive(MiniAttribute.ARROW_SPEED_MLT)) {
                this.createModifierTooltip(tooltip, ARROW_SPEED_MLT_DESC, this.getLesserModifierBase(MiniAttribute.ARROW_SPEED_MLT));
            }
            if (this.isModifierActive(ModifierType.MOVEMENT_SPEED_MLT)) {
                this.createModifierTooltip(tooltip, MOVEMENT_SPEED_MLT_DESC, this.getModifierBase(ModifierType.MOVEMENT_SPEED_MLT));
            }
            if (this.isModifierActive(ModifierType.ARMOR_ADD)) {
                this.createModifierTooltip(tooltip, ARMOR_ADD_DESC, this.getModifierBase(ModifierType.ARMOR_ADD));
            }
            if (this.isModifierActive(ModifierType.LUCK_ADD)) {
                this.createModifierTooltip(tooltip, LUCK_ADD_DESC, this.getModifierBase(ModifierType.LUCK_ADD));
            }
            tooltip.add(TextComponent.f_131282_);
            String descriptionRaw = new TranslatableComponent("description.dannys_expansion.accessory." + this.key.getLocation().m_135815_()).getString();
            for (String s : description = DescriptionUtil.getDividedDescription(descriptionRaw)) {
                tooltip.add((Component)new TextComponent(s).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createModifierTooltip(List<Component> tooltip, String translationKey, double value) {
        boolean positive = false;
        String attributeDesc = new TranslatableComponent(translationKey).getString();
        Object attributeValue = String.valueOf(value);
        if (value > 0.0) {
            attributeValue = "+" + (String)attributeValue;
            positive = true;
        }
        attributeDesc = attributeDesc.replaceAll(ATTRIBUTE_MODIFIER_KEY, (String)attributeValue);
        tooltip.add((Component)new TextComponent(attributeDesc).m_130940_(positive ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getGeneratedDescription() {
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void keyHandler(Options settings) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void frameTick(LocalPlayer cPlayer, PoseStack poseStack, float partialTicks) {
    }

    public int getIndex() {
        return this.index;
    }

    public AccessoryKey<?> getKey() {
        return this.key;
    }

    public void read(CompoundTag nbt) {
    }

    public CompoundTag write() {
        return new CompoundTag();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void accessoryClientManager(int flag, ObjectFetcher fetcher) {
    }

    public void accessoryServerManager(int flag, ObjectFetcher fetcher) {
    }

    public void triggerClientAction(int flag, PacketDistributor.PacketTarget target, WorldPacketData<?> ... data) {
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new MSGCoreAccessoryClientManager(this.player.m_142049_(), this.index, flag, data, serverLevel).sendTo(target);
        }
    }

    public void triggerClientActionToTracking(int flag, WorldPacketData<?> ... data) {
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new MSGCoreAccessoryClientManager(this.player.m_142049_(), this.index, flag, data, serverLevel).sendTo(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.player));
        }
    }

    public void triggerClientActionSpecific(int flag, ServerPlayer player, WorldPacketData<?> ... data) {
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new MSGCoreAccessoryClientManager(player.m_142049_(), this.index, flag, data, serverLevel).sendTo(PacketDistributor.PLAYER.with(() -> player));
        }
    }

    public void triggerClientActionToTracking(int flag) {
        this.triggerClientActionToTracking(flag, new WorldPacketData[]{null});
    }

    public void triggerServerAction(int flag, WorldPacketData<?> ... data) {
        if (this.player.f_19853_.m_5776_()) {
            new MSGAccessoryServerManager(this.player.m_142049_(), this.index, flag, data).sendToServer();
        }
    }

    public void triggerServerAction(int flag) {
        this.triggerServerAction(flag, new WorldPacketData[]{null});
    }
}

