/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.accessories;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryKey;
import bottomtextdanny.braincell.mod.capability.player.accessory.MiniAttribute;
import bottomtextdanny.braincell.mod.capability.player.accessory.ModifierType;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.FinnFall;
import bottomtextdanny.braincell.mod.capability.player.accessory.extensions.FinnHurt;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleType;
import bottomtextdanny.dannys_expansion.content.accessories.CoreAccessory;
import bottomtextdanny.dannys_expansion.content.entities.projectile.SpellEntity;
import bottomtextdanny.dannys_expansion.content.entities.projectile.SquigBubbleEntity;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Options;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class BurbleAccessory
extends CoreAccessory
implements FinnFall,
FinnHurt {
    private IntScheduler bubbleCooldown;
    private boolean spacing;

    public BurbleAccessory(AccessoryKey<?> key, Player player) {
        super(key, player);
    }

    @Override
    public void prepare(int index) {
        super.prepare(index);
        this.bubbleCooldown = IntScheduler.simple((int)80);
    }

    @Override
    public void populateModifierData(List<Pair<ModifierType, Double>> modifierList, List<Pair<MiniAttribute, Float>> lesserModifierList) {
    }

    @Override
    public void tick() {
        super.tick();
        this.bubbleCooldown.incrementFreely(1);
        if (this.player.m_6144_() && this.spacing) {
            if (!this.player.f_19853_.m_5776_()) {
                this.player.f_19789_ = 0.0f;
            } else {
                if (this.player.m_20184_().f_82480_ < 0.0) {
                    this.player.m_20256_(this.player.m_20184_().m_82542_(1.0, 0.5, 1.0));
                }
                if (this.random.nextInt(6) == 2) {
                    Connection.doClientSide(() -> this.randomParticleTick());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void randomParticleTick() {
        double d0 = this.random.nextGaussian() * (this.player.m_142469_().m_82362_() + 0.15) / 2.0 + this.player.m_20185_();
        double d1 = (double)this.random.nextFloat() * this.player.m_142469_().m_82376_() + 0.1 + this.player.m_20186_();
        double d2 = this.random.nextGaussian() * (this.player.m_142469_().m_82362_() + 0.15) / 2.0 + this.player.m_20189_();
        this.player.f_19853_.m_7785_(d0, d1, d2, (SoundEvent)DESounds.ES_SQUIG_BUBBLE_GENERATE.get(), SoundSource.PLAYERS, 0.1f, 2.6f + 0.1f * (float)this.random.nextInt(3), false);
        this.player.f_19853_.m_7106_((ParticleOptions)new DannyParticleData((Supplier<DannyParticleType>)DEParticles.SQUIG_BUBBLE), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void onHurt(DamageSource source, MutableObject<Float> amount) {
        if (this.bubbleCooldown.hasEnded() && source.m_7639_() instanceof LivingEntity && source.m_7639_() != this.player) {
            LivingEntity living = (LivingEntity)source.m_7639_();
            Vec3 pos = this.player.m_20182_();
            SquigBubbleEntity bubble = new SquigBubbleEntity((EntityType<? extends SpellEntity>)((EntityType)DEEntities.SQUIG_BUBBLE.get()), this.player.f_19853_);
            bubble.setCaster((LivingEntity)this.player);
            bubble.setBobbleDamage(2.0f + this.random.nextFloat() * 0.5f);
            bubble.setTarget(living);
            bubble.m_19890_(pos.f_82479_, this.player.m_20188_(), pos.f_82481_, 0.0f, 0.0f);
            this.player.f_19853_.m_7967_((Entity)bubble);
            this.bubbleCooldown.reset();
        }
    }

    @Override
    public void accessoryServerManager(int flag, ObjectFetcher objectFetcher) {
        Object object;
        super.accessoryServerManager(flag, objectFetcher);
        if (flag == 0 && (object = objectFetcher.get(0)) instanceof Boolean) {
            Boolean bool = (Boolean)object;
            this.spacing = bool;
        }
    }

    @Override
    public void keyHandler(Options settings) {
        boolean jumping;
        super.keyHandler(settings);
        this.spacing = jumping = DannysExpansion.client().getKeybindHandler().keyBindJump.onHoldingAction();
        this.triggerServerAction(0, WorldPacketData.of((SerializerMark)BuiltinSerializers.BOOLEAN, (Object)jumping));
    }

    public double getFinalSpeedMultiplier() {
        return this.player.m_6144_() && this.spacing ? super.getFinalSpeedMultiplier() + 10.5 : super.getFinalSpeedMultiplier();
    }

    public double getFinalAttackDamageAddition() {
        return super.getFinalAttackDamageAddition() + 4.0;
    }

    public void fallDamageMultModifier(float baseDistance, MutableFloat fallDamage, MutableFloat fallDistance) {
        if (this.player.m_6144_() && this.spacing) {
            fallDistance.setValue(0.0f);
        }
    }

    public int fallModificationPriority() {
        return 200;
    }

    @Override
    public String getGeneratedDescription() {
        return "generates a homing bubble when you get hit by any entity.";
    }
}

