/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.screens.lazy_workstation;

import bottomtextdanny.braincell.base.screen.ImageBounds;
import bottomtextdanny.braincell.base.screen.ImageData;
import bottomtextdanny.braincell.mod._base.blitty.Blitty;
import bottomtextdanny.braincell.mod.gui.EditableText;
import bottomtextdanny.braincell.mod.screen.BlittyStepDown;
import bottomtextdanny.braincell.mod.screen.PlayableSprite;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.LazyRecipeManager;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyCraftState;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRecipe;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.SolvedLazyRecipe;
import bottomtextdanny.dannys_expansion._base.network.clienttoserver.MSGSetLazyCraftResult;
import bottomtextdanny.dannys_expansion._base.network.clienttoserver.MSGUpdateLazyCraftInventory;
import bottomtextdanny.dannys_expansion._util._client.RenderUtils;
import bottomtextdanny.dannys_expansion.content._client.screens.lazy_workstation.LazyCraftScreen;
import bottomtextdanny.dannys_expansion.content.containers.lazy_workstation.base.DefaultLazyCraftMenu;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class DefaultLazyCraftScreen<E extends DefaultLazyCraftMenu>
extends LazyCraftScreen<E> {
    private static final int INGREDIENT_DISPLAY_WIDTH = 100;
    private static final int FILTER_X = 195;
    private static final int FILTER_Y = 14;
    private static final int SLIDER_START_X = 222;
    private static final int SLIDER_START_Y = 67;
    private static final int SLIDER_END_X = 229;
    private static final int SLIDER_END_Y = 138;
    private static final int SLIDER_Y_LENGTH = 71;
    private static final ImageData SCREEN_IMAGE = new ImageData("dannys_expansion", "blank.png", 512, 512);
    private static final Blitty GUI = new Blitty((ImageBounds)SCREEN_IMAGE, 0, 0, 240, 238);
    private static final Blitty[] RECIPES = new Blitty[]{new Blitty((ImageBounds)SCREEN_IMAGE, 429, 1, 18, 18), new Blitty((ImageBounds)SCREEN_IMAGE, 429, 20, 18, 18), new Blitty((ImageBounds)SCREEN_IMAGE, 429, 39, 18, 18)};
    private static final Blitty RECIPE_SELECTED = new Blitty((ImageBounds)SCREEN_IMAGE, 429, 58, 18, 18);
    private static final Blitty[] RECIPE_SLIDERS = new Blitty[]{new Blitty((ImageBounds)SCREEN_IMAGE, 473, 1, 7, 6), new Blitty((ImageBounds)SCREEN_IMAGE, 473, 8, 7, 6)};
    private static final Blitty[] FILTERS = new Blitty[]{new Blitty((ImageBounds)SCREEN_IMAGE, 481, 1, 30, 30), new Blitty((ImageBounds)SCREEN_IMAGE, 481, 32, 30, 30)};
    private static final Blitty[] INGREDIENT_BUTTONS = new Blitty[]{new Blitty((ImageBounds)SCREEN_IMAGE, 421, 1, 7, 5), new Blitty((ImageBounds)SCREEN_IMAGE, 421, 7, 7, 5), new Blitty((ImageBounds)SCREEN_IMAGE, 421, 13, 7, 5), new Blitty((ImageBounds)SCREEN_IMAGE, 421, 19, 7, 5), new Blitty((ImageBounds)SCREEN_IMAGE, 421, 25, 7, 5), new Blitty((ImageBounds)SCREEN_IMAGE, 421, 31, 7, 5)};
    private static final TranslatableComponent SEARCH_BAR_TITLE = new TranslatableComponent("container.lazy_workstation.search_bar");
    public static final TranslatableComponent FILTER_TITLE = new TranslatableComponent("container.lazy_workstation.filter");
    private static final BlittyStepDown CUTE_HAMMER_STREAM = new BlittyStepDown(SCREEN_IMAGE, 448, 1, 24, 16);
    private final PlayableSprite hammerAnimation;
    private final ImageData image;
    public final TranslatableComponent name;
    private EditableText searchBar;
    private int searchBarColor;
    private float sliderAdvance;
    private boolean sliderGrip;
    private DisplayedRecipe selectedRecipe;
    private Item filter;

    public DefaultLazyCraftScreen(E screenContainer, TranslatableComponent name, ImageData image, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.image = image;
        this.hammerAnimation = new PlayableSprite(CUTE_HAMMER_STREAM, 14, 4);
        this.name = name;
        this.f_97726_ = 240;
        this.f_97727_ = 238;
        this.selectedRecipe = new DisplayedRecipe(LazyRecipe.EMPTY, LazyCraftState.IRRELEVANT);
        this.filter = Items.f_41852_;
        this.f_97735_ = this.f_96543_ / 2 - 120;
        this.f_97736_ = this.f_96544_ / 2 - 119;
        this.searchBarColor = -1;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBar = new EditableText(this.f_96547_, this.f_97735_ + 21, this.f_97736_ + 67, 198, (Component)SEARCH_BAR_TITLE){

            public boolean shouldBeDeselected(int x, int y) {
                return !this.inbounds(x, y);
            }
        };
        this.searchBar.setColorProcessor(str -> this.searchBarColor);
        this.searchBar.onTextModification(str -> {
            this.searchBarColor = this.processButtons();
            this.searchBar.updateColor();
        });
        this.m_142416_((GuiEventListener)this.searchBar);
        this.processButtons();
    }

    public int processButtons() {
        String searchFilter = this.searchBar.getCurrentText();
        List<Object> allRecipes = Lists.newArrayList(((DefaultLazyCraftMenu)this.f_97732_).getCraftableRecipes());
        allRecipes.addAll(((DefaultLazyCraftMenu)this.f_97732_).getRelevantRecipes());
        allRecipes.addAll(((DefaultLazyCraftMenu)this.f_97732_).getIrrelevantRecipes());
        LazyRecipe selectedRecipeO = this.selectedRecipe.getRecipe();
        this.selectedRecipe = new DisplayedRecipe(LazyRecipe.EMPTY, LazyCraftState.IRRELEVANT);
        if (this.filter != Items.f_41852_) {
            allRecipes = allRecipes.stream().filter(p -> {
                LazyRecipe recipe = p.recipe();
                boolean filtering = recipe.getIngredients().stream().anyMatch(objIngredient -> objIngredient.filter(this.filter));
                return filtering;
            }).toList();
        }
        boolean emptySearch = false;
        allRecipes.forEach(p -> {
            LazyRecipe recipe = p.recipe();
            if (recipe.getIndex() == selectedRecipeO.getIndex()) {
                this.selectedRecipe = new DisplayedRecipe(recipe, p.state());
            }
        });
        if (!searchFilter.isEmpty()) {
            emptySearch = allRecipes.isEmpty();
            List<Object> o = allRecipes;
            if ((allRecipes = allRecipes.stream().filter(p -> {
                ItemStack result = p.recipe().getResult();
                return result.m_41720_().getRegistryName().m_135815_().toString().contains(searchFilter) || result.m_41720_().m_7626_(result).getString().contains(searchFilter);
            }).toList()).isEmpty()) {
                emptySearch = true;
                allRecipes = o;
            }
        }
        int startColumnRender = (int)(this.sliderAdvance / (float)allRecipes.size() / 11.0f);
        List<Object> renderedRecipes = allRecipes.subList(Math.max(0, startColumnRender * 11), Math.min(startColumnRender * 11 + 33, allRecipes.size()));
        int xOffset = 0;
        int yOffset = 1;
        int counter = 0;
        this.m_6702_().clear();
        this.f_169369_.clear();
        for (SolvedLazyRecipe solvedLazyRecipe : renderedRecipes) {
            while (yOffset * 10 < xOffset) {
                ++yOffset;
                xOffset -= 11;
            }
            RecipeButton button = new RecipeButton(this.f_97735_ + 21 + counter % 11 * 18, this.f_97736_ + 83 + counter / 11 * 18, solvedLazyRecipe);
            this.m_142416_((GuiEventListener)button);
            ++xOffset;
            ++counter;
        }
        if (this.selectedRecipe.getRecipe().getIngredients() != null) {
            for (LazyIngredient ingredient : this.selectedRecipe.getRecipe().getIngredients()) {
                ingredient.onScreenModification(this.inventory);
            }
        }
        if (searchFilter.isEmpty()) {
            return -1;
        }
        return allRecipes.isEmpty() || emptySearch ? -12237424 : -14614784;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        this.m_7333_(poseStack);
        int widthFromCenter = this.f_96543_ / 2;
        int heightFromCenter = this.f_96544_ / 2;
        this.image.use();
        GUI.render(poseStack, (float)(widthFromCenter - 120), (float)(heightFromCenter - 119), 0.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        this.hammerAnimation.render(poseStack, (float)(widthFromCenter + 82), (float)(heightFromCenter + 96), 0.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.filter != Items.f_41852_) {
            FILTERS[0].render(poseStack, (float)(widthFromCenter + 75), (float)(heightFromCenter + -105), 0.0f);
            RenderUtils.renderItemModelIntoGUI(poseStack, this.filter.m_7968_(), widthFromCenter + 82, heightFromCenter - 98, 255);
        } else {
            FILTERS[1].render(poseStack, (float)(widthFromCenter + 75), (float)(heightFromCenter + -105), 0.0f);
        }
        float sliderYOffset = 65.0f * this.sliderAdvance;
        RECIPE_SLIDERS[0].render(poseStack, (float)(this.f_97735_ + 222), (float)(this.f_97736_ + 67) + sliderYOffset, 1.0f);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        TooltipFlag.Default tooltipFlag = Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        LocalPlayer player = this.f_96541_.f_91074_;
        this.renderNames(poseStack);
        if (this.selectedRecipe.getRecipe() != LazyRecipe.EMPTY) {
            int x = this.f_96543_ / 2 - 66;
            int y = this.f_96544_ / 2 - 94;
            this.renderIngredientsForRecipe(poseStack, mouseX, mouseY, (TooltipFlag)tooltipFlag, x, y);
            this.renderSelectedRecipe(poseStack, mouseX, mouseY, (TooltipFlag)tooltipFlag);
        }
        if (this.selectedRecipe.shouldRenderButtons()) {
            this.renderIngredientButtons(poseStack, mouseX, mouseY);
        }
        if (this.getSlotUnderMouse() != null && this.getSlotUnderMouse().m_7993_() != ItemStack.f_41583_) {
            this.m_96597_(poseStack, this.getSlotUnderMouse().m_7993_().m_41651_((Player)player, (TooltipFlag)tooltipFlag), mouseX, mouseY);
        }
        for (Widget button : this.f_169369_) {
            AbstractWidget widget;
            if (!(button instanceof AbstractWidget) || !(widget = (AbstractWidget)button).m_5953_((double)mouseX, (double)mouseY)) continue;
            widget.m_7428_(poseStack, mouseX, mouseY);
        }
        if (this.isMouseOverFilter(mouseX, mouseY) && this.filter != Items.f_41852_) {
            this.m_96597_(poseStack, this.filter.m_7968_().m_41651_((Player)player, (TooltipFlag)tooltipFlag), mouseX, mouseY);
        }
    }

    private void renderIngredientButtons(PoseStack poseStack, int mouseX, int mouseY) {
        int widthFromCenter = this.f_96543_ / 2;
        int heightFromCenter = this.f_96544_ / 2;
        this.image.use();
        int upIndex = 0;
        int downIndex = 3;
        if (this.selectedRecipe.canGoUp()) {
            if (this.isMouseOver(mouseX, mouseY, widthFromCenter + 70, heightFromCenter - 90, 7, 5)) {
                ++upIndex;
            }
        } else {
            upIndex += 2;
        }
        if (this.selectedRecipe.canGoDown()) {
            downIndex = this.isMouseOver(mouseX, mouseY, widthFromCenter + 70, heightFromCenter - 83, 7, 5) ? ++downIndex : (downIndex += 2);
        }
        INGREDIENT_BUTTONS[upIndex].render(poseStack, (float)(widthFromCenter + 70), (float)(heightFromCenter - 90), 0.0f);
        INGREDIENT_BUTTONS[downIndex].render(poseStack, (float)(widthFromCenter + 70), (float)(heightFromCenter - 83), 0.0f);
    }

    @Override
    public void onOutputDrawn(ItemStack drawnItemStack) {
        if (drawnItemStack != ItemStack.f_41583_) {
            this.hammerAnimation.reset();
        }
    }

    private void renderSelectedRecipe(PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        if (this.selectedRecipe.getState() != LazyCraftState.CRAFTABLE) {
            RenderUtils.renderItemModelIntoGUI(poseStack, this.selectedRecipe.getRecipe().getResult(), this.f_96543_ / 2 - 90, this.f_96544_ / 2 - 90, 128);
            RenderUtils.renderItemOverlayIntoGUI(this.f_96547_, this.selectedRecipe.getRecipe().getResult(), this.f_96543_ / 2 - 90, this.f_96544_ / 2 - 90, null, 0x808080, 0);
            if (this.isMouseOver(mouseX, mouseY, this.f_96543_ / 2 - 90, this.f_96544_ / 2 - 90, 16, 16)) {
                this.m_96597_(poseStack, this.selectedRecipe.getRecipe().getResult().m_41651_((Player)this.f_96541_.f_91074_, tooltipFlag), mouseX, mouseY);
            }
        }
    }

    private void renderIngredientsForRecipe(PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag, int x, int y) {
        for (XSpacedIngredient displayed : this.selectedRecipe.getLineIngredientsRenderCache()) {
            String countText = displayed.ingredient.getCountDisplay();
            ItemStack stack = new ItemStack((ItemLike)displayed.ingredient.screenItem());
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            Minecraft.m_91087_().m_91291_().m_115123_(stack, x + displayed.xPos, y);
            this.f_96547_.m_92811_(countText, (float)(x + displayed.xPos + 8 - displayed.textWidthOffset), (float)(y + 16), displayed.ingredient.getCountDisplayColor(), true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
            buffer.m_109911_();
            if (!this.isMouseOver(mouseX, mouseY, x + displayed.xPos, y, 16, 16)) continue;
            this.m_96597_(poseStack, displayed.ingredient.tooltip(tooltipFlag), mouseX, mouseY);
        }
    }

    private void renderNames(PoseStack poseStack) {
        String filterStr = FILTER_TITLE.getString();
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int halfWidth = this.f_96543_ / 2;
        int halfHeight = this.f_96544_ / 2;
        this.f_96547_.m_92841_(this.inventory.m_5446_(), (float)(halfWidth - 80), (float)(halfHeight + 24), 0x404040, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
        this.f_96547_.m_92811_(this.name.getString(), (float)(halfWidth - 104), (float)(halfHeight - 110), 0x404040, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
        this.f_96547_.m_92811_(filterStr, (float)(halfWidth + 91 - this.f_96547_.m_92895_(filterStr) / 2), (float)(halfHeight - 109), this.filter == Items.f_41852_ ? 0x404040 : 0xFFFF80, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
        renderTypeBuffer.m_109911_();
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.timesInventoryChanged != this.inventory.m_36072_()) {
            new MSGUpdateLazyCraftInventory().sendToServer();
            ((DefaultLazyCraftMenu)this.f_97732_).onInventoryChange();
            this.processButtons();
        }
        if (this.timesInventoryChanged != this.inventory.m_36072_() || this.selectedRecipe.getRecipe() != ((DefaultLazyCraftMenu)this.f_97732_).getResultRecipe()) {
            LazyRecipeManager recipeManager = DannysExpansion.common().getLazyRecipeManager();
            if (this.selectedRecipe.getState() == LazyCraftState.CRAFTABLE) {
                new MSGSetLazyCraftResult(recipeManager.getTypeId(((DefaultLazyCraftMenu)this.f_97732_).getRecipeType()), this.selectedRecipe.getRecipe().getIndex()).sendToServer();
                ((DefaultLazyCraftMenu)this.f_97732_).setResultRecipe(this.selectedRecipe.getRecipe());
                ((DefaultLazyCraftMenu)this.f_97732_).makeResultItemstack();
            } else if (((DefaultLazyCraftMenu)this.f_97732_).getResultRecipe() != LazyRecipe.EMPTY) {
                new MSGSetLazyCraftResult(recipeManager.getTypeId(((DefaultLazyCraftMenu)this.f_97732_).getRecipeType()), LazyRecipe.EMPTY.getIndex()).sendToServer();
                ((DefaultLazyCraftMenu)this.f_97732_).setResultRecipe(LazyRecipe.EMPTY);
                ((DefaultLazyCraftMenu)this.f_97732_).makeResultItemstack();
            }
        }
        this.timesInventoryChanged = this.inventory.m_36072_();
    }

    public boolean isMouseOver(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public boolean isMouseOverFilter(double mouseX, double mouseY) {
        int halfWidth = this.f_96543_ / 2;
        int halfHeight = this.f_96544_ / 2;
        return mouseX >= (double)halfWidth + 81.0 && mouseY >= (double)halfHeight - 99.0 && mouseX < (double)(halfWidth + 81 + 18) && mouseY < (double)(halfHeight - 99 + 18);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mod) {
        if (this.insideSlider(mouseX, mouseY)) {
            this.sliderGrip = true;
        }
        return super.m_6375_(mouseX, mouseY, mod);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        int halfWidth = this.f_96543_ / 2;
        int halfHeight = this.f_96544_ / 2;
        if (this.sliderGrip) {
            this.sliderGrip = false;
        }
        if (this.isMouseOverFilter(mouseX, mouseY)) {
            Item filterBefore = this.filter;
            ItemStack refStack = ((DefaultLazyCraftMenu)this.f_97732_).m_142621_();
            this.filter = refStack != null && refStack != ItemStack.f_41583_ ? (button == 0 && this.filter != refStack.m_41720_() ? refStack.m_41720_() : Items.f_41852_) : Items.f_41852_;
            if (filterBefore != this.filter) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                new MSGUpdateLazyCraftInventory().sendToServer();
                ((DefaultLazyCraftMenu)this.f_97732_).onInventoryChange();
                this.processButtons();
            }
        }
        if (this.selectedRecipe.shouldRenderButtons()) {
            if (this.isMouseOver(mouseX, mouseY, halfWidth + 70, halfHeight - 90, 7, 5) && this.selectedRecipe.canGoUp()) {
                this.selectedRecipe.goUp();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            } else if (this.isMouseOver(mouseX, mouseY, halfWidth + 70, halfHeight - 83, 7, 5) && this.selectedRecipe.canGoDown()) {
                this.selectedRecipe.goDown();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double posX, double posY, int button, double offsetX, double offsetY) {
        if (this.sliderGrip) {
            posY -= 3.0;
            int minSliderY = this.f_97736_ + 67;
            int maxSliderY = this.f_97736_ + 138 - 6;
            this.sliderAdvance = posY < (double)minSliderY ? 0.0f : (posY >= (double)maxSliderY ? 1.0f : (float)((posY - (double)minSliderY) / (double)(maxSliderY - minSliderY)));
        }
        return super.m_7979_(posX, posY, button, offsetX, offsetY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        float old = this.sliderAdvance;
        this.sliderAdvance = Mth.m_14036_((float)(this.sliderAdvance + (float)delta), (float)0.0f, (float)1.0f);
        if (this.sliderAdvance != old) {
            this.processButtons();
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean insideRecipes(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 21) && mouseX < (double)(this.f_97735_ + 219) && mouseY >= (double)(this.f_97736_ + 83) && mouseY < (double)(this.f_97736_ + 137);
    }

    public boolean insideSlider(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 222) && mouseX < (double)(this.f_97735_ + 229) && mouseY >= (double)(this.f_97736_ + 67) && mouseY < (double)(this.f_97736_ + 138);
    }

    private static class DisplayedRecipe {
        private final LazyRecipe recipe;
        private final LazyCraftState state;
        private final int allLines;
        private int ingredientLineIndex;
        private List<XSpacedIngredient> lineIngredientsRenderCache;

        public DisplayedRecipe(LazyRecipe recipe, LazyCraftState state) {
            Font font = Minecraft.m_91087_().f_91062_;
            ImmutableList.Builder initialLineCacheBuilder = ImmutableList.builder();
            int lines = 0;
            this.recipe = recipe;
            this.state = state;
            if (recipe != LazyRecipe.EMPTY) {
                int x = 0;
                for (LazyIngredient ingredient : recipe.getIngredients()) {
                    String countText = ingredient.getCountDisplay();
                    int countTextWidth = font.m_92895_(countText);
                    int countTextWidthHalf = countTextWidth / 2;
                    if (x > 100) {
                        x = 0;
                        ++lines;
                    }
                    x += Mth.m_14045_((int)countTextWidthHalf, (int)9, (int)64);
                    if (lines != 0) break;
                    initialLineCacheBuilder.add((Object)new XSpacedIngredient(ingredient, x, countTextWidthHalf));
                    x += Mth.m_14045_((int)(countTextWidthHalf + 1), (int)9, (int)64);
                }
            }
            this.lineIngredientsRenderCache = initialLineCacheBuilder.build();
            this.allLines = lines;
        }

        private List<XSpacedIngredient> getIngredientsForLine(int lineIndex) {
            Font font = Minecraft.m_91087_().f_91062_;
            int lines = 0;
            if (this.recipe != LazyRecipe.EMPTY) {
                ImmutableList.Builder builder = ImmutableList.builder();
                int x = 0;
                for (LazyIngredient ingredient : this.recipe.getIngredients()) {
                    String countText = ingredient.getCountDisplay();
                    int countTextWidth = font.m_92895_(countText);
                    int countTextWidthHalf = countTextWidth / 2;
                    if (x > 100) {
                        x = 0;
                        ++lines;
                    }
                    x += Mth.m_14045_((int)countTextWidthHalf, (int)9, (int)64);
                    if (lines == lineIndex) {
                        builder.add((Object)new XSpacedIngredient(ingredient, x, countTextWidthHalf));
                    } else if (lines > lineIndex) break;
                    x += Mth.m_14045_((int)(countTextWidthHalf + 1), (int)9, (int)64);
                }
                return builder.build();
            }
            return ImmutableList.of();
        }

        public boolean canGoUp() {
            return this.ingredientLineIndex > 0;
        }

        public boolean canGoDown() {
            return this.ingredientLineIndex <= this.allLines;
        }

        public boolean shouldRenderButtons() {
            return this.allLines > 0;
        }

        public void goUp() {
            --this.ingredientLineIndex;
            this.lineIngredientsRenderCache = this.getIngredientsForLine(this.ingredientLineIndex);
        }

        public void goDown() {
            ++this.ingredientLineIndex;
            this.lineIngredientsRenderCache = this.getIngredientsForLine(this.ingredientLineIndex);
        }

        public LazyCraftState getState() {
            return this.state;
        }

        public LazyRecipe getRecipe() {
            return this.recipe;
        }

        public List<XSpacedIngredient> getLineIngredientsRenderCache() {
            return this.lineIngredientsRenderCache;
        }
    }

    class RecipeButton
    extends AbstractButton {
        private final SolvedLazyRecipe taggedRecipe;

        protected RecipeButton(int x, int y, SolvedLazyRecipe recipe) {
            super(x, y, 18, 18, TextComponent.f_131282_);
            this.taggedRecipe = recipe;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            int color;
            int brightness;
            DefaultLazyCraftScreen.this.image.use();
            RECIPES[this.taggedRecipe.state().ordinal()].render(poseStack, (float)this.f_93620_, (float)this.f_93621_, 0.0f);
            if (this.taggedRecipe.state() == LazyCraftState.CRAFTABLE) {
                brightness = 255;
                color = 0xFFFFFF;
            } else if (this.taggedRecipe.state() == LazyCraftState.RELEVANT) {
                brightness = 195;
                color = 0xC0C0C0;
            } else {
                brightness = 63;
                color = 0x404040;
            }
            RenderUtils.renderItemModelIntoGUI(poseStack, this.taggedRecipe.recipe().getResult(), this.f_93620_ + 1, this.f_93621_ + 1, brightness);
            RenderUtils.renderItemOverlayIntoGUI(Minecraft.m_91087_().f_91062_, this.taggedRecipe.recipe().getResult(), this.f_93620_ + 1, this.f_93621_ + 1, String.valueOf(this.taggedRecipe.recipe().getResult().m_41613_()), color, 0xFFFFFF);
            if (this.isSelected()) {
                DefaultLazyCraftScreen.this.image.use();
                RECIPE_SELECTED.render(poseStack, (float)this.f_93620_, (float)this.f_93621_, -10.0f);
            }
        }

        public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
            TooltipFlag.Default tooltipFlag = Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            DefaultLazyCraftScreen.this.m_96597_(poseStack, this.taggedRecipe.recipe().getResult().m_41651_((Player)((DefaultLazyCraftScreen)DefaultLazyCraftScreen.this).f_96541_.f_91074_, (TooltipFlag)tooltipFlag), mouseX, mouseY);
            super.m_7428_(poseStack, mouseX, mouseY);
        }

        public boolean isSelected() {
            return this.taggedRecipe.recipe().getIndex() == DefaultLazyCraftScreen.this.selectedRecipe.getRecipe().getIndex();
        }

        public void setSelected() {
            DefaultLazyCraftScreen.this.selectedRecipe = new DisplayedRecipe(this.taggedRecipe.recipe(), this.taggedRecipe.state());
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return super.m_5953_(mouseX, mouseY);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean flag;
            if (this.f_93623_ && this.f_93624_ && this.m_7972_(button) && (flag = this.m_93680_(mouseX, mouseY))) {
                if (!this.isSelected()) {
                    this.m_7435_(Minecraft.m_91087_().m_91106_());
                    this.m_5716_(mouseX, mouseY);
                }
                return true;
            }
            return false;
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                this.setSelected();
                if (DefaultLazyCraftScreen.this.selectedRecipe.getRecipe().getIngredients() != null) {
                    for (LazyIngredient ingredient : DefaultLazyCraftScreen.this.selectedRecipe.getRecipe().getIngredients()) {
                        ingredient.onScreenModification(DefaultLazyCraftScreen.this.inventory);
                    }
                }
            }
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }

    record XSpacedIngredient(LazyIngredient ingredient, int xPos, int textWidthOffset) {
    }
}

