/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.particles;

import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.mod.world.builtin_particles.BCParticle;
import bottomtextdanny.braincell.mod.world.particle_utilities.local_sprites.SpriteGroup;
import bottomtextdanny.braincell.mod.world.particle_utilities.local_sprites.SpriteGroupProvider;
import bottomtextdanny.dannys_expansion._base.animation.FloatAnimator;
import bottomtextdanny.dannys_expansion._base.animation.ISimpleAnimator;
import bottomtextdanny.dannys_expansion._util.DEMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SnowflakeParticle
extends BCParticle {
    public static final ISimpleAnimator<Float> SIZE_ANIMATOR = new FloatAnimator(0.0f);
    public static final int RANDOM_0 = 0;
    public static final int RANDOM_1 = 1;
    public static final int RANDOM_2 = 2;
    public static final int RANDOM_3 = 3;
    public static final int RANDOM_4 = 4;
    public static final SpriteGroupProvider GROUPS = SpriteGroupProvider.Builder.create((int)7, (int)5).entry(0, new int[]{0, 5, 6}).entry(1, new int[]{1, 5, 6}).entry(2, new int[]{2, 5, 6}).entry(3, new int[]{3, 5, 6}).entry(4, new int[]{4, 5, 6}).build();
    private final float yawRotOffset;
    private final float pitchRotOffset;
    private final int deltaLife;
    private final float baseSize;

    protected SnowflakeParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet handleSpriteSet) {
        super(world, x, y, z);
        this.yawRotOffset = this.f_107223_.nextFloat() * (float)Math.PI;
        this.pitchRotOffset = this.f_107223_.nextFloat() * (float)Math.PI;
        this.f_107225_ = 3;
        this.deltaLife = this.f_107223_.nextInt(10);
        this.setSpriteGroup((SpriteGroup)GROUPS.fetchRandom(handleSpriteSet));
        this.setLocalSprite(0);
        this.setTicksForEachFrame(new int[]{20 + this.deltaLife, 12, 12});
        this.baseSize = 0.1f + this.f_107223_.nextFloat() * 0.02f;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ *= 0.97;
        this.f_107216_ *= 0.97;
        this.f_107217_ *= 0.97;
        this.f_107216_ -= 0.01;
        if (this.f_107218_) {
            this.m_107274_();
        }
    }

    public void preRender(PoseStack poseStack, VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.ticksPassed < 4) {
            SIZE_ANIMATOR.reset();
            SIZE_ANIMATOR.setActual(this.ticksPassed);
            SIZE_ANIMATOR.start(Float.valueOf(0.0f));
            SIZE_ANIMATOR.addPoint(5.0f, Float.valueOf(this.baseSize));
            this.f_107663_ = SIZE_ANIMATOR.get(Easing.EASE_OUT_GAMMA, partialTicks).floatValue();
        } else {
            this.f_107663_ = this.baseSize;
        }
    }

    public void handleRenderRotations(float partialTicks, Camera info) {
        this.yaw = this.prevYaw = DEMath.sin((double)(this.yawRotOffset + (float)this.ticksPassed + partialTicks) * 0.2) * 80.0f;
        this.pitch = this.prevPitch = 90.0f + DEMath.sin((double)(this.pitchRotOffset + (float)this.ticksPassed + partialTicks) * 0.2) * 80.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public boolean shouldCull() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet p_i50634_1_) {
            this.spriteSet = p_i50634_1_;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SnowflakeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

