/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.projectiles;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion.content.entities.projectile.SquigBubbleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.world.entity.Entity;

public class SquigBubbleModel
extends BCEntityModel<SquigBubbleEntity> {
    private final BCJoint model;
    private final BCJoint rotator;
    private final ModelAnimator animator = new ModelAnimator((BCModel)this, 0.0f);

    public SquigBubbleModel() {
        this.texWidth = 32;
        this.texHeight = 32;
        this.model = new BCJoint((BCModel)this);
        this.model.setPos(0.0f, 0.0f, 0.0f);
        this.rotator = new BCJoint((BCModel)this);
        this.rotator.setPosCore(0.0f, -4.0f, 0.0f);
        this.model.addChild(this.rotator);
        this.rotator.uvOffset(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
    }

    public void handleRotations(SquigBubbleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.handleRotations((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        this.rotator.yRot = (float)((double)this.rotator.yRot + (double)BCMath.sin((float)(ageInTicks * 0.025f + 10.0f)) * Math.PI);
        this.rotator.zRot = (float)((double)this.rotator.zRot + (double)BCMath.sin((float)(ageInTicks * 0.015f + 20.0f)) * Math.PI);
    }

    public void handleKeyframedAnimations(SquigBubbleEntity entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
        this.animator.setTimer((float)entity.getLifeTick() + this.getPartialTick());
        this.animator.setupKeyframe(0.0f);
        this.animator.scale(this.rotator, -1.0f, -1.0f, -1.0f);
        this.animator.apply();
        this.animator.emptyKeyframe(23.0f, Easing.BOUNCE_OUT);
        this.animator.reset();
        if (entity.mainHandler.isPlaying((Animation)SquigBubbleEntity.POP)) {
            this.animator.setTimer(entity.mainHandler.linearProgress());
            this.animator.setupKeyframe(2.0f);
            this.animator.scale(this.rotator, -0.3f, -0.3f, -0.3f);
            this.animator.apply();
            this.animator.setupKeyframe(5.0f);
            this.animator.scale(this.rotator, 0.8f, 0.8f, 0.8f);
            this.animator.apply(Easing.EASE_IN_CUBIC);
            this.animator.reset();
        }
        if (entity.hurtModule.isPlaying((Animation)SquigBubbleEntity.HURT)) {
            this.animator.setTimer(entity.hurtModule.linearProgress());
            this.animator.setupKeyframe(2.0f);
            this.animator.scale(this.rotator, -0.3f, -0.3f, -0.3f);
            this.animator.apply();
            this.animator.setupKeyframe(5.0f);
            this.animator.scale(this.rotator, 0.8f, 0.8f, 0.8f);
            this.animator.apply(Easing.EASE_IN_CUBIC);
            this.animator.emptyKeyframe(3.0f, Easing.LINEAR);
            this.animator.reset();
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

