/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.living_entities.slimes;

import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCBox;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCBoxPosition;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.ModelSectionReseter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.AbstractSlime;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;

public class DannySlimeModel<E extends AbstractSlime>
extends BCEntityModel<E> {
    protected final BCJoint body;

    public DannySlimeModel(float width, float height, int imageWidth, int imageHeight) {
        this.texWidth = imageWidth;
        this.texHeight = imageHeight;
        this.body = new BCJoint((BCModel)this);
        this.body.setPosCore(0.0f, 24.0f, 0.0f);
        this.body.uvOffset(0, 0).addBox(-width / 2.0f, -height, -width / 2.0f, width, height, width, -0.2f, false);
        this.body.uvOffset(0, (int)width + (int)height).addBox(-width / 2.0f, -height, -width / 2.0f, width, height, width, 0.0f, false);
        BCBox cube = this.body.getCube(1);
        this.addReseter((ModelSectionReseter)cube.getPoint(BCBoxPosition.LEFT_DOWN_FRONT));
        this.addReseter((ModelSectionReseter)cube.getPoint(BCBoxPosition.RIGHT_DOWN_FRONT));
        this.addReseter((ModelSectionReseter)cube.getPoint(BCBoxPosition.LEFT_DOWN_BACK));
        this.addReseter((ModelSectionReseter)cube.getPoint(BCBoxPosition.RIGHT_DOWN_BACK));
    }

    public DannySlimeModel(float width, float height) {
        this(width, height, 128, 128);
    }

    public void handleRotations(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float idle = DEMath.sin(ageInTicks * 0.4f) * 0.5f;
        BCBox cube = this.body.getCube(1);
        float magnitude = cube.getPoint((BCBoxPosition)BCBoxPosition.RIGHT_DOWN_BACK).x;
        float blob0 = DEMath.sin(ageInTicks * 0.4f) * 0.08f * magnitude;
        float blob1 = DEMath.cos(ageInTicks * 0.4f) * 0.08f * magnitude;
        float bias = 0.35f;
        cube.getPoint((BCBoxPosition)BCBoxPosition.RIGHT_DOWN_BACK).x += blob0 + bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.RIGHT_DOWN_BACK).z += blob1 + bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.LEFT_DOWN_BACK).x += -blob0 - bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.LEFT_DOWN_BACK).z += -blob1 + bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.RIGHT_DOWN_FRONT).x += blob1 + bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.RIGHT_DOWN_FRONT).z += blob0 - bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.LEFT_DOWN_FRONT).x += -blob1 - bias;
        cube.getPoint((BCBoxPosition)BCBoxPosition.LEFT_DOWN_FRONT).z += -blob0 - bias;
        this.body.addToScale(0.1111f * idle, -0.1f * idle, 0.1111f * idle);
    }

    public void handleKeyframedAnimations(E entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
        ModelAnimator animator = new ModelAnimator((BCModel)this, (float)((AbstractSlime)((Object)entity)).mainHandler.getTick() + this.getPartialTick());
        if (((AbstractSlime)((Object)entity)).mainHandler.isPlaying((Animation)AbstractSlime.JUMP)) {
            animator.setupKeyframe(4.0f);
            animator.scale(this.body, 0.7692f, -0.3f, 0.7692f);
            animator.apply();
            animator.setupKeyframe(3.0f);
            animator.scale(this.body, -0.3f, 0.7692f, -0.3f);
            animator.apply();
            animator.emptyKeyframe(10.0f, Easing.LINEAR);
        }
        if (entity.getLocalAnimationHandler().isPlaying((Animation)AbstractSlime.DEATH)) {
            ModelAnimator deathAnimator = new ModelAnimator((BCModel)this, (float)entity.getLocalAnimationHandler().getTick() + this.getPartialTick());
            deathAnimator.setupKeyframe(10.0f);
            deathAnimator.scale(this.body, 0.7692f, -0.3f, 0.7692f);
            deathAnimator.apply();
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

