/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.living_entities.goblin;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInterpreter;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion.content.entities.mob.goblin.Goblin;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GoblinModel
extends BCEntityModel<Goblin> {
    private final BCJoint root;
    private final BCJoint body;
    private final BCJoint head;
    private final BCJoint rightEar;
    private final BCJoint leftEar;
    private final BCJoint rightarm;
    private final BCJoint rightHandling;
    public final BCJoint rightHandlingRot;
    private final BCJoint leftarm;
    public final BCJoint leftHandling;
    private final BCJoint leftleg;
    private final BCJoint rightleg;
    private final ModelAnimator animator = new ModelAnimator((BCModel)this, 0.0f);
    private final AnimationInterpreter bumpAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/bump"), (BCEntityModel)this);
    private final AnimationInterpreter doubleSlashAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/double_slash"), (BCEntityModel)this);
    private final AnimationInterpreter throwLeftAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/throw_left"), (BCEntityModel)this);
    private final AnimationInterpreter throwRightAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/throw_right"), (BCEntityModel)this);
    private final AnimationInterpreter slashLeftAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/slash_left"), (BCEntityModel)this);
    private final AnimationInterpreter slashRightAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/slash_right"), (BCEntityModel)this);
    private final AnimationInterpreter stabLeftAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/stab_left"), (BCEntityModel)this);
    private final AnimationInterpreter stabRightAttack = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/stab_right"), (BCEntityModel)this);
    private final AnimationInterpreter walk = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "goblin/walk"), (BCEntityModel)this);

    public GoblinModel() {
        this.texWidth = 32;
        this.texHeight = 32;
        this.root = new BCJoint((BCModel)this, "root");
        this.root.setPosCore(0.0f, 24.0f, 0.0f);
        this.body = new BCJoint((BCModel)this, "body");
        this.body.setPosCore(0.0f, -4.0f, 0.0f);
        this.root.addChild(this.body);
        this.body.uvOffset(12, 15).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, 0.0f, false);
        this.body.uvOffset(0, 11).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.025f, false);
        this.head = new BCJoint((BCModel)this, "head");
        this.head.setPosCore(0.0f, -3.0f, 0.0f);
        this.body.addChild(this.head);
        this.head.uvOffset(0, 0).addBox(-4.0f, -6.0f, -2.5f, 8.0f, 6.0f, 5.0f, 0.0f, false);
        this.rightEar = new BCJoint((BCModel)this, "rightEar");
        this.rightEar.setPosCore(4.0f, -3.5f, 0.0f);
        this.head.addChild(this.rightEar);
        this.rightEar.uvOffset(0, 19).addBox(0.0f, -1.5f, 0.0f, 6.0f, 3.0f, 0.0f, 0.0f, false);
        this.leftEar = new BCJoint((BCModel)this, "leftEar");
        this.leftEar.setPosCore(-4.0f, -3.5f, 0.0f);
        this.head.addChild(this.leftEar);
        this.leftEar.uvOffset(12, 11).addBox(-6.0f, -1.5f, 0.0f, 6.0f, 3.0f, 0.0f, 0.0f, false);
        this.rightarm = new BCJoint((BCModel)this, "rightarm");
        this.rightarm.setPosCore(2.0f, -2.5f, 0.0f);
        this.body.addChild(this.rightarm);
        this.setRotationAngle(this.rightarm, 0.0f, 0.0f, -2.3562f);
        this.rightarm.uvOffset(12, 22).addBox(-4.0f, -1.5f, 0.0f, 4.0f, 3.0f, 0.0f, 0.0f, false);
        this.rightHandling = new BCJoint((BCModel)this, "rightHandling");
        this.rightHandling.setPosCore(-3.5f, 0.0f, 0.0f);
        this.rightarm.addChild(this.rightHandling);
        this.rightHandlingRot = new BCJoint((BCModel)this, "rightHandlingRot");
        this.rightHandlingRot.setPosCore(0.0f, 0.0f, 0.0f);
        this.rightHandling.addChild(this.rightHandlingRot);
        this.setRotationAngle(this.rightHandlingRot, 0.0f, 0.0f, -3.1416f);
        this.leftarm = new BCJoint((BCModel)this, "leftarm");
        this.leftarm.setPosCore(-2.0f, -2.5f, 0.0f);
        this.body.addChild(this.leftarm);
        this.setRotationAngle(this.leftarm, 0.0f, 0.0f, -0.7854f);
        this.leftarm.uvOffset(12, 22).addBox(-4.0f, -1.5f, 0.0f, 4.0f, 3.0f, 0.0f, 0.0f, false);
        this.leftHandling = new BCJoint((BCModel)this, "leftHandling");
        this.leftHandling.setPosCore(-3.5f, 0.0f, 0.0f);
        this.leftarm.addChild(this.leftHandling);
        this.leftleg = new BCJoint((BCModel)this, "leftleg");
        this.leftleg.setPosCore(-1.5f, -4.0f, 0.0f);
        this.root.addChild(this.leftleg);
        this.leftleg.uvOffset(0, 22).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 4.0f, 2.0f, 0.0f, false);
        this.rightleg = new BCJoint((BCModel)this, "rightleg");
        this.rightleg.setPosCore(1.5f, -4.0f, 0.0f);
        this.root.addChild(this.rightleg);
        this.rightleg.uvOffset(0, 22).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 4.0f, 2.0f, 0.0f, false);
    }

    public void handleRotations(Goblin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.head.xRot = Mth.m_14036_((float)headPitch, (float)-50.0f, (float)50.0f) * ((float)Math.PI / 180);
        this.head.yRot = Mth.m_14036_((float)headYaw, (float)-70.0f, (float)50.0f) * ((float)Math.PI / 180);
    }

    public void handleKeyframedAnimations(Goblin entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
        float easedlimbSwingAmount = GoblinModel.caculateLimbSwingAmountEasing((LoopedWalkProvider)entity);
        if (!entity.m_20159_()) {
            if (easedlimbSwingAmount > 0.0f) {
                float easedLimbSwing = Mth.m_14036_((float)GoblinModel.caculateLimbSwingEasing((LoopedWalkProvider)entity), (float)0.0f, (float)0.999f);
                float walkMult = Mth.m_14036_((float)(easedlimbSwingAmount * 12.0f), (float)0.0f, (float)1.0f);
                this.animator.setTimer(easedLimbSwing * 20.0f);
                this.animator.multiplier(walkMult);
                this.walk.run(this.animator);
                this.animator.multiplier(1.0f);
            }
        } else {
            this.animator.reset();
            this.setSittingPose();
        }
        if (entity.mainHandler.isPlayingNull()) {
            return;
        }
        this.animator.setTimer(entity.mainHandler.dynamicProgress());
        if (entity.mainHandler.isPlaying((Animation)Goblin.BUMP)) {
            this.bumpAttack.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Goblin.DOUBLE_SLASH)) {
            this.doubleSlashAttack.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Goblin.SLASH_LEFT)) {
            this.slashLeftAttack.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Goblin.SLASH_RIGHT)) {
            this.slashRightAttack.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Goblin.STAB_LEFT)) {
            this.stabLeftAttack.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Goblin.STAB_RIGHT)) {
            this.stabRightAttack.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Goblin.THROW)) {
            if (!entity.hasLeftWeapon()) {
                this.throwLeftAttack.run(this.animator);
            } else {
                this.throwRightAttack.run(this.animator);
            }
        }
    }

    private void setSittingPose() {
        float sittingAngleOffset;
        this.leftleg.xRot = sittingAngleOffset = -1.2217305f;
        this.rightleg.xRot = sittingAngleOffset;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.render(matrixStack, buffer, packedLight, packedOverlay);
    }
}

