/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.living_entities.ghoul;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInterpreter;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion.content._client.model.entities.DEBipedModel;
import bottomtextdanny.dannys_expansion.content.entities.mob.ghoul.Ghoul;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GhoulModel
extends DEBipedModel<Ghoul> {
    private final BCJoint headSpike;
    private final AnimationInterpreter walk = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "ghoul/walk"), (BCEntityModel)this);
    private final AnimationInterpreter punch = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "ghoul/punch"), (BCEntityModel)this);
    private final AnimationInterpreter upPunch = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "ghoul/up_punch"), (BCEntityModel)this);
    private final AnimationInterpreter trap = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "ghoul/trap"), (BCEntityModel)this);
    private final ModelAnimator animator = new ModelAnimator((BCModel)this, 0.0f);

    public GhoulModel() {
        super(64, 64);
        this.root.setPosCore(0.0f, 24.0f, 0.0f);
        this.body.setPosCore(0.0f, -13.0f, 0.0f);
        this.root.addChild(this.body);
        this.body.uvOffset(33, 10).addBox(0.0f, -5.0f, 2.5f, 0.0f, 4.0f, 5.0f, 0.0f, false);
        this.body.uvOffset(0, 0).addBox(-4.5f, -10.0f, -3.0f, 9.0f, 10.0f, 6.0f, 0.0f, false);
        this.body.uvOffset(28, 14).addBox(0.0f, -10.0f, 2.5f, 0.0f, 4.0f, 6.0f, 0.0f, false);
        this.head.setPosCore(0.0f, -10.0f, 0.0f);
        this.body.addChild(this.head);
        this.head.uvOffset(0, 16).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, 0.0f, false);
        this.headSpike = new BCJoint((BCModel)this, "headSpike");
        this.headSpike.setPosCore(-0.5f, -6.0f, 2.5f);
        this.head.addChild(this.headSpike);
        this.setRotationAngle(this.headSpike, 0.3927f, 0.0f, 0.0f);
        this.headSpike.uvOffset(21, 10).addBox(0.5f, -2.0f, -1.0f, 0.0f, 4.0f, 6.0f, 0.0f, false);
        this.rightArm.setPosCore(4.5f, -8.0f, 0.0f);
        this.body.addChild(this.rightArm);
        this.rightArm.uvOffset(12, 30).addBox(0.0f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f, 0.0f, true);
        this.leftArm.setPosCore(-4.5f, -8.0f, 0.0f);
        this.body.addChild(this.leftArm);
        this.leftArm.uvOffset(30, 0).addBox(-3.0f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f, 0.0f, false);
        this.leftLeg.setPosCore(-2.0f, -13.0f, 0.0f);
        this.root.addChild(this.leftLeg);
        this.leftLeg.uvOffset(0, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 13.0f, 3.0f, 0.0f, false);
        this.rightLeg.setPosCore(2.0f, -13.0f, 0.0f);
        this.root.addChild(this.rightLeg);
        this.rightLeg.uvOffset(25, 27).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 13.0f, 3.0f, 0.0f, true);
    }

    public void handleRotations(Ghoul entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float idle1 = DEMath.sin(ageInTicks * 0.05f);
        float idle2 = DEMath.sin(ageInTicks * 0.03f);
        this.head.xRot += Mth.m_14036_((float)headPitch, (float)-70.0f, (float)70.0f) * ((float)Math.PI / 180);
        this.head.yRot += Mth.m_14036_((float)headYaw, (float)-90.0f, (float)60.0f) * ((float)Math.PI / 180);
        this.body.xRot += (float)Math.PI / 90 * idle1;
        this.rightArm.xRot += -0.06981317f * idle1;
        this.leftArm.xRot += 0.06981317f * idle1;
        this.rightArm.zRot += (float)Math.PI / 180 * (-4.0f * idle2 - 4.0f);
        this.leftArm.zRot += (float)Math.PI / 180 * (4.0f * idle2 + 4.0f);
    }

    public void handleKeyframedAnimations(Ghoul entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
        float easedLimbSwingAmount = GhoulModel.caculateLimbSwingAmountEasing((LoopedWalkProvider)entity);
        float tickOffset = BCStaticData.partialTick();
        if (easedLimbSwingAmount > 0.0f) {
            float easedLimbSwing = Mth.m_14036_((float)GhoulModel.caculateLimbSwingEasing((LoopedWalkProvider)entity), (float)0.0f, (float)0.999f);
            float walkMult = Mth.m_14036_((float)(easedLimbSwingAmount * 12.0f), (float)0.0f, (float)1.0f);
            this.animator.setTimer(easedLimbSwing * 20.0f);
            this.animator.multiplier(walkMult);
            this.walk.run(this.animator);
            this.animator.multiplier(1.0f);
        }
        this.animator.setTimer(entity.mainHandler.linearProgress());
        boolean lowerArms = false;
        if (entity.isUsingLeftHand()) {
            this.animator.mirror(true);
        }
        if (entity.mainHandler.isPlaying((Animation)Ghoul.UP_PUNCH)) {
            this.upPunch.run(this.animator);
            lowerArms = true;
        } else if (entity.mainHandler.isPlaying((Animation)Ghoul.PUNCH)) {
            this.punch.run(this.animator);
            lowerArms = true;
        } else if (entity.mainHandler.isPlaying((Animation)Ghoul.TRAP)) {
            this.trap.run(this.animator);
            lowerArms = true;
        }
        this.animator.mirror(false);
        float handRaise = Mth.m_14179_((float)tickOffset, (float)entity.getHandRaiseO(), (float)entity.getHandRaise());
        handRaise = Easing.EASE_OUT_GAMMA.progression(handRaise) * ((float)Math.PI / 180) * -90.0f;
        if (lowerArms) {
            handRaise *= this.animator.disable(9.0f, 4.0f, 9.0f);
        }
        this.rightArm.xRot += handRaise;
        this.leftArm.xRot += handRaise;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.render(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

