/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.living_entities;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion.content.entities.mob.ice_elemental.IceElemental;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;

public class IceElementalModel
extends BCEntityModel<IceElemental> {
    private final BCJoint model;
    private final BCJoint body;
    private final BCJoint bodyZRotator;
    private final BCJoint wingOne;
    private final BCJoint wingOneRotator;
    private final BCJoint wingTwo;
    private final BCJoint wingTwoRotator;
    private final BCJoint wingThree;
    private final BCJoint wingThreeRotator;

    public IceElementalModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.model = new BCJoint((BCModel)this);
        this.model.setPosCore(0.0f, 24.0f, 0.0f);
        this.body = new BCJoint((BCModel)this);
        this.body.setPosCore(0.0f, -5.0f, 0.0f);
        this.model.addChild(this.body);
        this.bodyZRotator = new BCJoint((BCModel)this);
        this.bodyZRotator.setPosCore(0.0f, 0.0f, 0.0f);
        this.body.addChild(this.bodyZRotator);
        this.bodyZRotator.uvOffset(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.wingOne = new BCJoint((BCModel)this);
        this.wingOne.setPosCore(0.0f, 0.0f, 0.0f);
        this.bodyZRotator.addChild(this.wingOne);
        this.setRotationAngle(this.wingOne, 0.0f, 0.0f, -2.0944f);
        this.wingOneRotator = new BCJoint((BCModel)this);
        this.wingOneRotator.setPosCore(0.0f, -7.0f, 0.0f);
        this.wingOne.addChild(this.wingOneRotator);
        this.wingOneRotator.uvOffset(0, 16).addBox(-1.0f, -7.0f, 0.0f, 2.0f, 7.0f, 1.0f, 0.0f, false);
        this.wingOneRotator.uvOffset(6, 16).addBox(-3.0f, -11.0f, 0.0f, 6.0f, 11.0f, 0.0f, 0.0f, false);
        this.wingTwo = new BCJoint((BCModel)this);
        this.wingTwo.setPosCore(0.0f, 0.0f, 0.0f);
        this.bodyZRotator.addChild(this.wingTwo);
        this.wingTwoRotator = new BCJoint((BCModel)this);
        this.wingTwoRotator.setPosCore(0.0f, -7.0f, 0.0f);
        this.wingTwo.addChild(this.wingTwoRotator);
        this.wingTwoRotator.uvOffset(0, 16).addBox(-1.0f, -7.0f, 0.0f, 2.0f, 7.0f, 1.0f, 0.0f, false);
        this.wingTwoRotator.uvOffset(6, 16).addBox(-3.0f, -11.0f, 0.0f, 6.0f, 11.0f, 0.0f, 0.0f, false);
        this.wingThree = new BCJoint((BCModel)this);
        this.wingThree.setPosCore(0.0f, 0.0f, 0.0f);
        this.bodyZRotator.addChild(this.wingThree);
        this.setRotationAngle(this.wingThree, 0.0f, 0.0f, 2.0944f);
        this.wingThreeRotator = new BCJoint((BCModel)this);
        this.wingThreeRotator.setPosCore(0.0f, -7.0f, 0.0f);
        this.wingThree.addChild(this.wingThreeRotator);
        this.wingThreeRotator.uvOffset(0, 16).addBox(-1.0f, -7.0f, 0.0f, 2.0f, 7.0f, 1.0f, 0.0f, false);
        this.wingThreeRotator.uvOffset(6, 16).addBox(-3.0f, -11.0f, 0.0f, 6.0f, 11.0f, 0.0f, 0.0f, false);
    }

    public void handleRotations(IceElemental entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float wingRotationCycle = BCMath.sin((float)(ageInTicks * 0.025f));
        float bodyRotationSin = BCMath.sin((float)(ageInTicks * 0.1f));
        float bodyRotationCos = BCMath.cos((float)(ageInTicks * 0.1f));
        this.body.yRot = headYaw * ((float)Math.PI / 180);
        this.body.xRot += headPitch * ((float)Math.PI / 180);
        this.body.xRot += bodyRotationSin * 5.0f * ((float)Math.PI / 180);
        this.body.zRot += bodyRotationCos * 5.0f * ((float)Math.PI / 180);
        this.wingOne.zRot += (float)Math.PI * 2 * wingRotationCycle;
        this.wingTwo.zRot += (float)Math.PI * 2 * wingRotationCycle;
        this.wingThree.zRot += (float)Math.PI * 2 * wingRotationCycle;
    }

    public void handleKeyframedAnimations(IceElemental entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
        if (entity.mainHandler.isPlaying(IceElemental.ICE_SPIKE_ANIMATION)) {
            ModelAnimator attackAnimator = new ModelAnimator((BCModel)this, entity.mainHandler.linearProgress());
            float wingRot = 45.0f * entity.spikeAnimationRotationMultiplier;
            attackAnimator.setupKeyframe(10.0f);
            attackAnimator.rotate(this.wingOne, 0.0f, 0.0f, wingRot);
            attackAnimator.rotate(this.wingTwo, 0.0f, 0.0f, wingRot);
            attackAnimator.rotate(this.wingThree, 0.0f, 0.0f, wingRot);
            attackAnimator.move(this.wingOneRotator, 0.0f, 3.0f, 0.0f);
            attackAnimator.rotate(this.wingOneRotator, -25.0f, 0.0f, 0.0f);
            attackAnimator.move(this.wingTwoRotator, 0.0f, 3.0f, 0.0f);
            attackAnimator.rotate(this.wingTwoRotator, -25.0f, 0.0f, 0.0f);
            attackAnimator.move(this.wingThreeRotator, 0.0f, 3.0f, 0.0f);
            attackAnimator.rotate(this.wingThreeRotator, -25.0f, 0.0f, 0.0f);
            attackAnimator.apply();
            attackAnimator.staticKeyframe(0.4f);
            wingRot = -30.0f * entity.spikeAnimationRotationMultiplier;
            attackAnimator.setupKeyframe(1.2f);
            attackAnimator.rotate(this.wingOne, 0.0f, 0.0f, wingRot);
            attackAnimator.rotate(this.wingTwo, 0.0f, 0.0f, wingRot);
            attackAnimator.rotate(this.wingThree, 0.0f, 0.0f, wingRot);
            attackAnimator.move(this.wingOneRotator, 0.0f, -4.0f, 0.0f);
            attackAnimator.rotate(this.wingOneRotator, 30.0f, 0.0f, 0.0f);
            attackAnimator.move(this.wingTwoRotator, 0.0f, -4.0f, 0.0f);
            attackAnimator.rotate(this.wingTwoRotator, 30.0f, 0.0f, 0.0f);
            attackAnimator.move(this.wingThreeRotator, 0.0f, -4.0f, 0.0f);
            attackAnimator.rotate(this.wingThreeRotator, 30.0f, 0.0f, 0.0f);
            attackAnimator.apply();
            attackAnimator.staticKeyframe(0.8f);
            attackAnimator.emptyKeyframe(8.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

