/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.living_entities;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInterpreter;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion.content.entities.mob.hollowlet.Hollowlet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HollowletModel
extends BCEntityModel<Hollowlet> {
    private final BCJoint root;
    private final BCJoint body;
    private final BCJoint rightArm;
    public final BCJoint rightHand;
    private final BCJoint leftArm;
    private final BCJoint rightLeg;
    private final BCJoint leftLeg;
    private final AnimationInterpreter walk = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "hollowlet/walk"), (BCEntityModel)this);
    private final AnimationInterpreter horizontalSlash = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "hollowlet/horizontal_slash"), (BCEntityModel)this);
    private final AnimationInterpreter slash = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "hollowlet/slash"), (BCEntityModel)this);
    private final AnimationInterpreter stab = Braincell.client().getAnimationManager().makeInterpreter(new ResourceLocation("dannys_expansion", "hollowlet/stab"), (BCEntityModel)this);
    private final ModelAnimator animator = new ModelAnimator((BCModel)this, 0.0f);

    public HollowletModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.root = new BCJoint((BCModel)this, "root");
        this.root.setPosCore(0.0f, 24.0f, 0.0f);
        this.body = new BCJoint((BCModel)this, "body");
        this.body.setPosCore(0.0f, -3.0f, 0.0f);
        this.root.addChild(this.body);
        this.body.uvOffset(1, 19).addBox(-5.5f, -5.0f, -5.5f, 11.0f, 4.0f, 3.0f, 0.0f, false);
        this.body.uvOffset(23, 19).addBox(-1.5f, -12.0f, -0.5f, 3.0f, 7.0f, 7.0f, 0.0f, false);
        this.body.uvOffset(0, 0).addBox(-4.5f, -9.0f, -4.5f, 9.0f, 9.0f, 9.0f, 0.0f, false);
        this.rightArm = new BCJoint((BCModel)this, "rightArm");
        this.rightArm.setPosCore(-4.5f, -4.0f, 0.0f);
        this.body.addChild(this.rightArm);
        this.setRotationAngle(this.rightArm, 0.0f, 0.0f, 0.3491f);
        this.rightArm.uvOffset(0, 26).addBox(-2.5f, -1.0f, -1.5f, 3.0f, 5.0f, 3.0f, 0.0f, true);
        this.rightHand = new BCJoint((BCModel)this, "rightHand");
        this.rightHand.setPosCore(-1.0f, 3.0f, 0.0f);
        this.rightArm.addChild(this.rightHand);
        this.leftArm = new BCJoint((BCModel)this, "leftArm");
        this.leftArm.setPosCore(4.5f, -4.0f, 0.0f);
        this.body.addChild(this.leftArm);
        this.setRotationAngle(this.leftArm, 0.0f, 0.0f, -0.3491f);
        this.leftArm.uvOffset(0, 26).addBox(-0.5f, -1.0f, -1.5f, 3.0f, 5.0f, 3.0f, 0.0f, false);
        this.rightLeg = new BCJoint((BCModel)this, "rightLeg");
        this.rightLeg.setPosCore(-2.0f, -3.0f, 0.0f);
        this.root.addChild(this.rightLeg);
        this.rightLeg.uvOffset(0, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, true);
        this.leftLeg = new BCJoint((BCModel)this, "leftLeg");
        this.leftLeg.setPosCore(2.0f, -3.0f, 0.0f);
        this.root.addChild(this.leftLeg);
        this.leftLeg.uvOffset(0, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
    }

    public void handleRotations(Hollowlet entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float idle1 = DEMath.sin(ageInTicks * 0.05f);
        float idle2 = DEMath.sin(ageInTicks * 0.03f);
        this.body.xRot += (float)Math.PI / 180 * (2.0f * idle1 + 2.0f);
        this.rightArm.xRot += 0.06981317f * idle1;
        this.leftArm.xRot += -0.06981317f * idle1;
        this.rightArm.zRot += (float)Math.PI / 180 * (4.0f * idle2 + 4.0f);
        this.leftArm.zRot += (float)Math.PI / 180 * (-4.0f * idle2 - 4.0f);
        this.body.yRot += Mth.m_14036_((float)headYaw, (float)-10.0f, (float)10.0f) * ((float)Math.PI / 180);
        this.body.xRot += Mth.m_14036_((float)headPitch, (float)-10.0f, (float)10.0f) * ((float)Math.PI / 180);
    }

    public void handleKeyframedAnimations(Hollowlet entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
        float easedLimbSwingAmount = HollowletModel.caculateLimbSwingAmountEasing((LoopedWalkProvider)entity);
        float tickOffset = BCStaticData.partialTick();
        if (easedLimbSwingAmount > 0.0f) {
            float easedLimbSwing = Mth.m_14036_((float)HollowletModel.caculateLimbSwingEasing((LoopedWalkProvider)entity), (float)0.0f, (float)0.999f);
            float walkMult = Mth.m_14036_((float)(easedLimbSwingAmount * 12.0f), (float)0.0f, (float)1.0f);
            this.animator.setTimer(easedLimbSwing * 20.0f);
            this.animator.multiplier(walkMult);
            this.walk.run(this.animator);
            this.animator.multiplier(1.0f);
        }
        this.animator.setTimer(entity.mainHandler.linearProgress());
        if (entity.mainHandler.isPlaying((Animation)Hollowlet.HORIZONTAL_SLASH)) {
            this.horizontalSlash.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Hollowlet.SLASH)) {
            this.slash.run(this.animator);
        } else if (entity.mainHandler.isPlaying((Animation)Hollowlet.STAB)) {
            this.stab.run(this.animator);
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.render(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

