/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.model.entities.living_entities;

import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCBox;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCTexturedQuad;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.ModelSectionReseter;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import bottomtextdanny.dannys_expansion.content.entities.mob.floam.Floam;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class FloamModel
extends BCEntityModel<Floam> {
    private final BCJoint model;
    private final BCJoint body;
    private final BCJoint rightFrontTent;
    private final BCJoint rightBackTent;
    private final BCJoint leftFrontTent;
    private final BCJoint leftBackTent;
    private final BCTexturedQuad rightFrontTentQuad;
    private final BCTexturedQuad rightBackTentQuad;
    private final BCTexturedQuad leftFrontTentQuad;
    private final BCTexturedQuad leftBackTentQuad;

    public FloamModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.model = new BCJoint((BCModel)this);
        this.model.setPosCore(0.0f, 24.0f, 0.0f);
        this.body = new BCJoint((BCModel)this);
        this.body.setPosCore(0.0f, -1.0f, 0.0f);
        this.model.addChild(this.body);
        this.body.uvOffset(0, 0).addBox(-5.0f, -7.0f, -5.0f, 10.0f, 7.0f, 10.0f, 0.0f, false);
        this.body.uvOffset(0, 17).addBox(-7.0f, -13.0f, -7.0f, 14.0f, 6.0f, 14.0f, 0.0f, false);
        this.rightFrontTent = new BCJoint((BCModel)this);
        this.rightFrontTent.setPosCore(-3.0f, 0.0f, -3.0f);
        this.body.addChild(this.rightFrontTent);
        this.setRotationAngle(this.rightFrontTent, 0.0f, 0.7854f, 0.0f);
        this.rightFrontTent.uvOffset(0, 48).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 13.0f, 0.0f, 0.0f, false);
        this.rightBackTent = new BCJoint((BCModel)this);
        this.rightBackTent.setPosCore(-3.0f, 0.0f, 3.0f);
        this.body.addChild(this.rightBackTent);
        this.setRotationAngle(this.rightBackTent, 0.0f, 2.3562f, 0.0f);
        this.rightBackTent.uvOffset(0, 48).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 13.0f, 0.0f, 0.0f, false);
        this.leftFrontTent = new BCJoint((BCModel)this);
        this.leftFrontTent.setPosCore(3.0f, 0.0f, -3.0f);
        this.body.addChild(this.leftFrontTent);
        this.setRotationAngle(this.leftFrontTent, 0.0f, -0.7854f, 0.0f);
        this.leftFrontTent.uvOffset(0, 48).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 13.0f, 0.0f, 0.0f, false);
        this.leftBackTent = new BCJoint((BCModel)this);
        this.leftBackTent.setPosCore(3.0f, 0.0f, 3.0f);
        this.body.addChild(this.leftBackTent);
        this.setRotationAngle(this.leftBackTent, 0.0f, -2.3736f, 0.0f);
        this.leftBackTent.uvOffset(0, 48).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 13.0f, 0.0f, 0.0f, false);
        this.rightFrontTentQuad = this.setupTentacle(this.rightFrontTent);
        this.leftFrontTentQuad = this.setupTentacle(this.leftFrontTent);
        this.rightBackTentQuad = this.setupTentacle(this.rightBackTent);
        this.leftBackTentQuad = this.setupTentacle(this.leftBackTent);
    }

    private BCTexturedQuad setupTentacle(BCJoint joint) {
        BCBox box = joint.getCube(0);
        box.clearQuad(Direction.UP);
        box.clearQuad(Direction.DOWN);
        box.clearQuad(Direction.EAST);
        box.clearQuad(Direction.WEST);
        box.clearQuad(Direction.SOUTH);
        BCTexturedQuad frontQuad = box.getQuad(Direction.NORTH);
        this.addReseter((ModelSectionReseter)frontQuad);
        return frontQuad;
    }

    public void handleRotations(Floam entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float modelYOffset = Mth.m_14031_((float)(ageInTicks * 0.2f)) * 2.0f + 2.0f;
        float tentacleOffset = (Mth.m_14031_((float)((ageInTicks + 14.0f) * 0.25f)) * 15.0f + 15.0f) * ((float)Math.PI / 180);
        int progress = entity.f_19797_ / 2;
        int xOffset = (progress + entity.hashCode()) % 15;
        int yOffset = xOffset < 8 ? 0 : 1;
        this.rightFrontTentQuad.set((BCModel)this, (float)(16 * xOffset), (float)(48 + 16 * yOffset), 9.0f, 13.0f);
        this.leftBackTentQuad.set((BCModel)this, (float)(16 * xOffset), (float)(48 + 16 * yOffset), 9.0f, 13.0f);
        xOffset = (progress + entity.hashCode() + 7) % 15;
        yOffset = xOffset < 8 ? 0 : 1;
        this.leftFrontTentQuad.set((BCModel)this, (float)(16 * xOffset), (float)(48 + 16 * yOffset), 9.0f, 13.0f);
        this.rightBackTentQuad.set((BCModel)this, (float)(16 * xOffset), (float)(48 + 16 * yOffset), 9.0f, 13.0f);
        this.body.y -= modelYOffset;
        this.rightFrontTent.xRot -= tentacleOffset;
        this.rightBackTent.xRot -= tentacleOffset;
        this.leftFrontTent.xRot -= tentacleOffset;
        this.leftBackTent.xRot -= tentacleOffset;
        this.body.yRot += headYaw * ((float)Math.PI / 180);
        this.body.xRot += Mth.m_14036_((float)headPitch, (float)-10.0f, (float)10.0f) * ((float)Math.PI / 180);
    }

    public void handleKeyframedAnimations(Floam entity, float limbSwing, float limbSwingAmount, float headYaw, float headPitch) {
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.render(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

