/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content._client.ambiances;

import bottomtextdanny.dannys_expansion.content._client.sound_instances.AmbianceSound;
import com.mojang.math.Vector3f;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Ambiance {
    public static final List<Ambiance> AMBIANCES = new LinkedList<Ambiance>();
    public final int id = AMBIANCES.size();
    @Nullable
    private Supplier<AmbianceSound> soundProvider;
    @Nullable
    private AmbianceSound ambianceLoopSound;

    public Ambiance() {
        AMBIANCES.add(this);
    }

    public <T extends Ambiance> T setSound(Supplier<AmbianceSound> sound) {
        this.soundProvider = sound;
        return (T)this;
    }

    public void tick() {
        if (this.soundProvider != null) {
            this.handleSoundTick();
        }
    }

    public void handleSoundTick() {
        if (this.ambianceLoopSound == null) {
            this.ambianceLoopSound = this.soundProvider.get();
            if (this.ambianceLoopSound != null) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.ambianceLoopSound);
            }
        } else if (this.ambianceLoopSound.m_7801_()) {
            this.ambianceLoopSound = null;
        }
    }

    @Nullable
    public AmbianceSound getAmbianceSound() {
        return this.ambianceLoopSound;
    }

    public void setAmbianceLoopSound(@Nullable AmbianceSound ambianceLoopSound) {
        this.ambianceLoopSound = ambianceLoopSound;
    }

    public abstract Vector3f tonemapping();

    public abstract boolean meetsConditions(LocalPlayer var1, int var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ambiance)) {
            return false;
        }
        Ambiance ambiance = (Ambiance)o;
        return this.id == ambiance.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

