/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.compatibility;

import bottomtextdanny.braincell.base.screen.ImageBounds;
import bottomtextdanny.braincell.base.screen.ImageData;
import bottomtextdanny.braincell.mod._base.blitty.Blitty;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRecipe;
import bottomtextdanny.dannys_expansion._util._client.RenderUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.lwjgl.glfw.GLFW;

public class LazyJEICategory
implements IRecipeCategory<LazyRecipe> {
    public static final int SLIDER_PLACE_X = 102;
    public static final int SLIDER_PLACE_Y_START = 1;
    public static final int SLIDER_PLACE_Y_END = 48;
    public static final int STEP_OFFSET = 27;
    public static final int MAX_X_WIDTH = 76;
    public static final ImageData GUI = new ImageData("dannys_expansion", "textures/gui/jei_backgrounds.png", 256, 256);
    private static final Blitty SLIDER = new Blitty((ImageBounds)GUI, 166, 0, 5, 6);
    private final ResourceLocation id;
    private final RenderData[] data;
    private final RenderData fallbackData;
    private final Component name;
    private final IDrawable background;
    private final IDrawable icon;

    public LazyJEICategory(IGuiHelper guiHelper, ResourceLocation id, ItemStack logo, int cacheSlots) {
        this.id = id;
        this.data = new RenderData[cacheSlots];
        this.fallbackData = new RenderData();
        this.background = guiHelper.createDrawable((ResourceLocation)GUI, 0, 0, 166, 55);
        this.icon = guiHelper.createDrawableIngredient((Object)logo);
        this.name = new TranslatableComponent("container.workbench");
    }

    public void draw(LazyRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        String countString;
        RenderData block = this.getRenderData(recipe);
        boolean xOffset = true;
        boolean yOffset = true;
        Font font = Minecraft.m_91087_().f_91062_;
        List<LazyIngredient> lazyIngredients = recipe.getIngredients();
        block.hoveredIngredient = null;
        if (mouseX >= 0.0 && mouseX < 166.0 && mouseY >= -4.0 && mouseY < 57.0) {
            this.handleLeftClicking(block, mouseX, mouseY);
        } else {
            block.sliderGrip = false;
        }
        SLIDER.render(stack, 102.0f, 1.0f + (float)block.sliderOffset, 0.0f);
        int x = 1;
        int y = 1;
        int lineWidth = 0;
        for (LazyIngredient ingredient : lazyIngredients) {
            countString = ingredient.getCountDisplay();
            int countWidth = Minecraft.m_91087_().f_91062_.m_92895_(countString);
            if (lineWidth > 76) {
                x = 1;
                y += 27;
                lineWidth = 0;
            }
            lineWidth += countWidth;
            x += Mth.m_14045_((int)countWidth, (int)18, (int)128);
        }
        int allSteps = y / 27;
        int renderStartStep = (int)(block.sliderOffset / 47.0 * (double)allSteps);
        boolean shouldRender = renderStartStep == 0;
        y = 1;
        x = 1;
        lineWidth = 0;
        for (LazyIngredient ingredient : lazyIngredients) {
            countString = ingredient.getCountDisplay();
            int countWidth = Minecraft.m_91087_().f_91062_.m_92895_(countString);
            int countWidthHalf = countWidth / 2;
            if (lineWidth > 76) {
                x = 1;
                lineWidth = 0;
                int currentStep = (y += 27) / 27;
                shouldRender = currentStep == renderStartStep || currentStep == renderStartStep + 1;
            }
            x += Mth.m_14045_((int)countWidthHalf, (int)9, (int)64);
            if (shouldRender) {
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                ItemStack screenItemStack = new ItemStack((ItemLike)ingredient.screenItem());
                int renderYStart = y - renderStartStep * 27;
                int renderXStart = x - 9;
                if (mouseX >= (double)renderXStart && mouseX < (double)(renderXStart + 16) && mouseY >= (double)renderYStart && mouseY < (double)(renderYStart + 16)) {
                    block.hoveredIngredient = ingredient;
                }
                RenderUtils.renderItemModelIntoGUI(stack, screenItemStack, renderXStart, renderYStart, 255);
                font.m_92811_(countString, (float)(x - font.m_92895_(countString) / 2), (float)(renderYStart + 18), 0xFFFFFF, true, stack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 255);
                buffer.m_109911_();
            }
            lineWidth += countWidth;
            x += Mth.m_14045_((int)countWidthHalf, (int)9, (int)64);
        }
    }

    public List<Component> getTooltipStrings(LazyRecipe recipe, double mouseX, double mouseY) {
        LazyIngredient ingredient = this.getRenderData((LazyRecipe)recipe).hoveredIngredient;
        return ingredient == null ? Collections.emptyList() : ingredient.tooltip((TooltipFlag)TooltipFlag.Default.ADVANCED);
    }

    public void handleLeftClicking(RenderData block, double localCursorX, double localCursorY) {
        boolean clicking;
        boolean bl = clicking = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) == 1;
        if (clicking) {
            if (block.sliderGrip) {
                double yDiffToPreviousClick = localCursorY - block.prevClickY;
                block.sliderOffset = Mth.m_14008_((double)(block.sliderOffset + yDiffToPreviousClick), (double)0.0, (double)47.0);
            } else if (this.insideSliderBounds(localCursorX, localCursorY)) {
                block.sliderOffset = Mth.m_14008_((double)(localCursorY - 1.0 - 3.0), (double)0.0, (double)47.0);
            }
        }
        if (clicking) {
            block.prevClickY = localCursorY;
            if (!block.sliderGrip && this.insideSliderBounds(localCursorX, localCursorY)) {
                block.sliderGrip = true;
            }
        } else {
            block.sliderGrip = false;
        }
    }

    public boolean insideSliderBounds(double localCursorX, double localCursorY) {
        return localCursorX >= 102.0 && localCursorX < 107.0 && localCursorY >= 1.0 && localCursorY < 48.0;
    }

    public boolean handleInput(LazyRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return false;
    }

    public void setIngredients(LazyRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getIngredients().stream().map(LazyIngredient::getRelevantIemStacks).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, LazyRecipe recipe, IIngredients ingredients) {
        List<LazyIngredient> lazyIngredients = recipe.getIngredients();
        int inputSize = lazyIngredients.size();
        recipeLayout.getItemStacks().init(inputSize, false, 144, 18);
        recipeLayout.getItemStacks().set(inputSize, recipe.getResult().m_41777_());
    }

    public ResourceLocation getUid() {
        return this.id;
    }

    public Class<? extends LazyRecipe> getRecipeClass() {
        return LazyRecipe.class;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public RenderData getRenderData(LazyRecipe recipe) {
        int index = recipe.getIndex();
        if (index >= 0) {
            if (this.data[index] == null) {
                this.data[index] = new RenderData();
            }
            return this.data[index];
        }
        return this.fallbackData;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class RenderData {
        private double sliderOffset;
        private double prevClickY;
        private boolean sliderGrip;
        @Nullable
        private LazyIngredient hoveredIngredient;

        private RenderData() {
        }
    }
}

