/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._util.tooltip;

import bottomtextdanny.dannys_expansion._util.DEStringUtil;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipData;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public interface TooltipWriter {
    public void write(int var1, @Nullable ItemStack var2, @Nullable Level var3, List<Component> var4, TooltipFlag var5);

    public static MutableComponent spacing(int spacing, Component other) {
        return new TextComponent(DEStringUtil.repeatChar(' ', spacing)).m_7220_(other);
    }

    public static <T> TooltipWriter data(TooltipData<T> data, T input) {
        return (spacing, stack, level, tooltip, flag) -> tooltip.add(TooltipWriter.spacing(spacing, (Component)data.message(input)));
    }

    public static TooltipWriter componentSupplier(Supplier<Component> component) {
        return (spacing, stack, level, tooltip, flag) -> tooltip.add(TooltipWriter.spacing(spacing, (Component)component.get()));
    }

    public static TooltipWriter component(Component component) {
        return (spacing, stack, level, tooltip, flag) -> tooltip.add(TooltipWriter.spacing(spacing, component));
    }

    public static TooltipWriter trans(String key, MutableComponent object, Style objectStyle, Style textStyle) {
        TranslatableComponent translation = new TranslatableComponent(key);
        return (spacing, stack, level, tooltip, flag) -> {
            TranslatableComponent out;
            String[] split = translation.getString().split("@in<");
            if (split.length > 0) {
                out = new TextComponent(split[0]).m_130940_(ChatFormatting.GREEN);
                MutableComponent translatedShift = object.m_130948_(objectStyle);
                for (int i = 1; i < split.length; ++i) {
                    out.m_7220_((Component)translatedShift);
                    out.m_7220_((Component)new TextComponent(split[i]).m_130948_(textStyle));
                }
            } else {
                out = translation;
            }
            tooltip.add(TooltipWriter.spacing(spacing, (Component)out));
        };
    }
}

