/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._util.tooltip;

import bottomtextdanny.dannys_expansion._util.tooltip.TooltipWriter;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class TooltipTable
implements TooltipWriter {
    private final List<TooltipWriter> data;

    private TooltipTable(List<TooltipWriter> data) {
        this.data = data;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void write(int spacing, @Nullable ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int size = this.data.size();
        for (TooltipWriter writer : this.data) {
            writer.write(spacing, stack, level, tooltip, flag);
        }
    }

    public static class Builder {
        private final List<TooltipWriter> data = Lists.newArrayList();

        private Builder() {
        }

        public Builder block(TooltipWriter readable) {
            this.data.add(readable);
            return this;
        }

        public TooltipTable build() {
            return new TooltipTable(this.data);
        }
    }
}

