/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnParameters {
    public static boolean canMonsterSpawnInLight(EntityType<? extends Mob> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && SpawnParameters.isValidLightLevel(worldIn, pos, randomIn) && SpawnParameters.canSpawnOn(type, worldIn, reason, pos, randomIn);
    }

    public static boolean canSpawnOn(EntityType<? extends Mob> typeIn, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.m_7495_();
        return reason == MobSpawnType.SPAWNER || worldIn.m_8055_(blockpos).m_60643_((BlockGetter)worldIn, blockpos, typeIn);
    }

    public static boolean isValidLightLevel(LevelAccessor worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.m_45517_(LightLayer.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.m_6106_().m_6534_() ? worldIn.m_46849_(pos, 10) : worldIn.m_46803_(pos);
        return i <= randomIn.nextInt(8);
    }

    public static boolean canAnimalSpawn(EntityType<? extends LivingEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random random) {
        return worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && worldIn.m_45524_(pos, 0) > 8;
    }

    public static boolean canMonsterSpawnInLavaHeight(EntityType<? extends Mob> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && pos.m_123342_() <= 36 && SpawnParameters.canSpawnOn(type, worldIn, reason, pos, randomIn);
    }

    public static boolean canSpawnInSurface(EntityType<? extends LivingEntity> entityType, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random rand) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && worldIn.m_45527_(pos);
    }

    public static boolean canSpawnInIsland(EntityType<? extends Mob> entityType, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random rand) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && pos.m_123342_() > 45;
    }

    public static boolean canSpawnInJungle(EntityType<? extends LivingEntity> entityType, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random rand) {
        BlockState blockState = worldIn.m_8055_(pos.m_7495_());
        return worldIn.m_46791_() != Difficulty.PEACEFUL && (blockState.m_204336_(BlockTags.f_13035_) || blockState == Blocks.f_50440_.m_49966_());
    }

    public static boolean noRestriction(EntityType<? extends LivingEntity> entityType, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random rand) {
        return true;
    }
}

