/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public final class JsonReadUtil {
    private static final Gson GSON = new GsonBuilder().create();

    public static boolean isString(JsonObject json, String memberName) {
        return JsonReadUtil.isJsonPrimitive(json, memberName) && json.getAsJsonPrimitive(memberName).isString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isString(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isString();
    }

    public static boolean isNumber(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isBoolean(JsonObject json, String memberName) {
        return JsonReadUtil.isJsonPrimitive(json, memberName) && json.getAsJsonPrimitive(memberName).isBoolean();
    }

    public static boolean isJsonArray(JsonObject json, String memberName) {
        return JsonReadUtil.hasField(json, memberName) && json.get(memberName).isJsonArray();
    }

    public static boolean isJsonPrimitive(JsonObject json, String memberName) {
        return JsonReadUtil.hasField(json, memberName) && json.get(memberName).isJsonPrimitive();
    }

    public static boolean hasField(JsonObject json, String memberName) {
        if (json == null) {
            return false;
        }
        return json.get(memberName) != null;
    }

    public static String getString(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a string, was " + JsonReadUtil.toString(json));
    }

    public static String getString(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getString(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a string");
    }

    public static String getString(JsonObject json, String memberName, String fallback) {
        return json.has(memberName) ? JsonReadUtil.getString(json.get(memberName), memberName) : fallback;
    }

    public static Item getItem(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            String s = json.getAsString();
            return (Item)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Expected " + memberName + " to be an item, was an unknown string '" + s + "'"));
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item, was " + JsonReadUtil.toString(json));
    }

    public static Item getItem(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getItem(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
    }

    public static boolean getBoolean(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Boolean, was " + JsonReadUtil.toString(json));
    }

    public static boolean getBoolean(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getBoolean(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Boolean");
    }

    public static boolean getBoolean(JsonObject json, String memberName, boolean fallback) {
        return json.has(memberName) ? JsonReadUtil.getBoolean(json.get(memberName), memberName) : fallback;
    }

    public static float getFloat(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Float, was " + JsonReadUtil.toString(json));
    }

    public static float getFloat(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getFloat(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Float");
    }

    public static float getFloat(JsonObject json, String memberName, float fallback) {
        return json.has(memberName) ? JsonReadUtil.getFloat(json.get(memberName), memberName) : fallback;
    }

    public static long getLong(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Long, was " + JsonReadUtil.toString(json));
    }

    public static long getLong(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getLong(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Long");
    }

    public static long getLong(JsonObject json, String memberName, long fallback) {
        return json.has(memberName) ? JsonReadUtil.getLong(json.get(memberName), memberName) : fallback;
    }

    public static int getInt(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Int, was " + JsonReadUtil.toString(json));
    }

    public static int getInt(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getInt(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Int");
    }

    public static int getInt(JsonObject json, String memberName, int fallback) {
        return json.has(memberName) ? JsonReadUtil.getInt(json.get(memberName), memberName) : fallback;
    }

    public static byte getByte(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Byte, was " + JsonReadUtil.toString(json));
    }

    public static byte getByte(JsonObject json, String memberName, byte fallback) {
        return json.has(memberName) ? JsonReadUtil.getByte(json.get(memberName), memberName) : fallback;
    }

    public static JsonObject getJsonObject(JsonElement json, String memberName) {
        if (json.isJsonObject()) {
            return json.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JsonObject, was " + JsonReadUtil.toString(json));
    }

    public static JsonObject getJsonObject(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getJsonObject(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a JsonObject");
    }

    public static JsonObject getJsonObject(JsonObject json, String memberName, JsonObject fallback) {
        return json.has(memberName) ? JsonReadUtil.getJsonObject(json.get(memberName), memberName) : fallback;
    }

    public static JsonArray getJsonArray(JsonElement json, String memberName) {
        if (json.isJsonArray()) {
            return json.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JsonArray, was " + JsonReadUtil.toString(json));
    }

    public static JsonArray getJsonArray(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonReadUtil.getJsonArray(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a JsonArray");
    }

    @Nullable
    public static JsonArray getJsonArray(JsonObject json, String memberName, @Nullable JsonArray fallback) {
        return json.has(memberName) ? JsonReadUtil.getJsonArray(json.get(memberName), memberName) : fallback;
    }

    public static <T> T deserializeClass(@Nullable JsonElement json, String memberName, JsonDeserializationContext context, Class<? extends T> adapter) {
        if (json != null) {
            return (T)context.deserialize(json, adapter);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> T deserializeClass(JsonObject json, String memberName, JsonDeserializationContext context, Class<? extends T> adapter) {
        if (json.has(memberName)) {
            return JsonReadUtil.deserializeClass(json.get(memberName), memberName, context, adapter);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> T deserializeClass(JsonObject json, String memberName, T fallback, JsonDeserializationContext context, Class<? extends T> adapter) {
        return json.has(memberName) ? JsonReadUtil.deserializeClass(json.get(memberName), memberName, context, adapter) : fallback;
    }

    public static String toString(JsonElement json) {
        String s = StringUtils.abbreviateMiddle((String)String.valueOf(json), (String)"...", (int)10);
        if (json == null) {
            return "null (missing)";
        }
        if (json.isJsonNull()) {
            return "null (json)";
        }
        if (json.isJsonArray()) {
            return "an array (" + s + ")";
        }
        if (json.isJsonObject()) {
            return "an object (" + s + ")";
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive jsonprimitive = json.getAsJsonPrimitive();
            if (jsonprimitive.isNumber()) {
                return "a number (" + s + ")";
            }
            if (jsonprimitive.isBoolean()) {
                return "a boolean (" + s + ")";
            }
        }
        return s;
    }

    @Nullable
    public static <T> T fromJson(Gson gsonIn, Reader readerIn, Class<T> adapter, boolean lenient) {
        try {
            JsonReader jsonreader = new JsonReader(readerIn);
            jsonreader.setLenient(lenient);
            return (T)gsonIn.getAdapter(adapter).read(jsonreader);
        }
        catch (IOException ioexception) {
            throw new JsonParseException((Throwable)ioexception);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static <T> T fromJSON(Gson gson, Reader reader, TypeToken<T> type, boolean lenient) {
        try {
            JsonReader jsonreader = new JsonReader(reader);
            jsonreader.setLenient(lenient);
            return (T)gson.getAdapter(type).read(jsonreader);
        }
        catch (IOException ioexception) {
            throw new JsonParseException((Throwable)ioexception);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static <T> T fromJSON(Gson gson, String string, TypeToken<T> type, boolean lenient) {
        return JsonReadUtil.fromJSON(gson, new StringReader(string), type, lenient);
    }

    @Nullable
    public static <T> T fromJson(Gson gsonIn, String json, Class<T> adapter, boolean lenient) {
        return JsonReadUtil.fromJson(gsonIn, new StringReader(json), adapter, lenient);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static <T> T fromJSONUnlenient(Gson gson, Reader reader, TypeToken<T> type) {
        return JsonReadUtil.fromJSON(gson, reader, type, false);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static <T> T fromJSONUnlenient(Gson gson, String string, TypeToken<T> type) {
        return JsonReadUtil.fromJSON(gson, string, type, false);
    }

    @Nullable
    public static <T> T fromJson(Gson gson, Reader reader, Class<T> jsonClass) {
        return JsonReadUtil.fromJson(gson, reader, jsonClass, false);
    }

    @Nullable
    public static <T> T fromJson(Gson gsonIn, String json, Class<T> adapter) {
        return JsonReadUtil.fromJson(gsonIn, json, adapter, false);
    }

    public static JsonObject fromJson(String json, boolean lenient) {
        return JsonReadUtil.fromJson(new StringReader(json), lenient);
    }

    public static JsonObject fromJson(Reader reader, boolean lenient) {
        return JsonReadUtil.fromJson(GSON, reader, JsonObject.class, lenient);
    }

    public static JsonObject fromJson(String json) {
        return JsonReadUtil.fromJson(json, false);
    }

    public static JsonObject fromJson(Reader reader) {
        return JsonReadUtil.fromJson(reader, false);
    }

    private JsonReadUtil() {
    }
}

