/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._util;

import bottomtextdanny.dannys_expansion._util.DEMath;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class DERayUtil {
    @Nullable
    public static EntityHitResult rayTraceEntities(Level worldIn, Entity projectile, AABB boundingBox, Predicate<Entity> filter) {
        Entity entity = null;
        for (Entity entity1 : worldIn.m_6249_(projectile, boundingBox, filter)) {
            AABB axisalignedbb = entity1.m_142469_().m_82400_(1.0);
            if (!axisalignedbb.m_82381_(boundingBox)) continue;
            entity = entity1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    @Nullable
    public static EntityHitResult rayTraceEntitiesExpanded(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, AABB expansion, Predicate<Entity> filter) {
        double widthBy2 = expansion.m_82362_() / 2.0;
        double heightBy2 = expansion.m_82376_() / 2.0;
        AABB expandedBoundingBox = boundingBox.m_82377_(widthBy2, heightBy2, widthBy2);
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 hitPos = Vec3.f_82478_;
        for (Entity entity1 : worldIn.m_6249_(projectile, expandedBoundingBox, filter)) {
            AABB axisalignedbb = entity1.m_142469_().m_82377_(widthBy2, heightBy2, widthBy2);
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (optional.isPresent()) {
                double d1 = startVec.m_82557_((Vec3)optional.get());
                if (!(d1 < d0)) continue;
                entity = entity1;
                hitPos = (Vec3)optional.get();
                d0 = d1;
                continue;
            }
            if (!DEMath.intersectsVec(startVec, axisalignedbb)) continue;
            entity = entity1;
        }
        return entity == null ? null : new EntityHitResult(entity, hitPos);
    }

    @Nullable
    public static EntityHitResult rayTraceEntitiesOrb(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        return DERayUtil.rayTraceEntitiesExpanded(worldIn, projectile, startVec, endVec, boundingBox, projectile.m_142469_(), filter);
    }

    @Nullable
    public static EntityHitResult rayTraceEntitiesBullet(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 hitPos = Vec3.f_82478_;
        for (Entity entity1 : worldIn.m_6249_(projectile, boundingBox, filter)) {
            float distProg = -2.0f;
            float closestDistance = Float.MAX_VALUE;
            Vec3 easedPosition = Vec3.f_82478_;
            float hlp = 0.2f;
            float w = entity1.m_20205_() / 2.0f + hlp;
            float h = entity1.m_20206_() + hlp;
            for (int i = 0; i < 4; ++i) {
                double d1;
                AABB axisalignedbb;
                Optional optional;
                Vec3 easedVec = DEMath.getVecLerp(distProg, new Vec3(entity1.f_19790_, entity1.f_19791_, entity1.f_19792_), entity1.m_20182_());
                float distanceToEase = DEMath.getDistance(projectile.m_20182_(), easedVec);
                if (distanceToEase < closestDistance) {
                    closestDistance = distanceToEase;
                    easedPosition = easedVec;
                }
                if ((optional = (axisalignedbb = new AABB(easedVec.m_82520_((double)(-w), (double)(-h), (double)(-w)), easedPosition.m_82520_((double)w, (double)h, (double)w))).m_82371_(startVec, endVec)).isPresent() && (d1 = startVec.m_82557_((Vec3)optional.get())) < d0) {
                    entity = entity1;
                    hitPos = (Vec3)optional.get();
                    d0 = d1;
                }
                distProg += 1.0f;
            }
        }
        return entity == null ? null : new EntityHitResult(entity, hitPos);
    }

    public static HitResult bulletRaytrace(Entity entity, Predicate<Entity> predicate, Vec3 vec, ClipContext.Fluid fluidMode) {
        EntityHitResult entityraytraceresult;
        Vec3 vector3d3;
        Vec3 vector3d2 = entity.m_20182_();
        BlockHitResult raytraceresult = entity.f_19853_.m_45547_(new ClipContext(vector3d2, vector3d3 = vector3d2.m_82549_(vec), ClipContext.Block.COLLIDER, fluidMode, entity));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = DERayUtil.rayTraceEntitiesBullet(entity.f_19853_, entity, vector3d2, vector3d3, entity.m_142469_().m_82369_(vec), predicate)) != null) {
            raytraceresult = entityraytraceresult;
        }
        return raytraceresult;
    }

    public static HitResult expandedRaytrace(Entity entity, Predicate<Entity> predicate, Vec3 vec, AABB expansion, ClipContext.Fluid fluidMode) {
        EntityHitResult entityraytraceresult;
        Vec3 vector3d3;
        Vec3 vector3d2 = entity.m_20182_();
        BlockHitResult raytraceresult = entity.f_19853_.m_45547_(new ClipContext(vector3d2, vector3d3 = vector3d2.m_82549_(vec), ClipContext.Block.COLLIDER, fluidMode, entity));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = DERayUtil.rayTraceEntitiesExpanded(entity.f_19853_, entity, vector3d2, vector3d3, entity.m_142469_().m_82369_(vec), expansion, predicate)) != null) {
            raytraceresult = entityraytraceresult;
        }
        return raytraceresult;
    }

    public static HitResult orbRaytrace(Entity entity, Predicate<Entity> predicate, Vec3 vec, ClipContext.Fluid fluidMode, float inflation) {
        EntityHitResult entityraytraceresult;
        Vec3 vector3d3;
        Vec3 vector3d2 = entity.m_20182_();
        BlockHitResult raytraceresult = entity.f_19853_.m_45547_(new ClipContext(vector3d2, vector3d3 = vector3d2.m_82549_(vec), ClipContext.Block.COLLIDER, fluidMode, entity));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = DERayUtil.rayTraceEntitiesOrb(entity.f_19853_, entity, vector3d2, vector3d3, entity.m_142469_().m_82369_(vec).m_82400_((double)inflation), predicate)) != null) {
            raytraceresult = entityraytraceresult;
        }
        return raytraceresult;
    }

    public static BlockHitResult rayTraceBlocks(Entity p_234618_0_) {
        Vec3 vector3d = p_234618_0_.m_20154_();
        Level world = p_234618_0_.f_19853_;
        Vec3 vector3d1 = p_234618_0_.m_20182_();
        Vec3 vector3d2 = vector3d1.m_82549_(vector3d);
        return world.m_45547_(new ClipContext(vector3d1, vector3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, p_234618_0_));
    }

    public static boolean noCollision(Level level, Vec3 vector1, Vec3 vector2) {
        if (vector1.m_82554_(vector2) > 128.0) {
            return false;
        }
        return level.m_45547_(new ClipContext(vector1, vector2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    private DERayUtil() {
    }
}

