/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._mixin;

import bottomtextdanny.braincell.mod.capability.CapabilityHelper;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelCapability;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelPhaseModule;
import bottomtextdanny.dannys_expansion.content.entities._modules.phase_affected_provider.AttributeTransformer;
import bottomtextdanny.dannys_expansion.content.entities._modules.phase_affected_provider.PhaseAffectedProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="HEAD")}, method={"finalizeSpawn"}, remap=true, cancellable=true)
    public void finalizeSpawnHook(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType spawnType, SpawnGroupData p_21437_, CompoundTag p_21438_, CallbackInfoReturnable<SpawnGroupData> cir) {
        PhaseAffectedProvider provider;
        MobMixin mobMixin;
        if (!this.f_19853_.m_5776_() && spawnType != MobSpawnType.COMMAND && (mobMixin = this) instanceof PhaseAffectedProvider && (provider = (PhaseAffectedProvider)((Object)mobMixin)).operatingPhaseAffectedModule() && !provider.phaseAffectedModule().processed) {
            boolean updated = provider.phaseAffectedModule().isUpdated();
            LevelPhaseModule.Phase levelPhase = ((LevelCapability)CapabilityHelper.get((Object)this.f_19853_, LevelCapability.TOKEN)).getPhaseModule().getPhase();
            LevelPhaseModule.Phase phase = updated ? provider.getPhaseWhenSpawned() : levelPhase;
            provider.phaseAffectedModule().setPhaseSpawned(phase);
            if (phase != LevelPhaseModule.Phase.NORMAL && !updated) {
                AttributeTransformer<?>[] transformers = this.getTransformers();
                if (transformers == null) {
                    throw new UnsupportedOperationException("Danny's Expansion: PhaseAffectedProvider type lacks a custom attribute configuration, entity type: " + this.m_6095_().getRegistryName().toString());
                }
                boolean fullHealth = this.m_21223_() == this.m_21233_();
                for (AttributeTransformer<?> transformer : transformers) {
                    AttributeInstance inst = this.m_21051_(transformer.attribute());
                    if (inst == null) continue;
                    inst.m_22100_(transformer.transformSupplier().calculate(phase, this, inst.m_22115_()));
                }
                if (fullHealth) {
                    this.m_21153_(this.m_21233_());
                }
            }
            provider.phaseAffectedModule().processed = true;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"}, remap=true)
    public void readAdditionalSaveDataHook(CompoundTag tag, CallbackInfo ci) {
        MobMixin mobMixin;
        if (!this.f_19853_.m_5776_() && (mobMixin = this) instanceof PhaseAffectedProvider) {
            PhaseAffectedProvider provider = (PhaseAffectedProvider)((Object)mobMixin);
            if (!provider.operatingPhaseAffectedModule() || provider.phaseAffectedModule().processed) {
                return;
            }
            boolean updated = provider.phaseAffectedModule().isUpdated();
            LevelPhaseModule.Phase levelPhase = ((LevelCapability)CapabilityHelper.get((Object)this.f_19853_, LevelCapability.TOKEN)).getPhaseModule().getPhase();
            LevelPhaseModule.Phase phase = updated ? provider.getPhaseWhenSpawned() : levelPhase;
            provider.phaseAffectedModule().setPhaseSpawned(phase);
            if (phase != LevelPhaseModule.Phase.NORMAL && !updated) {
                AttributeTransformer<?>[] transformers = this.getTransformers();
                if (transformers == null) {
                    throw new UnsupportedOperationException("Danny's Expansion: PhaseAffectedProvider type lacks a custom attribute configuration, entity type: " + this.m_6095_().getRegistryName().toString());
                }
                float diskHealth = tag.m_128457_("Health");
                boolean fullHealth = diskHealth == this.m_21233_();
                for (AttributeTransformer<?> transformer : transformers) {
                    AttributeInstance inst = this.m_21051_(transformer.attribute());
                    if (inst == null) continue;
                    inst.m_22100_(transformer.transformSupplier().calculate(phase, this, inst.m_22115_()));
                }
                if (fullHealth || !tag.m_128441_("Health")) {
                    this.m_21153_(this.m_21233_());
                } else {
                    this.m_21153_(diskHealth);
                }
            }
            provider.phaseAffectedModule().processed = true;
        }
    }

    private AttributeTransformer<?>[] getTransformers() {
        return DannysExpansion.common().getPhaseAttributeTransformers().getTransformersForType(this.m_6095_());
    }
}

