/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.rendering_hooks;

import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunClientData;
import bottomtextdanny.dannys_expansion._base.gun_rendering.ScopeRenderingData;
import bottomtextdanny.dannys_expansion._util._client.CMC;
import bottomtextdanny.dannys_expansion._util._client.RenderUtils;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import bottomtextdanny.dannys_expansion.content.items.gun.ScopingGun;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;

@OnlyIn(value=Dist.CLIENT)
public final class CrosshairRendering {
    private static final ResourceLocation CROSSHAIR = new ResourceLocation("dannys_expansion", "textures/gui/gun_crosshair.png");

    public static void changeToGunCrosshairIfShould(RenderGameOverlayEvent.PreLayer event) {
        PlayerGunModule gunModule;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = CMC.player();
        Options options = minecraft.f_91066_;
        PoseStack pose = event.getMatrixStack();
        if (options.f_92062_) {
            return;
        }
        if (!options.m_92176_().m_90612_()) {
            return;
        }
        if (minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR && !CrosshairRendering.isTargetNamedMenuProvider(minecraft.f_91077_)) {
            return;
        }
        if (player == null || !player.m_6084_()) {
            return;
        }
        if (event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT) {
            if (CrosshairRendering.render(pose, player, options)) {
                event.setCanceled(true);
            }
        } else if (event.getOverlay() == ForgeIngameGui.HOTBAR_ELEMENT && (gunModule = PlayerHelper.gunModule((Player)player)).getGunScoping() != ItemStack.f_41583_) {
            event.setCanceled(true);
        }
    }

    public static boolean render(PoseStack pose, @Nonnull LocalPlayer player, Options options) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (player.m_21211_() != ItemStack.f_41583_) {
            return false;
        }
        int width = minecraft.m_91268_().m_85445_();
        int height = minecraft.m_91268_().m_85446_();
        PlayerGunModule gunModule = PlayerHelper.gunModule((Player)player);
        if (gunModule.getPreviousGun().m_41720_() instanceof GunItem) {
            Item item = gunModule.getGunScoping().m_41720_();
            if (item instanceof ScopingGun) {
                ScopingGun scopingGun = (ScopingGun)item;
                CrosshairRendering.renderScope(pose, width, height, scopingGun);
                return true;
            }
            if (!options.f_92063_ || player.m_36330_() || options.f_92047_) {
                RenderSystem.m_157191_().m_85836_();
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)CROSSHAIR);
                CrosshairRendering.renderGunCrosshair(pose, width, height);
                RenderSystem.m_157191_().m_85849_();
                return true;
            }
        }
        return false;
    }

    private static void renderScope(PoseStack pose, int width, int height, ScopingGun gun) {
        GunClientData gunData = DannysExpansion.client().getGunData();
        ScopeRenderingData data = DannysExpansion.client().getGunRenderData().getScopeData(gun);
        float tickOffset = BCStaticData.partialTick();
        int widthByTwo = width / 2;
        int heightByTwo = height / 2;
        int scopeSizeDivTwo = data.scopeSize() / 2;
        int scopeSizeByTwo = data.scopeSize() * 2;
        float innerScopeOffsetX = Mth.m_14179_((float)tickOffset, (float)CMC.player().f_19859_, (float)CMC.player().m_146908_()) - Mth.m_14179_((float)tickOffset, (float)gunData.yawO, (float)gunData.yaw);
        float innerScopeOffsetY = Mth.m_14179_((float)tickOffset, (float)CMC.player().f_19860_, (float)CMC.player().m_146909_()) - Mth.m_14179_((float)tickOffset, (float)gunData.pitchO, (float)gunData.pitch);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)data.scopeTexturePaths()[2]);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR);
        RenderUtils.fBlit(pose, (float)(widthByTwo - scopeSizeDivTwo) - innerScopeOffsetX, (float)(heightByTwo - scopeSizeDivTwo) - innerScopeOffsetY, 0, 0.0f, 0.0f, data.scopeSize(), data.scopeSize(), data.scopeSize(), data.scopeSize());
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)data.scopeTexturePaths()[1]);
        RenderUtils.fBlit(pose, (float)(widthByTwo - data.scopeSize()) - innerScopeOffsetX, (float)(heightByTwo - data.scopeSize()) - innerScopeOffsetY, 0, 0.0f, 0.0f, scopeSizeByTwo, scopeSizeByTwo, scopeSizeByTwo, scopeSizeByTwo);
        RenderSystem.m_157456_((int)0, (ResourceLocation)data.scopeTexturePaths()[0]);
        RenderUtils.fBlit(pose, widthByTwo - scopeSizeDivTwo, heightByTwo - scopeSizeDivTwo, 0, 0.0f, 0.0f, data.scopeSize(), data.scopeSize(), data.scopeSize(), data.scopeSize());
        RenderSystem.m_157191_().m_85836_();
        int x1 = 0;
        int x2 = width;
        int y1 = 0;
        int y2 = heightByTwo - scopeSizeDivTwo;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tess.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        y1 = heightByTwo + scopeSizeDivTwo;
        y2 = height;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        x2 = widthByTwo - scopeSizeDivTwo;
        y1 = heightByTwo - scopeSizeDivTwo;
        y2 = heightByTwo + scopeSizeDivTwo;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        x1 = widthByTwo + scopeSizeDivTwo;
        x2 = width;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y2, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x2, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85982_(pose.m_85850_().m_85861_(), (float)x1, (float)y1, 0.0f).m_6122_(10, 0, 20, 255).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_157191_().m_85849_();
    }

    private static boolean renderGunCrosshair(PoseStack poseStack, int width, int height) {
        Options options = Minecraft.m_91087_().f_91066_;
        float tickOffset = BCStaticData.partialTick();
        if (!options.f_92063_ || options.f_92062_ || Minecraft.m_91087_().f_91074_.m_36330_() || options.f_92047_) {
            GunClientData gunData = DannysExpansion.client().getGunData();
            double fov = Minecraft.m_91087_().f_91066_.f_92068_;
            float visualDispersion = (float)((double)width * Mth.m_14139_((double)tickOffset, (double)gunData.renderDispersionO, (double)gunData.renderDispersion) / fov) / 2.0f;
            int widthByTwo = width / 2;
            int heightByTwo = height / 2;
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderUtils.fBlit(poseStack, (float)(widthByTwo - 5) - visualDispersion, heightByTwo - 3, 0, 0.0f, 7.0f, 6, 5, 19, 19);
            RenderUtils.fBlit(poseStack, (float)widthByTwo + visualDispersion, heightByTwo - 3, 0, 13.0f, 7.0f, 6, 5, 19, 19);
            RenderUtils.fBlit(poseStack, widthByTwo - 2, (float)(heightByTwo - 6) - visualDispersion, 0, 7.0f, 0.0f, 5, 6, 19, 19);
            RenderUtils.fBlit(poseStack, widthByTwo - 2, (float)(heightByTwo - 1) + visualDispersion, 0, 7.0f, 13.0f, 5, 6, 19, 19);
            return true;
        }
        PoseStack pose = RenderSystem.m_157191_();
        pose.m_85836_();
        pose.m_85837_((double)(width / 2), (double)(height / 2), 0.0);
        Camera activerenderinfo = Minecraft.m_91087_().f_91063_.m_109153_();
        pose.m_85845_(new Quaternion(activerenderinfo.m_90589_(), -1.0f, 0.0f, 0.0f));
        pose.m_85845_(new Quaternion(activerenderinfo.m_90590_(), 0.0f, 1.0f, 0.0f));
        pose.m_85841_(-1.0f, -1.0f, -1.0f);
        RenderSystem.m_69881_((int)10);
        RenderSystem.m_157191_().m_85849_();
        return false;
    }

    private static boolean isTargetNamedMenuProvider(@Nullable HitResult rayTraceIn) {
        if (rayTraceIn == null) {
            return false;
        }
        if (rayTraceIn.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)rayTraceIn).m_82443_() instanceof MenuProvider;
        }
        if (rayTraceIn.m_6662_() == HitResult.Type.BLOCK) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            BlockPos blockpos = ((BlockHitResult)rayTraceIn).m_82425_();
            return world.m_8055_(blockpos).m_60750_((Level)world, blockpos) != null;
        }
        return false;
    }

    private CrosshairRendering() {
    }
}

