/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.network.servertoclient.world;

import bottomtextdanny.braincell.mod.capability.CapabilityHelper;
import bottomtextdanny.braincell.mod.network.BCPacket;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelCapability;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelWindModule;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGUpdateWindState
implements BCPacket<MSGUpdateWindState> {
    private final float windDirection;
    private final float windStrength;
    private final boolean windStopped;

    public MSGUpdateWindState(float windDirection, float windStrength, boolean windStopped) {
        this.windDirection = windDirection;
        this.windStrength = windStrength;
        this.windStopped = windStopped;
    }

    public void serialize(FriendlyByteBuf stream) {
        stream.writeFloat(this.windDirection);
        stream.writeFloat(this.windStrength);
        stream.writeBoolean(this.windStopped);
    }

    public MSGUpdateWindState deserialize(FriendlyByteBuf stream) {
        return new MSGUpdateWindState(stream.readFloat(), stream.readFloat(), stream.readBoolean());
    }

    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        super.postDeserialization(ctx, world);
        Connection.doClientSide(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                LevelCapability capability = (LevelCapability)CapabilityHelper.get((Object)Minecraft.m_91087_().f_91073_, LevelCapability.TOKEN);
                LevelWindModule windModule = capability.getWindModule();
                windModule.updateFromPacket(this);
            }
        });
    }

    public float getWindDirection() {
        return this.windDirection;
    }

    public float getWindStrength() {
        return this.windStrength;
    }

    public boolean isWindStopped() {
        return this.windStopped;
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

