/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.network.servertoclient.player;

import bottomtextdanny.braincell.mod.capability.CapabilityHelper;
import bottomtextdanny.braincell.mod.capability.player.accessory.AccessoryKey;
import bottomtextdanny.braincell.mod.capability.player.accessory.IAccessory;
import bottomtextdanny.braincell.mod.network.BCEntityPacket;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.capabilities.player.DEAccessoryModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerCapability;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import bottomtextdanny.dannys_expansion._util._client.CMC;
import bottomtextdanny.dannys_expansion.content.accessories.CoreAccessory;
import bottomtextdanny.dannys_expansion.tables.DEAccessoryKeys;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGSendPlayerAccessories
extends BCEntityPacket<MSGSendPlayerAccessories, Player> {
    private List<ItemStack> items;
    List<CoreAccessory> serverAccessories;
    @Nullable
    private List<AccessoryKey<?>> accessoryKeys;
    @Nullable
    private Player cachedPlayer;

    public MSGSendPlayerAccessories(FriendlyByteBuf stream) {
        super(stream.readInt());
        Connection.doClientSide(() -> {
            Entity patt1829$temp;
            if (CMC.player() != null && (patt1829$temp = CMC.player().f_19853_.m_6815_(this.getEntityId())) instanceof Player) {
                Player trackedPlayer;
                this.cachedPlayer = trackedPlayer = (Player)patt1829$temp;
                ArrayList newItemlist = Lists.newArrayListWithCapacity((int)10);
                ArrayList newKeylist = Lists.newArrayListWithCapacity((int)10);
                for (int i = 0; i < 10; ++i) {
                    if (stream.readBoolean()) {
                        newItemlist.add(stream.m_130267_());
                        newKeylist.add((AccessoryKey)AccessoryKey.getAccessoriesById().get(stream.readInt()));
                        continue;
                    }
                    newItemlist.add(ItemStack.f_41583_);
                    newKeylist.add(DEAccessoryKeys.CORE_EMPTY);
                }
                this.items = newItemlist;
                this.accessoryKeys = newKeylist;
            }
        });
    }

    public MSGSendPlayerAccessories(int entityId, List<ItemStack> coreItems, List<CoreAccessory> accessories) {
        super(entityId);
        this.items = coreItems;
        this.serverAccessories = accessories;
    }

    public MSGSendPlayerAccessories deserialize(FriendlyByteBuf stream) {
        return new MSGSendPlayerAccessories(stream);
    }

    public void serialize(FriendlyByteBuf stream) {
        super.serialize(stream);
        for (int i = 0; i < 10; ++i) {
            boolean writeFlag = this.items.get(i) != ItemStack.f_41583_;
            stream.writeBoolean(writeFlag);
            if (!writeFlag) continue;
            stream.m_130055_(this.items.get(i));
            stream.writeInt(this.serverAccessories.get(i).getKey().getId());
        }
    }

    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        if (this.accessoryKeys != null) {
            DEAccessoryModule accessoryModule = ((PlayerCapability)CapabilityHelper.get((Object)this.cachedPlayer, PlayerCapability.TOKEN)).accessoryModule();
            for (int i = 0; i < 10; ++i) {
                IAccessory accessory = this.accessoryKeys.get(i).create(this.cachedPlayer);
                if (!(accessory instanceof CoreAccessory)) continue;
                CoreAccessory coreAccessory = (CoreAccessory)accessory;
                accessoryModule.setAccessoryStack(i, this.items.get(i));
                accessoryModule.getCoreAccessoryList().set(i, coreAccessory);
                coreAccessory.prepare(i);
            }
        }
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

