/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.network.servertoclient;

import bottomtextdanny.braincell.mod.network.BCPacket;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.LazyRecipeManager;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.LazyRecipeType;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRecipe;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGUpdateRecipes
implements BCPacket<MSGUpdateRecipes> {
    private static final String TYPE_TAG = "type";
    private final int recipesSize;
    private final List<CompoundTag> recipeNBT;

    @OnlyIn(value=Dist.CLIENT)
    public MSGUpdateRecipes(FriendlyByteBuf packetBuffer) {
        this.recipesSize = packetBuffer.readInt();
        List<CompoundTag> newList = Arrays.asList(new CompoundTag[this.recipesSize]);
        for (int i = 0; i < this.recipesSize; ++i) {
            CompoundTag comp = packetBuffer.m_130260_();
            if (comp == null) continue;
            newList.set(i, comp);
        }
        this.recipeNBT = newList;
    }

    public MSGUpdateRecipes(Map<LazyRecipeType, List<LazyRecipe>> allRecipes) {
        ArrayList nbtList = Lists.newArrayList();
        if (allRecipes != null) {
            allRecipes.forEach((type, recipes) -> {
                int typeIndex = DannysExpansion.common().getLazyRecipeManager().getTypeId((LazyRecipeType)type);
                recipes.forEach(rec -> {
                    CompoundTag tag = rec.serialize();
                    tag.m_128405_(TYPE_TAG, typeIndex);
                    nbtList.add(tag);
                });
            });
        }
        this.recipesSize = nbtList.size();
        this.recipeNBT = nbtList;
    }

    public void serialize(FriendlyByteBuf stream) {
        stream.writeInt(this.recipesSize);
        this.recipeNBT.forEach(tag -> stream.m_130079_(tag));
    }

    @OnlyIn(value=Dist.CLIENT)
    public MSGUpdateRecipes deserialize(FriendlyByteBuf stream) {
        return new MSGUpdateRecipes(stream);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        LazyRecipeManager manager = DannysExpansion.common().getLazyRecipeManager();
        manager.resetRecipeCache();
        int[] indexer = new int[manager.recipeTypeSize()];
        for (CompoundTag nbt : this.recipeNBT) {
            LazyRecipeType type = manager.getTypeById(nbt.m_128451_(TYPE_TAG));
            int typeIndex = manager.getTypeId(type);
            manager.addRecipe(type, LazyRecipe.deserialize(indexer[typeIndex], nbt));
            int n = typeIndex;
            indexer[n] = indexer[n] + 1;
        }
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

