/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.network.servertoclient;

import bottomtextdanny.braincell.mod.network.BCEntityPacket;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunClientData;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGUpdateGunCooldown
extends BCEntityPacket<MSGUpdateGunCooldown, Player> {
    private final int handOrdinal;

    public MSGUpdateGunCooldown(int entityId, int hand) {
        super(entityId);
        this.handOrdinal = hand;
    }

    public void serialize(FriendlyByteBuf stream) {
        super.serialize(stream);
        stream.writeInt(this.handOrdinal);
    }

    public MSGUpdateGunCooldown deserialize(FriendlyByteBuf stream) {
        return new MSGUpdateGunCooldown(stream.readInt(), stream.readInt());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        Connection.doClientSide(() -> {
            Player player = (Player)this.getEntityAsReceptor(world);
            if (player != null) {
                boolean local = player instanceof LocalPlayer;
                GunClientData gunData = DannysExpansion.client().getGunData();
                PlayerGunModule gunModule = PlayerHelper.gunModule(player);
                ItemStack handStack = player.m_21120_(InteractionHand.values()[this.handOrdinal]);
                if (local) {
                    gunData.recoil = 0.0f;
                    gunData.recoilO = 0.0f;
                }
                int cooldown = 0;
                if (handStack.m_41720_() instanceof GunItem) {
                    cooldown = ((GunItem)handStack.m_41720_()).cooldown();
                    if (local) {
                        gunData.retrieveFactor = (int)((float)cooldown * 0.75f + 5.0f);
                    }
                }
                gunModule.setGunScoping(ItemStack.f_41583_);
                gunModule.setPreviousGun(handStack);
                gunModule.setGunCooldownTicks(cooldown);
                gunModule.setGunUseTicks(-1);
            }
        });
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

