/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.network.servertoclient;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.util.H_WorldDataParser;
import bottomtextdanny.braincell.mod.network.BCEntityPacket;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.capabilities.player.DEAccessoryModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableObject;

public class MSGCoreAccessoryClientManager
extends BCEntityPacket<MSGCoreAccessoryClientManager, Player> {
    private int accessoryIndex;
    private int flag;
    private WorldPacketData<?>[] packetObjects;
    private Object[] objects;
    private ServerLevel level;

    public MSGCoreAccessoryClientManager(int playerId) {
        super(playerId);
    }

    public MSGCoreAccessoryClientManager(int entityId, int accessoryIndex, int flag, WorldPacketData<?>[] objects, ServerLevel level) {
        super(entityId);
        this.accessoryIndex = accessoryIndex;
        this.flag = flag;
        this.packetObjects = objects;
        this.level = level;
    }

    public void serialize(FriendlyByteBuf stream) {
        super.serialize(stream);
        stream.writeInt(this.accessoryIndex);
        stream.writeInt(this.flag);
        if (this.packetObjects == null) {
            stream.writeInt(0);
        } else {
            int bound = this.packetObjects.length;
            stream.writeInt(bound);
            for (int i = 0; i < bound; ++i) {
                WorldPacketData<?> object = this.packetObjects[i];
                if (object != null) {
                    stream.writeInt(Braincell.common().getSerializerLookUp().getIdFromSerializer(object.getSerializer()));
                    object.writeToStream(stream, (Level)this.level);
                    continue;
                }
                stream.writeInt(-1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MSGCoreAccessoryClientManager deserialize(FriendlyByteBuf stream) {
        MutableObject msg = new MutableObject(null);
        Connection.doClientSide(() -> {
            msg.setValue((Object)new MSGCoreAccessoryClientManager(stream.readInt()));
            ((MSGCoreAccessoryClientManager)((Object)((Object)msg.getValue()))).accessoryIndex = stream.readInt();
            ((MSGCoreAccessoryClientManager)((Object)((Object)msg.getValue()))).flag = stream.readInt();
            int size = stream.readInt();
            ((MSGCoreAccessoryClientManager)((Object)((Object)msg.getValue()))).objects = new Object[size];
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    int serializerId = stream.readInt();
                    SerializerMark serializer = Braincell.common().getSerializerLookUp().getSerializerFromId(serializerId);
                    if (serializer == null) continue;
                    ((MSGCoreAccessoryClientManager)((Object)((Object)msg.getValue()))).objects[i] = H_WorldDataParser.readDataFromPacket((FriendlyByteBuf)stream, (SerializerMark)serializer, (Level)Minecraft.m_91087_().f_91073_);
                }
            }
        });
        return (MSGCoreAccessoryClientManager)((Object)msg.getValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        Connection.doClientSide(() -> {
            Player player = (Player)this.getEntityAsReceptor(world);
            if (player != null && player.m_6084_()) {
                DEAccessoryModule accessoryModule = PlayerHelper.accessoryModule(player);
                accessoryModule.getCoreAccessoryList().get(this.accessoryIndex).accessoryClientManager(this.flag, ObjectFetcher.of((Object[])this.objects));
            }
        });
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

