/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.network.servertoclient;

import bottomtextdanny.braincell.mod.network.BCEntityPacket;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGCShootGun
extends BCEntityPacket<MSGCShootGun, Player> {
    final int hand;

    public MSGCShootGun(int entityId, int hand) {
        super(entityId);
        this.hand = hand;
    }

    public void serialize(FriendlyByteBuf stream) {
        super.serialize(stream);
        stream.writeInt(this.hand);
    }

    public MSGCShootGun deserialize(FriendlyByteBuf stream) {
        return new MSGCShootGun(stream.readInt(), stream.readInt());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        Connection.doClientSide(() -> {
            Player player = (Player)this.getEntityAsReceptor(world);
            if (player != null) {
                PlayerGunModule capability = PlayerHelper.gunModule(player);
                if (this.hand >= 256) {
                    InteractionHand handE = InteractionHand.values()[this.hand - 256];
                    ItemStack handStack = player.m_21120_(handE);
                    Item patt1987$temp = handStack.m_41720_();
                    if (patt1987$temp instanceof GunItem) {
                        GunItem gunItem = (GunItem)patt1987$temp;
                        gunItem.shootFirstCallout(player, handStack, capability);
                        capability.setGunUseTicks(0);
                    }
                } else {
                    InteractionHand handE = InteractionHand.values()[this.hand];
                    ItemStack handStack = player.m_21120_(handE);
                    Item patt2300$temp = handStack.m_41720_();
                    if (patt2300$temp instanceof GunItem) {
                        GunItem gunItem = (GunItem)patt2300$temp;
                        gunItem.shootFirstCallout(player, handStack, capability);
                    }
                }
            }
        });
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

