/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe.type.item_predicates;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.ItemStackPredicateTypes;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.item_predicates.ItemStackPredicate;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public final class ItemStackPredicateType<T extends ItemStackPredicate> {
    private static final Map<Character, ItemStackPredicateType<?>> KEY_TO_PREDICATE = new HashMap();
    private static final List<ItemStackPredicateType<?>> PREDICATE_LIST = new ArrayList();
    private static int idCounter = 0;
    private final int id;
    private final char key;
    private final Function<CompoundTag, T> tagDeserializer;
    private final Function<JsonElement, T> jsonDeserializer;

    public ItemStackPredicateType(char key, Function<CompoundTag, T> tagDeserializer, Function<JsonElement, T> jsonDeserializer) {
        if (Braincell.common().hasPassedInitialization()) {
            throw new UnsupportedOperationException("Cannot add more itemstack predicates after mod loading phase.");
        }
        this.id = idCounter++;
        this.key = key;
        PREDICATE_LIST.add(this);
        KEY_TO_PREDICATE.put(Character.valueOf(key), this);
        this.tagDeserializer = tagDeserializer;
        this.jsonDeserializer = jsonDeserializer;
    }

    public Function<CompoundTag, T> getTagDeserializer() {
        return this.tagDeserializer;
    }

    public Function<JsonElement, T> getJsonDeserializer() {
        return this.jsonDeserializer;
    }

    public int getId() {
        return this.id;
    }

    public char getKey() {
        return this.key;
    }

    public static ItemStackPredicateType<?> getById(int id) {
        return PREDICATE_LIST.get(id);
    }

    public static ItemStackPredicateType<?> getByKey(char key) {
        return KEY_TO_PREDICATE.getOrDefault(Character.valueOf(key), ItemStackPredicateTypes.ITEM);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackPredicateType that = (ItemStackPredicateType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

